/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

class SmartTypingConfigurationBlock
extends AbstractConfigurationBlock {
    public SmartTypingConfigurationBlock(OverlayPreferenceStore store) {
        super(store);
        store.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        return new OverlayPreferenceStore.OverlayKey[]{new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smartPaste"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "importsOnPaste"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeStrings"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeBrackets"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeBraces"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeJavaDocs"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wrapStrings"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "escapeStrings"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "addJavaDocTags"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smart_semicolon"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smart_tab"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smart_opening_brace"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smartIndentAfterNewline")};
    }

    @Override
    public Control createControl(Composite parent) {
        ScrolledPageContent scrolled = new ScrolledPageContent(parent, 768);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        Composite control = new Composite((Composite)scrolled, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        control.setLayout((Layout)layout);
        this.addSmartInsertModeMessage(control);
        Composite composite = this.createSubsection(control, null, PreferencesMessages.SmartTypingConfigurationBlock_autoclose_title);
        this.addAutoclosingSection(composite);
        composite = this.createSubsection(control, null, PreferencesMessages.SmartTypingConfigurationBlock_automove_title);
        this.addAutopositionSection(composite);
        composite = this.createSubsection(control, null, PreferencesMessages.SmartTypingConfigurationBlock_indentation_title);
        this.addIndentationSection(composite);
        composite = this.createSubsection(control, null, PreferencesMessages.SmartTypingConfigurationBlock_pasting_title);
        this.addPasteSection(composite);
        composite = this.createSubsection(control, null, PreferencesMessages.SmartTypingConfigurationBlock_strings_title);
        this.addStringsSection(composite);
        scrolled.setContent((Control)control);
        Point size = control.computeSize(-1, -1);
        scrolled.setMinSize(size.x, size.y);
        return scrolled;
    }

    private void addSmartInsertModeMessage(Composite parent) {
        Label label = new Label(parent, 16448);
        label.setText(PreferencesMessages.JavaEditorPreferencePage_smartInsertMode_message);
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Label fillerLabel = new Label(parent, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        fillerLabel.setLayoutData((Object)gridData);
    }

    private void addStringsSection(Composite composite) {
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        String label = PreferencesMessages.JavaEditorPreferencePage_wrapStrings;
        this.addCheckBox(composite, label, "wrapStrings", 0);
        label = PreferencesMessages.JavaEditorPreferencePage_escapeStrings;
        this.addCheckBox(composite, label, "escapeStrings", 0);
    }

    private void addPasteSection(Composite composite) {
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        String label = PreferencesMessages.JavaEditorPreferencePage_smartPaste;
        this.addCheckBox(composite, label, "smartPaste", 0);
        label = PreferencesMessages.JavaEditorPreferencePage_importsOnPaste;
        this.addCheckBox(composite, label, "importsOnPaste", 0);
    }

    private void addIndentationSection(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        this.addCheckBox(parent, PreferencesMessages.JavaEditorPreferencePage_smartAutoIndentAfterNewLine, "smartIndentAfterNewline", 0);
        this.addCheckBox(parent, PreferencesMessages.JavaEditorPreferencePage_typing_smartTab, "smart_tab", 0);
        this.createMessage(parent);
    }

    private void addAutopositionSection(Composite composite) {
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        String label = PreferencesMessages.JavaEditorPreferencePage_typing_smartSemicolon;
        this.addCheckBox(composite, label, "smart_semicolon", 0);
        label = PreferencesMessages.JavaEditorPreferencePage_typing_smartOpeningBrace;
        this.addCheckBox(composite, label, "smart_opening_brace", 0);
    }

    private void addAutoclosingSection(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        String label = PreferencesMessages.JavaEditorPreferencePage_closeStrings;
        this.addCheckBox(composite, label, "closeStrings", 0);
        label = PreferencesMessages.JavaEditorPreferencePage_closeBrackets;
        this.addCheckBox(composite, label, "closeBrackets", 0);
        label = PreferencesMessages.JavaEditorPreferencePage_closeBraces;
        this.addCheckBox(composite, label, "closeBraces", 0);
        label = PreferencesMessages.JavaEditorPreferencePage_closeJavaDocs;
        Button master = this.addCheckBox(composite, label, "closeJavaDocs", 0);
        label = PreferencesMessages.JavaEditorPreferencePage_addJavaDocTags;
        Button slave = this.addCheckBox(composite, label, "addJavaDocTags", 0);
        this.createDependency(master, (Control)slave);
    }

    private void createMessage(final Composite composite) {
        String linkTooltip = PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_tooltip;
        String indentMode = JavaPlugin.getDefault().getCombinedPreferenceStore().getString("org.eclipse.jdt.core.formatter.tabulation.char");
        String text = "tab".equals(indentMode) ? Messages.format(PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_tab_text, new String[]{Integer.toString(this.getTabDisplaySize())}) : Messages.format(PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_others_text, new String[]{Integer.toString(this.getTabDisplaySize()), Integer.toString(this.getIndentSize()), this.getIndentMode()});
        final Link link = new Link(composite, 0);
        link.setText(text);
        link.setToolTipText(linkTooltip);
        GridData gd = new GridData(4, 1, true, false);
        gd.widthHint = 300;
        link.setLayoutData((Object)gd);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)"org.eclipse.jdt.ui.preferences.CodeFormatterPreferencePage", null, null);
            }
        });
        final IPreferenceStore combinedStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){
            private boolean fHasRun = false;

            public void propertyChange(PropertyChangeEvent event) {
                if (this.fHasRun) {
                    return;
                }
                if (composite.isDisposed()) {
                    return;
                }
                String property = event.getProperty();
                if ("org.eclipse.jdt.core.formatter.tabulation.char".equals(property) || "org.eclipse.jdt.core.formatter.tabulation.size".equals(property)) {
                    this.fHasRun = true;
                    link.dispose();
                    SmartTypingConfigurationBlock.this.createMessage(composite);
                    Dialog.applyDialogFont((Control)composite);
                    composite.redraw();
                    composite.layout();
                }
            }
        };
        combinedStore.addPropertyChangeListener(propertyChangeListener);
        link.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                combinedStore.removePropertyChangeListener(propertyChangeListener);
            }
        });
    }

    private String getIndentMode() {
        String indentMode = JavaPlugin.getDefault().getCombinedPreferenceStore().getString("org.eclipse.jdt.core.formatter.tabulation.char");
        if ("space".equals(indentMode)) {
            return PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_spaces;
        }
        if ("tab".equals(indentMode)) {
            return PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_tabs;
        }
        if ("mixed".equals(indentMode)) {
            return PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_tabsAndSpaces;
        }
        Assert.isTrue((boolean)false, (String)"Illegal indent mode - must not happen");
        return null;
    }

    private int getIndentSize() {
        return CodeFormatterUtil.getIndentWidth(null);
    }

    private int getTabDisplaySize() {
        return CodeFormatterUtil.getTabWidth(null);
    }
}

