/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.HashSet;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.jdt.internal.ui.text.correction.SimilarElement;

public class SimilarElementsRequestor
extends CompletionRequestor {
    public static final int CLASSES = 2;
    public static final int INTERFACES = 4;
    public static final int ANNOTATIONS = 8;
    public static final int ENUMS = 16;
    public static final int VARIABLES = 32;
    public static final int PRIMITIVETYPES = 64;
    public static final int VOIDTYPE = 128;
    public static final int REF_TYPES = 30;
    public static final int REF_TYPES_AND_VAR = 62;
    public static final int ALL_TYPES = 126;
    private static final String[] PRIM_TYPES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private int fKind;
    private String fName;
    private HashSet<SimilarElement> fResult;

    public static SimilarElement[] findSimilarElement(ICompilationUnit cu, Name name, int kind) throws JavaModelException {
        int pos = name.getStartPosition();
        int nArguments = -1;
        String identifier = ASTNodes.getSimpleNameIdentifier((Name)name);
        String returnType = null;
        ICompilationUnit preparedCU = null;
        try {
            pos = name.isQualifiedName() ? ((QualifiedName)name).getName().getStartPosition() : name.getStartPosition() + 1;
            Javadoc javadoc = (Javadoc)ASTNodes.getParent((ASTNode)name, (int)29);
            if (javadoc != null) {
                cu = preparedCU = SimilarElementsRequestor.createPreparedCU(cu, javadoc, name.getStartPosition());
            }
            SimilarElementsRequestor requestor = new SimilarElementsRequestor(identifier, kind, nArguments, returnType);
            requestor.setIgnored(1, true);
            requestor.setIgnored(27, true);
            requestor.setIgnored(3, true);
            requestor.setIgnored(4, true);
            requestor.setIgnored(7, true);
            requestor.setIgnored(8, true);
            requestor.setIgnored(10, true);
            requestor.setIgnored(6, true);
            requestor.setIgnored(26, true);
            requestor.setIgnored(24, true);
            requestor.setIgnored(2, true);
            requestor.setIgnored(25, true);
            requestor.setIgnored(5, true);
            requestor.setIgnored(10, true);
            requestor.setIgnored(10, true);
            requestor.setIgnored(11, true);
            requestor.setIgnored(12, true);
            SimilarElement[] similarElementArray = requestor.process(cu, pos);
            return similarElementArray;
        }
        finally {
            if (preparedCU != null) {
                preparedCU.discardWorkingCopy();
            }
        }
    }

    private static ICompilationUnit createPreparedCU(ICompilationUnit cu, Javadoc comment, int wordStart) throws JavaModelException {
        int startpos = comment.getStartPosition();
        boolean isTopLevel = comment.getParent().getParent() instanceof CompilationUnit;
        char[] content = (char[])cu.getBuffer().getCharacters().clone();
        if (isTopLevel && wordStart + 6 < content.length) {
            content[startpos++] = 105;
            content[startpos++] = 109;
            content[startpos++] = 112;
            content[startpos++] = 111;
            content[startpos++] = 114;
            content[startpos++] = 116;
        }
        if (wordStart < content.length) {
            int i = startpos;
            while (i < wordStart) {
                content[i] = 32;
                ++i;
            }
        }
        ICompilationUnit newCU = cu.getWorkingCopy(null);
        newCU.getBuffer().setContents(content);
        return newCU;
    }

    private SimilarElementsRequestor(String name, int kind, int nArguments, String preferredType) {
        this.fName = name;
        this.fKind = kind;
        this.fResult = new HashSet();
    }

    private void addResult(SimilarElement elem) {
        this.fResult.add(elem);
    }

    private SimilarElement[] process(ICompilationUnit cu, int pos) throws JavaModelException {
        try {
            cu.codeComplete(pos, (CompletionRequestor)this);
            this.processKeywords();
            SimilarElement[] similarElementArray = this.fResult.toArray(new SimilarElement[this.fResult.size()]);
            return similarElementArray;
        }
        finally {
            this.fResult.clear();
        }
    }

    private boolean isKind(int kind) {
        return (this.fKind & kind) != 0;
    }

    private void processKeywords() {
        String voidType;
        if (this.isKind(64)) {
            int i = 0;
            while (i < PRIM_TYPES.length) {
                if (NameMatcher.isSimilarName(this.fName, PRIM_TYPES[i])) {
                    this.addResult(new SimilarElement(64, PRIM_TYPES[i], 50));
                }
                ++i;
            }
        }
        if (this.isKind(128) && NameMatcher.isSimilarName(this.fName, voidType = "void")) {
            this.addResult(new SimilarElement(64, voidType, 50));
        }
    }

    private static final int getKind(int flags, char[] typeNameSig) {
        if (Signature.getTypeSignatureKind((char[])typeNameSig) == 3) {
            return 32;
        }
        if (Flags.isAnnotation((int)flags)) {
            return 8;
        }
        if (Flags.isInterface((int)flags)) {
            return 4;
        }
        if (Flags.isEnum((int)flags)) {
            return 16;
        }
        return 2;
    }

    private void addType(char[] typeNameSig, int flags, int relevance) {
        int kind = SimilarElementsRequestor.getKind(flags, typeNameSig);
        if (!this.isKind(kind)) {
            return;
        }
        String fullName = new String(Signature.toCharArray((char[])Signature.getTypeErasure((char[])typeNameSig)));
        if (TypeFilter.isFiltered(fullName)) {
            return;
        }
        if (NameMatcher.isSimilarName(this.fName, Signature.getSimpleName((String)fullName))) {
            this.addResult(new SimilarElement(kind, fullName, relevance));
        }
    }

    public void accept(CompletionProposal proposal) {
        if (proposal.getKind() == 9) {
            this.addType(proposal.getSignature(), proposal.getFlags(), proposal.getRelevance());
        }
    }

    public static String[] getStaticImportFavorites(ICompilationUnit cu, final String elementName, boolean isMethod, String[] favorites) throws JavaModelException {
        StringBuffer dummyCU = new StringBuffer();
        String packName = cu.getParent().getElementName();
        IType type = cu.findPrimaryType();
        if (type == null) {
            return new String[0];
        }
        if (packName.length() > 0) {
            dummyCU.append("package ").append(packName).append(';');
        }
        dummyCU.append("public class ").append(type.getElementName()).append("{\n static {\n").append(elementName);
        int offset = dummyCU.length();
        dummyCU.append("\n}\n }");
        ICompilationUnit newCU = null;
        try {
            newCU = cu.getWorkingCopy(null);
            newCU.getBuffer().setContents(dummyCU.toString());
            final HashSet result = new HashSet();
            CompletionRequestor requestor = new CompletionRequestor(true){

                public void accept(CompletionProposal proposal) {
                    if (elementName.equals(new String(proposal.getName()))) {
                        CompletionProposal[] requiredProposals = proposal.getRequiredProposals();
                        int i = 0;
                        while (i < requiredProposals.length) {
                            CompletionProposal curr = requiredProposals[i];
                            if (curr.getKind() == 22 || curr.getKind() == 21) {
                                result.add(JavaModelUtil.concatenateName((char[])Signature.toCharArray((char[])curr.getDeclarationSignature()), (char[])curr.getName()));
                            }
                            ++i;
                        }
                    }
                }
            };
            if (isMethod) {
                requestor.setIgnored(6, false);
                requestor.setAllowsRequiredProposals(6, 22, true);
            } else {
                requestor.setIgnored(2, false);
                requestor.setAllowsRequiredProposals(2, 21, true);
            }
            requestor.setFavoriteReferences(favorites);
            newCU.codeComplete(offset, requestor);
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        finally {
            if (newCU != null) {
                newCU.discardWorkingCopy();
            }
        }
    }
}

