/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.navigator.CommonDragAdapterAssistant;

public class RepositoryDragAssistant
extends CommonDragAdapterAssistant {
    public Transfer[] getSupportedTransferTypes() {
        return new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
    }

    public boolean setDragData(DragSourceEvent event, IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
            return true;
        }
        if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
            ArrayList<String> files = new ArrayList<String>();
            for (Object selected : selection.toList()) {
                File file;
                if (!(selected instanceof FileNode) || (file = (File)((FileNode)selected).getObject()) == null || !file.exists()) continue;
                files.add(file.getAbsolutePath());
            }
            event.data = files.toArray(new String[files.size()]);
            return !files.isEmpty();
        }
        return false;
    }

    public void dragFinished(DragSourceEvent event, IStructuredSelection selection) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
        }
    }
}

