/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.groups;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.groups.GroupLaunchConfigurationDelegate;
import org.eclipse.debug.internal.core.groups.GroupLaunchElement;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.groups.CommonTabLite;
import org.eclipse.debug.internal.ui.groups.GroupLaunchConfigurationSelectionDialog;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class GroupLaunchConfigurationTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public static boolean isValidLaunchReference(ILaunchConfiguration config) {
        if (config == null) {
            return false;
        }
        return DebugUIPlugin.doLaunchConfigurationFiltering(config) && !WorkbenchActivityHelper.filterItem((Object)config);
    }

    @Override
    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[]{new GroupLaunchTab(), new CommonTabLite()};
        this.setTabs(tabs);
    }

    static abstract class ButtonComposite
    extends Composite
    implements SelectionListener {
        Button upButton;
        Button downButton;
        Button addButton;
        Button deleteButton;
        Button editButton;

        public ButtonComposite(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout());
            this.upButton = this.createPushButton(this, DebugUIMessages.GroupLaunchConfigurationTabGroup_1);
            this.downButton = this.createPushButton(this, DebugUIMessages.GroupLaunchConfigurationTabGroup_2);
            this.editButton = this.createPushButton(this, DebugUIMessages.GroupLaunchConfigurationTabGroup_3);
            this.addButton = this.createPushButton(this, DebugUIMessages.GroupLaunchConfigurationTabGroup_4);
            this.deleteButton = this.createPushButton(this, DebugUIMessages.GroupLaunchConfigurationTabGroup_5);
        }

        protected abstract void updateWidgetEnablement();

        protected Button createPushButton(Composite parent, String key) {
            Button button = SWTFactory.createPushButton(parent, key, null);
            button.addSelectionListener((SelectionListener)this);
            return button;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Widget widget = e.widget;
            if (widget == this.upButton) {
                this.upPressed();
            } else if (widget == this.downButton) {
                this.downPressed();
            } else if (widget == this.addButton) {
                this.addPressed();
            } else if (widget == this.deleteButton) {
                this.deletePressed();
            } else if (widget == this.editButton) {
                this.editPressed();
            }
        }

        protected abstract void addPressed();

        protected abstract void editPressed();

        protected abstract void deletePressed();

        protected abstract void downPressed();

        protected abstract void upPressed();
    }

    static class CheckStateProvider
    implements ICheckStateProvider {
        CheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            if (element instanceof GroupLaunchElement) {
                return ((GroupLaunchElement)element).enabled;
            }
            return false;
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }

    static class ContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        protected List<GroupLaunchElement> input;

        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
            this.input = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                this.input = (List)newInput;
            }
        }

        public Object[] getChildren(Object parentElement) {
            return parentElement == this.input ? this.input.toArray() : null;
        }

        public Object getParent(Object element) {
            return element == this.input ? null : this.input;
        }

        public boolean hasChildren(Object element) {
            return element == this.input ? this.input.size() > 0 : false;
        }
    }

    static class GroupLaunchTab
    extends AbstractLaunchConfigurationTab {
        protected CheckboxTreeViewer treeViewer;
        protected List<GroupLaunchElement> input = new ArrayList<GroupLaunchElement>();
        private ILaunchConfiguration self;

        GroupLaunchTab() {
        }

        @Override
        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 0);
            this.setControl((Control)comp);
            comp.setLayout((Layout)new GridLayout(2, false));
            this.treeViewer = new CheckboxTreeViewer(comp, 68354);
            Tree table = this.treeViewer.getTree();
            table.setFont(parent.getFont());
            this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.treeViewer.setCheckStateProvider((ICheckStateProvider)new CheckStateProvider());
            table.setHeaderVisible(true);
            table.setLayoutData((Object)new GridData(1808));
            TreeColumn col1 = new TreeColumn(table, 0);
            col1.setText(DebugUIMessages.GroupLaunchConfigurationTabGroup_6);
            col1.setWidth(300);
            TreeColumn col2 = new TreeColumn(table, 0);
            col2.setText(DebugUIMessages.GroupLaunchConfigurationTabGroup_7);
            col2.setWidth(100);
            TreeColumn col3 = new TreeColumn(table, 0);
            col3.setText(DebugUIMessages.GroupLaunchConfigurationTabGroup_12);
            col3.setWidth(100);
            this.treeViewer.setInput(this.input);
            final ButtonComposite buts = new ButtonComposite(comp, 0){

                @Override
                protected void addPressed() {
                    GroupLaunchConfigurationSelectionDialog dialog = GroupLaunchConfigurationSelectionDialog.createDialog(treeViewer.getControl().getShell(), GroupLaunchElement.MODE_INHERIT, false, self);
                    if (dialog.open() == 0) {
                        ILaunchConfiguration[] configs = dialog.getSelectedLaunchConfigurations();
                        if (configs.length < 1) {
                            return;
                        }
                        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
                        int n = configs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                            GroupLaunchElement el = new GroupLaunchElement();
                            input.add(el);
                            el.index = input.size() - 1;
                            el.enabled = true;
                            this.applyFromDialog(el, dialog, config);
                            treeViewer.refresh(true);
                            treeViewer.setChecked((Object)el, el.enabled);
                            ++n2;
                        }
                        this.updateWidgetEnablement();
                        this.updateLaunchConfigurationDialog();
                    }
                }

                @Override
                protected void updateWidgetEnablement() {
                    this.downButton.setEnabled(this.isDownEnabled());
                    this.upButton.setEnabled(this.isUpEnabled());
                    int selectionCount = this.getSelectionCount();
                    this.editButton.setEnabled(selectionCount == 1);
                    this.deleteButton.setEnabled(selectionCount > 0);
                }

                @Override
                protected void editPressed() {
                    int index = this.getSingleSelectionIndex();
                    if (index < 0) {
                        return;
                    }
                    GroupLaunchElement el = input.get(index);
                    GroupLaunchConfigurationSelectionDialog dialog = GroupLaunchConfigurationSelectionDialog.createDialog(treeViewer.getControl().getShell(), el.mode, true, self);
                    if (GroupLaunchConfigurationTabGroup.isValidLaunchReference(el.data)) {
                        dialog.setInitialSelection(el);
                    }
                    if (dialog.open() == 0) {
                        ILaunchConfiguration[] confs = dialog.getSelectedLaunchConfigurations();
                        if (confs.length < 0) {
                            return;
                        }
                        if (!$assertionsDisabled && confs.length != 1) {
                            throw new AssertionError((Object)"invocation of the dialog for editing an entry sholdn't allow OK to be hit if the user chooses multiple launch configs in the dialog");
                        }
                        this.applyFromDialog(el, dialog, confs[0]);
                        treeViewer.refresh(true);
                        this.updateWidgetEnablement();
                        this.updateLaunchConfigurationDialog();
                    }
                }

                private void applyFromDialog(GroupLaunchElement el, GroupLaunchConfigurationSelectionDialog dialog, ILaunchConfiguration config) {
                    el.name = config.getName();
                    el.data = config;
                    el.mode = dialog.getMode();
                    el.action = dialog.getAction();
                    el.adoptIfRunning = dialog.getAdoptIfRunning();
                    el.actionParam = dialog.getActionParam();
                }

                @Override
                protected void deletePressed() {
                    int[] indices = this.getMultiSelectionIndices();
                    if (indices.length < 1) {
                        return;
                    }
                    int i = indices.length - 1;
                    while (i >= 0) {
                        input.remove(indices[i]);
                        --i;
                    }
                    treeViewer.refresh(true);
                    this.updateWidgetEnablement();
                    this.updateLaunchConfigurationDialog();
                }

                private int getSingleSelectionIndex() {
                    StructuredSelection sel = (StructuredSelection)treeViewer.getSelection();
                    if (sel.size() != 1) {
                        return -1;
                    }
                    GroupLaunchElement el = (GroupLaunchElement)sel.getFirstElement();
                    return input.indexOf(el);
                }

                private int[] getMultiSelectionIndices() {
                    StructuredSelection sel = (StructuredSelection)treeViewer.getSelection();
                    ArrayList<Integer> indices = new ArrayList<Integer>();
                    for (GroupLaunchElement el : sel) {
                        indices.add(input.indexOf(el));
                    }
                    int[] result = new int[indices.size()];
                    int i = 0;
                    while (i < result.length) {
                        result[i] = (Integer)indices.get(i);
                        ++i;
                    }
                    return result;
                }

                private int getSelectionCount() {
                    return ((StructuredSelection)treeViewer.getSelection()).size();
                }

                @Override
                protected void downPressed() {
                    if (!this.isDownEnabled()) {
                        return;
                    }
                    int index = this.getSingleSelectionIndex();
                    GroupLaunchElement x = input.get(index);
                    input.set(index, input.get(index + 1));
                    input.set(index + 1, x);
                    treeViewer.refresh(true);
                    this.updateWidgetEnablement();
                    this.updateLaunchConfigurationDialog();
                }

                protected boolean isDownEnabled() {
                    int index = this.getSingleSelectionIndex();
                    return index >= 0 && index != input.size() - 1;
                }

                protected boolean isUpEnabled() {
                    return this.getSingleSelectionIndex() > 0;
                }

                @Override
                protected void upPressed() {
                    if (!this.isUpEnabled()) {
                        return;
                    }
                    int index = this.getSingleSelectionIndex();
                    GroupLaunchElement x = input.get(index);
                    input.set(index, input.get(index - 1));
                    input.set(index - 1, x);
                    treeViewer.refresh(true);
                    this.updateWidgetEnablement();
                    this.updateLaunchConfigurationDialog();
                }
            };
            this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    buts.updateWidgetEnablement();
                }
            });
            this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    buts.editPressed();
                }
            });
            this.treeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    ((GroupLaunchElement)event.getElement()).enabled = event.getChecked();
                    this.updateLaunchConfigurationDialog();
                }
            });
            buts.updateWidgetEnablement();
            GridData layoutData = new GridData(1024);
            layoutData.verticalAlignment = 1;
            buts.setLayoutData(layoutData);
        }

        @Override
        public String getName() {
            return DebugUIMessages.GroupLaunchConfigurationTabGroup_10;
        }

        @Override
        public Image getImage() {
            return DebugUITools.getImage("IMG_OBJ_LAUNCH_GROUP");
        }

        @Override
        public void initializeFrom(ILaunchConfiguration configuration) {
            try {
                this.self = configuration.copy(configuration.getName());
            }
            catch (CoreException e) {
                DebugPlugin.log((Throwable)e);
            }
            this.input = GroupLaunchConfigurationDelegate.createLaunchElements((ILaunchConfiguration)configuration);
            if (this.treeViewer != null) {
                this.treeViewer.setInput(this.input);
            }
        }

        @Override
        public void performApply(ILaunchConfigurationWorkingCopy configuration) {
            GroupLaunchConfigurationDelegate.storeLaunchElements((ILaunchConfigurationWorkingCopy)configuration, this.input);
        }

        @Override
        public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        }

        @Override
        public boolean isValid(ILaunchConfiguration launchConfig) {
            this.setMessage(null);
            this.setErrorMessage(null);
            int validLaunches = 0;
            for (GroupLaunchElement element : this.input) {
                if (!element.enabled) continue;
                if (element.data == null) {
                    this.setErrorMessage(MessageFormat.format(DebugUIMessages.GroupLaunchConfigurationTabGroup_14, element.name));
                    return false;
                }
                if (!GroupLaunchConfigurationTabGroup.isValidLaunchReference(element.data)) {
                    this.setErrorMessage(MessageFormat.format(DebugUIMessages.GroupLaunchConfigurationTabGroup_15, element.name));
                    return false;
                }
                ++validLaunches;
            }
            if (validLaunches < 1) {
                this.setErrorMessage(DebugUIMessages.GroupLaunchConfigurationTabGroup_16);
                return false;
            }
            return true;
        }
    }

    static class LabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (!(element instanceof GroupLaunchElement)) {
                return null;
            }
            if (columnIndex == 0) {
                GroupLaunchElement el = (GroupLaunchElement)element;
                if (el.data == null || !GroupLaunchConfigurationTabGroup.isValidLaunchReference(el.data)) {
                    Image errorImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    return errorImage;
                }
                try {
                    String key = el.data.getType().getIdentifier();
                    return DebugPluginImages.getImage(key);
                }
                catch (CoreException coreException) {
                    Image errorImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    return errorImage;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof GroupLaunchElement)) {
                return null;
            }
            GroupLaunchElement el = (GroupLaunchElement)element;
            if (columnIndex == 0) {
                try {
                    return el.data != null ? String.valueOf(el.data.getType().getName()) + "::" + el.name : el.name;
                }
                catch (CoreException coreException) {
                    return el.name;
                }
            }
            if (columnIndex == 1) {
                return String.valueOf(el.mode) + (el.adoptIfRunning ? DebugUIMessages.GroupLaunchConfigurationTabGroup_lblAdopt : "");
            }
            if (columnIndex == 2) {
                GroupLaunchElement.GroupElementPostLaunchAction action = el.action;
                switch (action) {
                    case NONE: {
                        return "";
                    }
                    case WAIT_FOR_TERMINATION: {
                        return action.getDescription();
                    }
                    case DELAY: {
                        Object actionParam = el.actionParam;
                        return NLS.bind((String)DebugUIMessages.GroupLaunchConfigurationTabGroup_13, (Object)(actionParam instanceof Integer ? Integer.toString((Integer)actionParam) : "?"));
                    }
                    case OUTPUT_REGEXP: {
                        return NLS.bind((String)DebugUIMessages.GroupLaunchConfigurationTabGroup_0, (Object)el.actionParam);
                    }
                }
                assert (false) : "new post launch action missing logic here";
                return "";
            }
            return null;
        }
    }
}

