/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.target;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.wizards.PDEWizardNewFileCreationPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class TargetDefinitionWizardPage
extends PDEWizardNewFileCreationPage {
    protected static final int USE_EMPTY = 0;
    protected static final int USE_DEFAULT = 1;
    protected static final int USE_CURRENT_TP = 2;
    protected static final int USE_EXISTING_TARGET = 3;
    private Button fEmptyButton;
    private Button fDefaultButton;
    private Button fCurrentTPButton;
    private Button fExistingTargetButton;
    private Combo fTargets;
    private String[] fTargetIds;
    private static String EXTENSION = "target";

    public TargetDefinitionWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setTitle(PDEUIMessages.TargetProfileWizardPage_title);
        this.setDescription(PDEUIMessages.TargetProfileWizardPage_description);
        this.setFileExtension(EXTENSION);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.target_definition_page");
    }

    protected void createAdvancedControls(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808);
        SWTFactory.createLabel(comp, PDEUIMessages.TargetCreationPage_0, 2);
        this.fEmptyButton = SWTFactory.createRadioButton(comp, PDEUIMessages.TargetCreationPage_1, 2);
        this.fDefaultButton = SWTFactory.createRadioButton(comp, PDEUIMessages.TargetCreationPage_2, 2);
        this.fCurrentTPButton = SWTFactory.createRadioButton(comp, PDEUIMessages.TargetCreationPage_3, 2);
        this.fExistingTargetButton = SWTFactory.createRadioButton(comp, PDEUIMessages.TargetCreationPage_4, 1);
        this.fExistingTargetButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean enabled = this.fExistingTargetButton.getSelection();
            this.fTargets.setEnabled(enabled);
        }));
        this.fEmptyButton.setSelection(true);
        this.fTargets = SWTFactory.createCombo(comp, 12, 1, 1, null);
        this.fTargets.setEnabled(false);
        this.initializeTargetCombo();
        Dialog.applyDialogFont((Control)comp);
        this.setControl((Control)comp);
    }

    protected void initializeTargetCombo() {
        IConfigurationElement[] elements = PDECore.getDefault().getTargetProfileManager().getSortedTargets();
        this.fTargetIds = new String[elements.length];
        int i = 0;
        while (i < elements.length) {
            String name = elements[i].getAttribute("name");
            if (this.fTargets.indexOf(name) == -1) {
                this.fTargets.add(name);
            }
            this.fTargetIds[i] = elements[i].getAttribute("id");
            ++i;
        }
        if (elements.length > 0) {
            this.fTargets.select(0);
        }
    }

    protected int getInitializationOption() {
        if (this.fEmptyButton.getSelection()) {
            return 0;
        }
        if (this.fDefaultButton.getSelection()) {
            return 1;
        }
        if (this.fCurrentTPButton.getSelection()) {
            return 2;
        }
        return 3;
    }

    protected String getTargetId() {
        return this.fTargetIds[this.fTargets.getSelectionIndex()];
    }
}

