/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching.macosx;

import java.io.File;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.internal.launching.macosx.MacOSXDebugVMRunner;
import org.eclipse.jdt.internal.launching.macosx.MacOSXVMInstallType;
import org.eclipse.jdt.internal.launching.macosx.MacOSXVMRunner;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.osgi.util.NLS;

public class MacOSXVMInstall
extends AbstractVMInstall {
    MacOSXVMInstall(IVMInstallType type, String id) {
        super(type, id);
    }

    public IVMRunner getVMRunner(String mode) {
        if ("run".equals(mode)) {
            return new MacOSXVMRunner((IVMInstall)this);
        }
        if ("debug".equals(mode)) {
            return new MacOSXDebugVMRunner((IVMInstall)this);
        }
        return null;
    }

    public String getJavaVersion() {
        File installLocation = this.getInstallLocation();
        if (installLocation != null) {
            File executable = StandardVMType.findJavaExecutable((File)installLocation);
            if (executable != null) {
                MacOSXVMInstallType installType = (MacOSXVMInstallType)this.getVMInstallType();
                String vmVersion = installType.getVMVersion(installLocation, executable);
                StringBuffer version = new StringBuffer();
                int i = 0;
                while (i < vmVersion.length()) {
                    char ch = vmVersion.charAt(i);
                    if (!Character.isDigit(ch) && ch != '.') break;
                    version.append(ch);
                    ++i;
                }
                if (version.length() > 0) {
                    return version.toString();
                }
            }
            LaunchingPlugin.log((String)NLS.bind((String)LaunchingMessages.vmInstall_could_not_determine_java_Version, (Object)installLocation.getAbsolutePath()));
        }
        return null;
    }
}

