/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.swt.TeslaSWTMessages;
import org.eclipse.rcptt.tesla.swt.reflection.JavaMembersHelper;
import org.eclipse.rcptt.tesla.ui.SWTTeslaActivator;
import org.eclipse.rcptt.util.StringUtils;

public class IdentifyObjectUtil {
    public static String getObjectIdByClassMethods(Object object) throws CoreException {
        String methods = TeslaFeatures.getInstance().getValue("org.eclipse.rcptt.tesla.identify.by.class.methods");
        if (StringUtils.isBlank((String)methods)) {
            return null;
        }
        String[] stringArray = methods.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String method = stringArray[n2];
            String[] methodInfo = method.split(":");
            if (methodInfo.length == 2) {
                String className = methodInfo[0].trim();
                String idPath = methodInfo[1].trim();
                Class<?> clazz = object.getClass();
                if (className.equals(clazz.getSimpleName()) || className.equals(clazz.getName())) {
                    try {
                        String id = JavaMembersHelper.getPropertyValue(object, idPath);
                        if (!StringUtils.isBlank((String)id)) {
                            return id;
                        }
                    }
                    catch (Exception e) {
                        String errorMessage = NLS.bind((String)TeslaSWTMessages.IdentifyObjectUtil_FailedToInvokeMethod, (Object)idPath, (Object)className);
                        throw new CoreException(SWTTeslaActivator.createStatus(errorMessage, e));
                    }
                }
            }
            ++n2;
        }
        return null;
    }
}

