/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.rcptt.tesla.core.Q7WaitUtils;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.swt.events.ITeslaBrowserListener;
import org.eclipse.rcptt.tesla.swt.events.TeslaBrowserManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

public class BrowserManager
implements ITeslaBrowserListener {
    private static final long TIMEOUT = 20000L;
    private static BrowserManager browserManager;
    private Map<Browser, Long> timeouts = new WeakHashMap<Browser, Long>();
    ProgressListener progressListener = new ProgressListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(ProgressEvent event) {
            if (event.getSource() instanceof Browser) {
                Browser br = (Browser)event.getSource();
                Map map = BrowserManager.this.timeouts;
                synchronized (map) {
                    BrowserManager.this.timeouts.remove(br);
                }
            }
        }

        public void changed(ProgressEvent event) {
        }
    };
    LocationListener locationListener = new LocationListener(){

        public void changing(LocationEvent event) {
        }

        public void changed(LocationEvent event) {
            if (event.getSource() instanceof Browser) {
                Browser br = (Browser)event.getSource();
                if (ContextManagement.currentContext().contains("org.eclipse.swt.browser.Browser", "setText")) {
                    return;
                }
                BrowserManager.this.makeChanged(br);
            }
        }
    };
    DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (e.getSource() instanceof Browser) {
                Browser br = (Browser)e.getSource();
                BrowserManager.this.disconnect(br);
            }
        }
    };

    public BrowserManager() {
        Browser[] browsers;
        Browser[] browserArray = browsers = TeslaBrowserManager.getManager().getBrowsers();
        int n = browsers.length;
        int n2 = 0;
        while (n2 < n) {
            Browser browser = browserArray[n2];
            this.browserAdded(browser);
            ++n2;
        }
    }

    public synchronized void browserAdded(final Browser br) {
        if (br.isDisposed()) {
            return;
        }
        br.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (br.isDisposed()) {
                    return;
                }
                br.addProgressListener(BrowserManager.this.progressListener);
                br.addLocationListener(BrowserManager.this.locationListener);
                br.addDisposeListener(BrowserManager.this.disposeListener);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isExecutionAllowed(Q7WaitInfoRoot info) {
        HashSet<Browser> result = new HashSet<Browser>();
        long currentTimeMillis = System.currentTimeMillis();
        Map<Browser, Long> map = this.timeouts;
        synchronized (map) {
            for (Browser browser : this.timeouts.keySet()) {
                Long t;
                if (browser == null || browser.isDisposed() || currentTimeMillis > (t = this.timeouts.get(browser)) + 20000L) continue;
                Q7WaitUtils.updateInfo((String)"browser", (String)browser.getUrl(), (Q7WaitInfoRoot)info);
                result.add(browser);
            }
        }
        return result.isEmpty();
    }

    public void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void browserSetText(Browser browser) {
        Map<Browser, Long> map = this.timeouts;
        synchronized (map) {
            this.timeouts.remove(browser);
        }
    }

    public void browserChanged(Browser browser) {
        this.makeChanged(browser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeChanged(Browser br) {
        Map<Browser, Long> map = this.timeouts;
        synchronized (map) {
            this.timeouts.put(br, System.currentTimeMillis());
        }
    }

    public void shutdown() {
        Browser[] browsers;
        Browser[] browserArray = browsers = TeslaBrowserManager.getManager().getBrowsers();
        int n = browsers.length;
        int n2 = 0;
        while (n2 < n) {
            Browser browser = browserArray[n2];
            this.disconnect(browser);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(final Browser br) {
        if (br == null || br.isDisposed()) {
            return;
        }
        Map<Browser, Long> map = this.timeouts;
        synchronized (map) {
            this.timeouts.remove(br);
        }
        br.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!br.isDisposed()) {
                    br.removeProgressListener(BrowserManager.this.progressListener);
                    br.removeLocationListener(BrowserManager.this.locationListener);
                    br.removeDisposeListener(BrowserManager.this.disposeListener);
                }
            }
        });
    }

    public static synchronized BrowserManager getInstance() {
        if (browserManager == null) {
            browserManager = new BrowserManager();
            TeslaBrowserManager.getManager().addEventListener((ITeslaBrowserListener)browserManager);
        }
        return browserManager;
    }
}

