/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.IWeavingService;
import org.eclipse.equinox.weaving.aspectj.AspectAdmin;
import org.eclipse.equinox.weaving.aspectj.AspectConfiguration;
import org.eclipse.equinox.weaving.aspectj.AspectJWeavingStarter;
import org.eclipse.equinox.weaving.aspectj.loadtime.AspectResolver;
import org.eclipse.equinox.weaving.aspectj.loadtime.OSGiWeavingAdaptor;
import org.eclipse.equinox.weaving.aspectj.loadtime.OSGiWeavingContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public class AspectJWeavingService
implements IWeavingService {
    private List<Definition> aspectDefinitions;
    private BundleRevision bundleRevision;
    private boolean enabled;
    private String namespaceAddOn;
    private OSGiWeavingAdaptor weavingAdaptor;
    private OSGiWeavingContext weavingContext;

    public AspectJWeavingService() {
        if (AspectJWeavingStarter.DEBUG) {
            System.out.println("- WeavingService.<init>");
        }
    }

    public AspectJWeavingService(ClassLoader classLoader, Bundle bundle, BundleRevision bundleRevision, ISupplementerRegistry iSupplementerRegistry, AspectAdmin aspectAdmin) {
        this.bundleRevision = bundleRevision;
        AspectResolver aspectResolver = new AspectResolver(iSupplementerRegistry, aspectAdmin, AspectJWeavingStarter.getDefault().getContext());
        AspectConfiguration aspectConfiguration = aspectResolver.resolveAspectsFor(bundle, bundleRevision);
        this.namespaceAddOn = aspectConfiguration.getFingerprint();
        this.aspectDefinitions = aspectConfiguration.getAspectDefinitions();
        boolean bl = this.enabled = this.aspectDefinitions.size() > 0;
        if (this.enabled) {
            this.weavingContext = new OSGiWeavingContext(classLoader, bundleRevision, this.aspectDefinitions);
            this.weavingAdaptor = new OSGiWeavingAdaptor(classLoader, this.weavingContext, this.namespaceAddOn.toString());
        } else if (AspectJWeavingStarter.DEBUG) {
            System.err.println("[org.eclipse.equinox.weaving.aspectj] info not weaving bundle '" + bundle.getSymbolicName() + "'");
        }
    }

    private void ensureAdaptorInit() {
        this.weavingAdaptor.initialize();
    }

    public void flushGeneratedClasses(ClassLoader classLoader) {
        if (this.enabled) {
            this.ensureAdaptorInit();
            this.weavingAdaptor.flushGeneratedClasses();
        }
    }

    public boolean generatedClassesExistFor(ClassLoader classLoader, String string) {
        if (this.enabled) {
            this.ensureAdaptorInit();
            return this.weavingAdaptor.generatedClassesExistFor(string);
        }
        return false;
    }

    public Map<String, byte[]> getGeneratedClassesFor(String string) {
        if (this.enabled) {
            this.ensureAdaptorInit();
            return this.weavingAdaptor.getGeneratedClassesFor(string);
        }
        return new HashMap<String, byte[]>();
    }

    public String getKey() {
        if (AspectJWeavingStarter.DEBUG) {
            System.out.println("> WeavingService.getKey() bundle=" + this.bundleRevision.getSymbolicName());
        }
        String string = this.namespaceAddOn.toString();
        if (AspectJWeavingStarter.DEBUG) {
            System.out.println("< WeavingService.getKey() key='" + string + "'");
        }
        return string;
    }

    public byte[] preProcess(String string, byte[] byArray, ClassLoader classLoader) throws IOException {
        if (this.enabled) {
            if (AspectJWeavingStarter.DEBUG) {
                System.out.println("> WeavingService.preProcess() bundle=" + this.bundleRevision.getSymbolicName() + ", name=" + string + ", bytes=" + byArray.length);
            }
            this.ensureAdaptorInit();
            byte[] byArray2 = this.weavingAdaptor.weaveClass(string, byArray, false);
            if (AspectJWeavingStarter.DEBUG) {
                System.out.println("< WeavingService.preProcess() bytes=" + byArray2.length);
            }
            return byArray2;
        }
        return null;
    }
}

