/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.recording;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.ecl.core.model.CreateReport;
import org.eclipse.rcptt.core.ecl.core.model.ExecVerification;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.core.ecl.core.model.SetQ7Features;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.recording.CommandSet;
import org.eclipse.rcptt.core.recording.IRecordingListener;
import org.eclipse.rcptt.core.recording.IRecordingMonitor;
import org.eclipse.rcptt.core.recording.NetworkRecorder;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.core.utils.ModelCycleDetector;
import org.eclipse.rcptt.core.workspace.IWorkspaceFinder;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.core.workspace.WorkspaceFinder;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Q7Element;
import org.eclipse.rcptt.internal.core.model.Q7InternalTestCase;
import org.eclipse.rcptt.internal.launching.ExecutionStatus;
import org.eclipse.rcptt.internal.launching.Q7LaunchManager;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutLaunchState;
import org.eclipse.rcptt.launching.Q7LaunchUtils;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.launching.utils.TestSuiteUtils;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.ReportingFactory;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.TeslaScenarioContainer;
import org.eclipse.rcptt.tesla.core.network.TeslaNetworkReplayer;
import org.eclipse.rcptt.tesla.core.protocol.WaitForRestart;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaScenario;
import org.eclipse.rcptt.tesla.core.utils.TeslaUtils;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;
import org.eclipse.rcptt.tesla.internal.core.network.DefaultConnectionMonitor;
import org.eclipse.rcptt.tesla.recording.core.ITeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.ecl.EclRecorder;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.launching.aut.AUTConnectionErrorDialog;
import org.eclipse.rcptt.ui.launching.aut.AutElement;
import org.eclipse.rcptt.ui.panels.main.ControlPanelWindow;
import org.eclipse.rcptt.ui.recording.RecordingContextManager;
import org.eclipse.rcptt.ui.recording.UiNetworkRecorder;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class RecordingSupport {
    private final ControlPanelWindow window;
    private Scenario previous;
    private final Scenario scenarioWorkingCopy;
    private final Scenario originalScenario;
    private final WritableValue autObservable = new WritableValue(null, AutElement.class);
    private final WritableValue modeObservable = new WritableValue((Object)RecordingMode.Stopped, RecordingMode.class);
    private TeslaNetworkReplayer player;
    private UiNetworkRecorder recorder;
    private final IRecordingMonitor recordingMonitor = new RecordingMonitor();
    private final List<IRecordingListener> recordingListeners = new ArrayList<IRecordingListener>();

    public RecordingSupport(ControlPanelWindow window, Scenario scenarioWorkingCopy, Scenario originalScenario) {
        this.window = window;
        this.scenarioWorkingCopy = scenarioWorkingCopy;
        this.originalScenario = originalScenario;
        this.addRecordingListener(new RecordingListener());
        this.modeObservable.addChangeListener((IChangeListener)new RecordingModeListener());
        RecordingContextManager.Instance.observeRecordModeShortcuts().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
            }
        });
        RecordingContextManager.Instance.observeAssertModeShortcuts().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
            }
        });
        RecordingContextManager.Instance.observeStartRecordShortcuts().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
            }
        });
        RecordingContextManager.Instance.observeStopRecordShortcuts().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
            }
        });
        RecordingContextManager.Instance.observeReplayShortcuts().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
            }
        });
    }

    public synchronized void addRecordingListener(IRecordingListener listener) {
        if (!this.recordingListeners.contains(listener)) {
            this.recordingListeners.add(listener);
        }
    }

    public synchronized void removeRecordingListener(IRecordingListener listener) {
        this.recordingListeners.remove(listener);
    }

    public AutLaunch getAUT() {
        final AutLaunch[] aut = new AutLaunch[1];
        Q7UIPlugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                aut[0] = (AutLaunch)RecordingSupport.this.autObservable.getValue();
            }
        });
        return aut[0];
    }

    public void setAUT(AutLaunch aut) {
        this.autObservable.setValue((Object)aut);
    }

    public IObservableValue observeAUT() {
        return this.autObservable;
    }

    public RecordingMode getMode() {
        final RecordingMode[] mode = new RecordingMode[1];
        Q7UIPlugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                mode[0] = (RecordingMode)((Object)RecordingSupport.this.modeObservable.getValue());
            }
        });
        return mode[0];
    }

    public void setMode(final RecordingMode mode) {
        Q7UIPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                RecordingSupport.this.modeObservable.setValue((Object)mode);
            }
        });
    }

    public IObservableValue observeMode() {
        return this.modeObservable;
    }

    public NetworkRecorder getRecorder() {
        return this.recorder;
    }

    private boolean selectAUT() {
        final boolean[] result = new boolean[1];
        Q7UIPlugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AutLaunch launch = (AutLaunch)RecordingSupport.this.autObservable.getValue();
                if (launch != null && !launch.getState().equals((Object)AutLaunchState.TERMINATE)) {
                    result[0] = true;
                    return;
                }
                AutLaunch aut = LaunchUtils.selectAutLaunch(RecordingSupport.this.window.getShell());
                RecordingSupport.this.setAUT(aut);
                result[0] = aut != null;
            }
        });
        return result[0];
    }

    private void runWithProgress(final String name, final IRunnableWithProgress runnable, final boolean fork) {
        new Job(name){

            protected IStatus run(IProgressMonitor monitor) {
                RecordingSupport.this.window.runWithProgress(name, runnable, fork);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void replay() {
        ReplayRunnable runnable = new ReplayRunnable(this, Messages.RecordingSupport_ReplayingOp){

            @Override
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    super.run(monitor);
                }
                finally {
                    this.setMode(RecordingMode.Stopped);
                }
            }
        };
        this.runWithProgress(runnable.getName(), runnable, true);
    }

    private void record() {
        ReplayRunnable replaying = new ReplayRunnable(this, Messages.RecordingSupport_InitialStateOp){

            @Override
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        super.run(monitor);
                        if (monitor.isCanceled() || this.getMode() == RecordingMode.Stopped) {
                            if (monitor.isCanceled()) {
                                this.setMode(RecordingMode.Stopped);
                            }
                            throw new InterruptedException();
                        }
                        this.connect();
                    }
                    catch (InvocationTargetException e) {
                        this.setMode(RecordingMode.Stopped);
                        throw e;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        this.runWithProgress(replaying.getName(), replaying, true);
    }

    private void connect() {
        ConnectionRunnable connecting = new ConnectionRunnable();
        this.runWithProgress(Messages.RecordingSupport_ConnectingOp, connecting, true);
    }

    private void waitForAUTRestart() {
        WaitForAUTRestartRunnable restarting = new WaitForAUTRestartRunnable(this){

            @Override
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                super.run(monitor);
                if (monitor.isCanceled() || this.getMode() == RecordingMode.Stopped) {
                    throw new InterruptedException();
                }
                this.connect();
            }
        };
        this.runWithProgress(Messages.RecordingSupport_WaitingOp, restarting, true);
    }

    private synchronized void recordingMode() {
        try {
            this.recorder.toRecordMode();
            TeslaFeatures.getInstance().getOption("org.eclipse.rcptt.tesla.recording.iml.imaging.use").setValue("false");
            this.sendFeatures();
        }
        catch (Exception e) {
            Q7UIPlugin.log(e);
        }
    }

    private synchronized void assertingMode() {
        if (this.recorder == null) {
            return;
        }
        try {
            this.recorder.toAssertMode(new String[0]);
            TeslaFeatures.getInstance().getOption("org.eclipse.rcptt.tesla.recording.iml.imaging.use").setValue("false");
            this.sendFeatures();
        }
        catch (Exception e) {
            Q7UIPlugin.log(e);
        }
    }

    private synchronized void imageRecognitionMode() {
        try {
            this.setMode(RecordingMode.ImageRecognition);
            TeslaFeatures.getInstance().getOption("org.eclipse.rcptt.tesla.recording.iml.imaging.use").setValue("true");
            this.sendFeatures();
        }
        catch (Exception e) {
            Q7UIPlugin.log(e);
        }
    }

    public synchronized void sendFeatures() {
        SetQ7Features setQ7Features = Q7CoreFactory.eINSTANCE.createSetQ7Features();
        TeslaFeatures.getInstance().storeValues((List)setQ7Features.getFeatures());
        Q7Features.getInstance().storeValues((List)setQ7Features.getFeatures());
        if (this.originalScenario != null) {
            Q7LaunchUtils.setQ7Variable((SetQ7Features)setQ7Features, (String)"current_test", (String)this.originalScenario.getName());
        }
        try {
            this.getAUT().execute((org.eclipse.rcptt.ecl.core.Command)setQ7Features);
        }
        catch (Exception e) {
            Q7UIPlugin.log(e);
        }
    }

    private synchronized void stop() {
        AutLaunch aut;
        if (this.player != null && this.player.isConnected()) {
            this.player.cancelConnection();
        }
        if (this.recorder != null && this.recorder.isConnected()) {
            this.recorder.cancelConnection();
        }
        if ((aut = this.getAUT()) != null) {
            try {
                if (Q7LaunchManager.getInstance().isDebuggingActive(aut)) {
                    return;
                }
                ((BaseAutLaunch)aut).execute((org.eclipse.rcptt.ecl.core.Command)TeslaFactory.eINSTANCE.createShoutdownPlayer(), 10000L);
            }
            catch (CoreException e) {
                AUTConnectionErrorDialog.showAUTConnectionError(this.window.getShell(), e.getStatus(), aut.getAut().getConfig());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private IWorkspaceFinder getFinder() {
        return WorkspaceFinder.getInstance();
    }

    private synchronized void updateContent() {
        TeslaScenarioContainer container = this.recorder.getContainer();
        TeslaScenario recordedTesla = container.getScenarioCopy();
        TeslaScenario tesla = Scenarios.getTesla((Scenario)this.previous);
        TeslaScenario newTeslaContent = tesla == null ? recordedTesla : TeslaUtils.merge((TeslaScenario)tesla, (TeslaScenario)recordedTesla);
        Scenarios.setTesla((Scenario)this.scenarioWorkingCopy, (TeslaScenario)newTeslaContent);
        if (Scenarios.hasUserModifications((Scenario)this.previous)) {
            Script script = Scenarios.getEcl((Scenario)this.previous);
            String prevContent = script.getContent();
            String recordedContent = new EclRecorder().generateCode(recordedTesla);
            if (prevContent == null || prevContent.length() == 0) {
                Scenarios.setEclContent((Scenario)this.scenarioWorkingCopy, (String)recordedContent);
            } else {
                Scenarios.setEclContent((Scenario)this.scenarioWorkingCopy, (String)(String.valueOf(prevContent) + "\n" + recordedContent));
            }
        }
    }

    public Job getUpdateContentJob() {
        return new Job("Update ECL content"){

            protected IStatus run(IProgressMonitor monitor) {
                RecordingSupport.this.updateContent();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return RecordingSupport.class.equals(family);
            }
        };
    }

    public void createReport(AutLaunch aut, ITestCase testCase) throws CoreException, InterruptedException {
        CreateReport createReport = Q7CoreFactory.eINSTANCE.createCreateReport();
        if (testCase != null) {
            createReport.setName(testCase.getName());
            createReport.setQ7info(TestSuiteUtils.getQ7Info((IQ7NamedElement)testCase));
        } else {
            createReport.setName("q7.control.panel.recording");
            Q7Info info = ReportingFactory.eINSTANCE.createQ7Info();
            info.setType(ItemKind.TESTCASE);
            info.setId("some_id");
            info.setTags("");
            info.setDescription("");
            createReport.setQ7info(info);
        }
        this.getAUT().execute((org.eclipse.rcptt.ecl.core.Command)createReport);
    }

    public void addVerification(IVerification verification) {
        try {
            this.scenarioWorkingCopy.getVerifications().add((Object)verification.getID());
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
    }

    private final class ConnectionRunnable
    implements IRunnableWithProgress {
        private static final int TIMEOUT = 150;
        private final UIJob waitForConnectionJob = new UIJob(PlatformUI.getWorkbench().getDisplay(), Messages.RecordingSupport_ConnectingOp){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.RecordingSupport_ConnectingOp, 150);
                    start = System.currentTimeMillis();
lbl4:
                    // 2 sources

                    while (true) {
                        var4_3 = this;
                        synchronized (var4_3) {
                            if (RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).isConnected()) {
                                var6_4 = Status.OK_STATUS;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 26, 44, 13] lbl10 : MonitorExitStatement: MONITOREXIT : var4_3
                                var7_8 = this;
                                break;
                            }
                            ** break block46
                        }
                        break;
                    }
                }
                catch (Throwable var5_23) {
                    var7_12 = this;
                    synchronized (var7_12) {
                        if (RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).isConnected()) {
                            RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).enableRawEvents(false);
                            RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).setAssertModeListener(new NetworkRecorder.IAssertModeListener(){

                                public void doAssertMode() {
                                    RecordingSupport.this.setMode(RecordingMode.Asserting);
                                }
                            });
                            ConnectionRunnable.access$1(ConnectionRunnable.this).setMode(RecordingMode.Recording);
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    RecordingContextManager.Instance.activateContext();
                                    RecordingSupport.this.recorder.setRecordModeShortcuts(RecordingContextManager.Instance.getRecordModeShortcuts());
                                    RecordingSupport.this.recorder.setAssertModeShortcuts(RecordingContextManager.Instance.getAssertModeShortcuts());
                                    RecordingSupport.this.recorder.setStartRecordShortcuts(RecordingContextManager.Instance.getStartRecordShortcuts());
                                    RecordingSupport.this.recorder.setStopRecordShortcuts(RecordingContextManager.Instance.getStopRecordShortcuts());
                                    RecordingSupport.this.recorder.setReplayShortcuts(RecordingContextManager.Instance.getReplayShortcuts());
                                }
                            });
                        } else {
                            var9_17 = RecordingSupport.access$7(ConnectionRunnable.access$1(ConnectionRunnable.this)).iterator();
                            while (true) {
                                if (!var9_17.hasNext()) {
                                    RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).cancelConnection();
                                    RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).close();
                                    RecordingSupport.access$14(ConnectionRunnable.access$1(ConnectionRunnable.this), null);
                                    ConnectionRunnable.access$1(ConnectionRunnable.this).setMode(RecordingMode.Stopped);
                                    break;
                                }
                                listener = (IRecordingListener)var9_17.next();
                                RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).removeListener((ITeslaRecorder.ITeslaRecordListener)listener);
                            }
                        }
                        throw var5_23;
                    }
                }
                synchronized (var7_8) {
                    if (RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).isConnected()) {
                        RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).enableRawEvents(false);
                        RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).setAssertModeListener(new /* invalid duplicate definition of identical inner class */);
                        ConnectionRunnable.access$1(ConnectionRunnable.this).setMode(RecordingMode.Recording);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    } else {
                        for (IRecordingListener listener : RecordingSupport.access$7(ConnectionRunnable.access$1(ConnectionRunnable.this))) {
                            RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).removeListener((ITeslaRecorder.ITeslaRecordListener)listener);
                        }
                        RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).cancelConnection();
                        RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).close();
                        RecordingSupport.access$14(ConnectionRunnable.access$1(ConnectionRunnable.this), null);
                        ConnectionRunnable.access$1(ConnectionRunnable.this).setMode(RecordingMode.Stopped);
                    }
                    return var6_4;
                }
lbl-1000:
                // 1 sources

                {
                    if (!monitor.isCanceled()) ** GOTO lbl-1000
                }
                var6_5 = Status.CANCEL_STATUS;
                var7_9 = this;
                synchronized (var7_9) {
                    if (RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).isConnected()) {
                        RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).enableRawEvents(false);
                        RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).setAssertModeListener(new /* invalid duplicate definition of identical inner class */);
                        ConnectionRunnable.access$1(ConnectionRunnable.this).setMode(RecordingMode.Recording);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    } else {
                        for (IRecordingListener listener : RecordingSupport.access$7(ConnectionRunnable.access$1(ConnectionRunnable.this))) {
                            RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).removeListener((ITeslaRecorder.ITeslaRecordListener)listener);
                        }
                        RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).cancelConnection();
                        RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).close();
                        RecordingSupport.access$14(ConnectionRunnable.access$1(ConnectionRunnable.this), null);
                        ConnectionRunnable.access$1(ConnectionRunnable.this).setMode(RecordingMode.Stopped);
                    }
                    return var6_5;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException v4) {
                        var6_6 = Status.CANCEL_STATUS;
                        var7_10 = this;
                        synchronized (var7_10) {
                            if (RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).isConnected()) {
                                RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).enableRawEvents(false);
                                RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).setAssertModeListener(new /* invalid duplicate definition of identical inner class */);
                                ConnectionRunnable.access$1(ConnectionRunnable.this).setMode(RecordingMode.Recording);
                                PlatformUI.getWorkbench().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                            } else {
                                for (IRecordingListener listener : RecordingSupport.access$7(ConnectionRunnable.access$1(ConnectionRunnable.this))) {
                                    RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).removeListener((ITeslaRecorder.ITeslaRecordListener)listener);
                                }
                                RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).cancelConnection();
                                RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).close();
                                RecordingSupport.access$14(ConnectionRunnable.access$1(ConnectionRunnable.this), null);
                                ConnectionRunnable.access$1(ConnectionRunnable.this).setMode(RecordingMode.Stopped);
                            }
                            return var6_6;
                        }
                    }
                }
                {
                    if (System.currentTimeMillis() - start < 150000L) {
                        monitor.worked(1);
                        ** continue;
                    }
                    var6_7 = status = new Status(4, "org.eclipse.rcptt.ui", Messages.RecordingSupport_ConnectionTimeoutMsg);
                    var7_11 = this;
                }
                synchronized (var7_11) {
                    if (RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).isConnected()) {
                        RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).enableRawEvents(false);
                        RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).setAssertModeListener(new /* invalid duplicate definition of identical inner class */);
                        ConnectionRunnable.access$1(ConnectionRunnable.this).setMode(RecordingMode.Recording);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    } else {
                        for (IRecordingListener listener : RecordingSupport.access$7(ConnectionRunnable.access$1(ConnectionRunnable.this))) {
                            RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).removeListener((ITeslaRecorder.ITeslaRecordListener)listener);
                        }
                        RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).cancelConnection();
                        RecordingSupport.access$8(ConnectionRunnable.access$1(ConnectionRunnable.this)).close();
                        RecordingSupport.access$14(ConnectionRunnable.access$1(ConnectionRunnable.this), null);
                        ConnectionRunnable.access$1(ConnectionRunnable.this).setMode(RecordingMode.Stopped);
                    }
                    return var6_7;
                }
            }
        };

        private ConnectionRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (monitor.isCanceled() || RecordingSupport.this.getMode() == RecordingMode.Stopped) {
                throw new InterruptedException();
            }
            if (!RecordingSupport.this.selectAUT()) {
                RecordingSupport.this.setMode(RecordingMode.Stopped);
                monitor.done();
                return;
            }
            ConnectionRunnable connectionRunnable = this;
            synchronized (connectionRunnable) {
                RecordingSupport.this.previous = (Scenario)EcoreUtil.copy((EObject)RecordingSupport.this.scenarioWorkingCopy);
                BaseAutLaunch launch = (BaseAutLaunch)RecordingSupport.this.getAUT();
                UiNetworkRecorder newNetworkRecorder = new UiNetworkRecorder(launch.getHost(), launch.getTeslaPort(), RecordingSupport.this.recordingMonitor);
                RecordingSupport.this.recorder = newNetworkRecorder;
                for (IRecordingListener listener : RecordingSupport.this.recordingListeners) {
                    RecordingSupport.this.recorder.addListener((ITeslaRecorder.ITeslaRecordListener)listener);
                }
                RecordingSupport.this.recorder.start();
            }
            this.waitForConnectionJob.schedule();
        }
    }

    private static class PlanEntry {
        public IQ7NamedElement element;
        public ExecutionPhase phase;

        public PlanEntry(IQ7NamedElement element) {
            this(element, ExecutionPhase.AUTO);
        }

        public PlanEntry(IQ7NamedElement element, ExecutionPhase phase) {
            this.element = element;
            this.phase = phase;
        }
    }

    private final class RecordingListener
    implements IRecordingListener {
        private RecordingListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleContainerChange() {
            RecordingSupport recordingSupport = RecordingSupport.this;
            synchronized (recordingSupport) {
                if (RecordingSupport.this.recorder == null) {
                    return;
                }
                Job j = RecordingSupport.this.getUpdateContentJob();
                Job.getJobManager().cancel(RecordingSupport.class);
                j.schedule(50L);
            }
        }

        public void assertAdded(CommandSet commands) {
        }

        public void recordMode() {
            RecordingSupport.this.setMode(RecordingMode.Recording);
        }

        public void assertMode() {
            RecordingSupport.this.setMode(RecordingMode.Asserting);
        }

        public void startRecord() {
            RecordingSupport.this.setMode(RecordingMode.Connecting);
        }

        public void stopRecord() {
            RecordingSupport.this.setMode(RecordingMode.Stopped);
        }

        public void replay() {
            RecordingSupport.this.setMode(RecordingMode.Replaying);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnected() {
            Command lastCommand;
            EList commands;
            TeslaScenario teslaScenario;
            RecordingSupport recordingSupport = RecordingSupport.this;
            synchronized (recordingSupport) {
                teslaScenario = (TeslaScenario)RecordingSupport.this.scenarioWorkingCopy.getTeslaContent();
            }
            if (teslaScenario != null && (commands = teslaScenario.getCommands()).size() > 0 && (lastCommand = (Command)commands.get(commands.size() - 1)) instanceof WaitForRestart && !RecordingSupport.this.getMode().equals((Object)RecordingMode.Stopped)) {
                RecordingSupport.this.setMode(RecordingMode.WaitingForAUTRestart);
                return;
            }
            RecordingSupport.this.setMode(RecordingMode.Stopped);
        }
    }

    public static enum RecordingMode {
        Stopped,
        Connecting,
        Replaying,
        WaitingForAUTRestart,
        Recording,
        Asserting,
        ImageRecognition;

    }

    private final class RecordingModeListener
    implements IChangeListener {
        private RecordingModeListener() {
        }

        public void handleChange(ChangeEvent event) {
            switch (RecordingSupport.this.getMode()) {
                case Connecting: {
                    RecordingSupport.this.record();
                    break;
                }
                case Replaying: {
                    RecordingSupport.this.replay();
                    break;
                }
                case Stopped: {
                    RecordingSupport.this.stop();
                    break;
                }
                case WaitingForAUTRestart: {
                    RecordingSupport.this.waitForAUTRestart();
                    break;
                }
                case Recording: {
                    RecordingSupport.this.recordingMode();
                    break;
                }
                case Asserting: {
                    RecordingSupport.this.assertingMode();
                    break;
                }
                case ImageRecognition: {
                    RecordingSupport.this.imageRecognitionMode();
                }
            }
        }
    }

    private class RecordingMonitor
    extends DefaultConnectionMonitor
    implements IRecordingMonitor {
        private RecordingMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recordMode() {
            RecordingSupport recordingSupport = RecordingSupport.this;
            synchronized (recordingSupport) {
                for (IRecordingListener listener : RecordingSupport.this.recordingListeners) {
                    listener.recordMode();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startRecord() {
            RecordingSupport recordingSupport = RecordingSupport.this;
            synchronized (recordingSupport) {
                for (IRecordingListener listener : RecordingSupport.this.recordingListeners) {
                    listener.startRecord();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRecord() {
            RecordingSupport recordingSupport = RecordingSupport.this;
            synchronized (recordingSupport) {
                for (IRecordingListener listener : RecordingSupport.this.recordingListeners) {
                    listener.stopRecord();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replay() {
            RecordingSupport recordingSupport = RecordingSupport.this;
            synchronized (recordingSupport) {
                for (IRecordingListener listener : RecordingSupport.this.recordingListeners) {
                    listener.replay();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void assertMode() {
            RecordingSupport recordingSupport = RecordingSupport.this;
            synchronized (recordingSupport) {
                for (IRecordingListener listener : RecordingSupport.this.recordingListeners) {
                    listener.assertMode();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void assertAdded(CommandSet commands) {
            RecordingSupport recordingSupport = RecordingSupport.this;
            synchronized (recordingSupport) {
                for (IRecordingListener listener : RecordingSupport.this.recordingListeners) {
                    listener.assertAdded(commands);
                }
            }
        }
    }

    private class ReplayRunnable
    implements IRunnableWithProgress {
        private final String name;

        public ReplayRunnable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            List<IQ7NamedElement> elements;
            block24: {
                if (monitor.isCanceled() || RecordingSupport.this.getMode() == RecordingMode.Stopped) {
                    throw new InterruptedException();
                }
                if (!RecordingSupport.this.selectAUT()) {
                    RecordingSupport.this.setMode(RecordingMode.Stopped);
                    monitor.done();
                    return;
                }
                elements = this.getExecutableElements();
                if (elements.isEmpty()) {
                    return;
                }
                monitor.beginTask(this.name, elements.size() + 3);
                ReplayRunnable replayRunnable = this;
                synchronized (replayRunnable) {
                    if (ModelCycleDetector.hasCycles((NamedElement[])new NamedElement[]{RecordingSupport.this.scenarioWorkingCopy})) {
                        Status status = new Status(4, "org.eclipse.rcptt.ui", Messages.RecordingSupport_CircularDependenciesMsg);
                        monitor.setCanceled(true);
                        throw new InvocationTargetException(new CoreException((IStatus)status));
                    }
                    monitor.worked(1);
                }
                try {
                    if (!Q7LaunchManager.getInstance().cancelDebugExecution(RecordingSupport.this.getAUT(), (Object)RecordingSupport.this.window.getShell())) {
                        monitor.setCanceled(true);
                        return;
                    }
                }
                catch (DebugException e1) {
                    ExecutionStatus status = new ExecutionStatus(e1.getStatus());
                    throw new InvocationTargetException(new CoreException((IStatus)status));
                }
                if (!monitor.isCanceled() && RecordingSupport.this.getMode() != RecordingMode.Stopped) break block24;
                throw new InterruptedException();
            }
            if (monitor.isCanceled() || RecordingSupport.this.getMode() == RecordingMode.Stopped) {
                throw new InterruptedException();
            }
            SetQ7Features setQ7Features = Q7CoreFactory.eINSTANCE.createSetQ7Features();
            if (RecordingSupport.this.originalScenario != null) {
                Q7LaunchUtils.setQ7Variable((SetQ7Features)setQ7Features, (String)"current_test", (String)RecordingSupport.this.originalScenario.getName());
            }
            TeslaFeatures.getInstance().storeValues((List)setQ7Features.getFeatures());
            Q7Features.getInstance().storeValues((List)setQ7Features.getFeatures());
            try {
                RecordingSupport.this.getAUT().execute((org.eclipse.rcptt.ecl.core.Command)setQ7Features);
                ITestCase testCase = null;
                for (IQ7NamedElement element : elements) {
                    if (!(element instanceof ITestCase)) continue;
                    testCase = (ITestCase)element;
                    break;
                }
                RecordingSupport.this.createReport(RecordingSupport.this.getAUT(), testCase);
                RecordingSupport.this.getAUT().resetState();
                IQ7NamedElement originalScenarioElement = (IQ7NamedElement)RcpttCore.create((IResource)Q7Utils.getLocation((NamedElement)RecordingSupport.this.originalScenario));
                IContext[] contexts = RcpttCore.getInstance().getContexts(originalScenarioElement, (List)RecordingSupport.this.scenarioWorkingCopy.getContexts(), RecordingSupport.this.getFinder(), true);
                IVerification[] verifications = RcpttCore.getInstance().getVerifications(originalScenarioElement, (List)RecordingSupport.this.scenarioWorkingCopy.getVerifications(), RecordingSupport.this.getFinder(), true);
                for (PlanEntry pe : this.makeExecutionPlan(testCase, contexts, verifications)) {
                    try {
                        this.executePlanEntry(pe, monitor);
                    }
                    catch (CoreException e) {
                        ExecutionStatus status = new ExecutionStatus(e.getStatus());
                        status.setElement(pe.element);
                        throw new InvocationTargetException(new CoreException((IStatus)status));
                    }
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            finally {
                monitor.done();
            }
        }

        private List<PlanEntry> makeExecutionPlan(ITestCase testcase, IContext[] contexts, IVerification[] verifications) {
            ArrayList<PlanEntry> plan = new ArrayList<PlanEntry>();
            IContext[] iContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IContext c = iContextArray[n2];
                plan.add(new PlanEntry((IQ7NamedElement)c));
                ++n2;
            }
            if (testcase != null) {
                plan.add(new PlanEntry((IQ7NamedElement)testcase));
            }
            return plan;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<IQ7NamedElement> getExecutableElements() {
            ReplayRunnable replayRunnable = this;
            synchronized (replayRunnable) {
                ArrayList<IQ7NamedElement> elements = new ArrayList<IQ7NamedElement>();
                IQ7NamedElement element = (IQ7NamedElement)RcpttCore.create((IResource)Q7Utils.getLocation((NamedElement)RecordingSupport.this.originalScenario));
                IContext[] contexts = RcpttCore.getInstance().getContexts(element, (List)RecordingSupport.this.scenarioWorkingCopy.getContexts(), RecordingSupport.this.getFinder(), true);
                elements.addAll(Arrays.asList(contexts));
                if (RecordingSupport.this.scenarioWorkingCopy.getContent() != null || RecordingSupport.this.scenarioWorkingCopy.getTeslaContent() != null) {
                    elements.add((IQ7NamedElement)new Q7InternalTestCase((Q7Element)ModelManager.getModelManager().getModel(), "scenario", RecordingSupport.this.scenarioWorkingCopy));
                }
                return elements;
            }
        }

        private void executePlanEntry(PlanEntry planEntry, IProgressMonitor monitor) throws CoreException, InterruptedException {
            if (monitor.isCanceled() || RecordingSupport.this.getMode() == RecordingMode.Stopped) {
                throw new InterruptedException();
            }
            IQ7NamedElement element = planEntry.element;
            monitor.subTask(Messages.bind((String)Messages.RecordingSupport_ExecutingElementTask, (Object)element.getElementName()));
            if (element instanceof ITestCase || element instanceof IContext) {
                RecordingSupport.this.getAUT().run(element, (long)(Q7Launcher.getLaunchTimeout() * 1000), monitor, ExecutionPhase.AUTO);
                monitor.worked(1);
            } else if (element instanceof IVerification) {
                IVerification v = (IVerification)element;
                Verification verification = (Verification)v.getNamedElement();
                VerificationType type = v.getType();
                if (type != null) {
                    try {
                        type.getMaker().makeExecutable(verification, (IQ7NamedElement)v);
                    }
                    catch (ModelException e) {
                        Q7UIPlugin.log(e);
                    }
                }
                this.executeVerification(verification, planEntry.phase, monitor);
                monitor.worked(1);
            }
        }

        private void executeVerification(Verification context, ExecutionPhase phase, IProgressMonitor monitor) throws CoreException, InterruptedException {
            ExecVerification execVerification = Q7CoreFactory.eINSTANCE.createExecVerification();
            execVerification.setVerification(context);
            execVerification.setPhase(phase);
            RecordingSupport.this.getAUT().execute((org.eclipse.rcptt.ecl.core.Command)execVerification);
        }
    }

    private class WaitForAUTRestartRunnable
    implements IRunnableWithProgress {
        private WaitForAUTRestartRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (monitor.isCanceled() || RecordingSupport.this.getMode() == RecordingMode.Stopped) {
                throw new InterruptedException();
            }
            if (!RecordingSupport.this.selectAUT()) {
                RecordingSupport.this.setMode(RecordingMode.Stopped);
                monitor.done();
                return;
            }
            AutLaunch aut = RecordingSupport.this.getAUT();
            try {
                aut.waitForRestart(monitor);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

