/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.beans.IBeanListProperty;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.property.list.DelegatingListProperty;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;

public class AnonymousPojoListProperty
extends DelegatingListProperty {
    private final String propertyName;
    private Map delegates;

    public AnonymousPojoListProperty(String propertyName, Class elementType) {
        super((Object)elementType);
        this.propertyName = propertyName;
        this.delegates = new HashMap();
    }

    protected IListProperty doGetDelegate(Object source) {
        IBeanListProperty delegate;
        Class<?> beanClass = source.getClass();
        if (this.delegates.containsKey(beanClass)) {
            return (IListProperty)this.delegates.get(beanClass);
        }
        try {
            delegate = PojoProperties.list(beanClass, this.propertyName, (Class)this.getElementType());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            delegate = null;
        }
        this.delegates.put(beanClass, delegate);
        return delegate;
    }

    public String toString() {
        String s = "?." + this.propertyName + "{}";
        Class elementType = (Class)this.getElementType();
        if (elementType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(elementType) + ">";
        }
        return s;
    }
}

