/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.context;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.editors.IQ7Viewer;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ContextViewer {
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ICON = "icon";
    private ContextType type;
    private IQ7Viewer<Context> viewer;
    private ImageDescriptor icon;

    public ContextViewer(IConfigurationElement element) throws CoreException {
        String typeId = this.getVal(element, ATTR_TYPE);
        this.type = ContextTypeManager.getInstance().getTypeById(typeId);
        if (this.type == null) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.ContextViewer_InvalidTypeErrorMsg, (Object)typeId));
        }
        this.viewer = (IQ7Viewer)element.createExecutableExtension(ATTR_CLASS);
        String iconPath = element.getAttribute(ATTR_ICON);
        if (iconPath != null && iconPath.length() > 0) {
            String plugin = element.getContributor().getName();
            this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)plugin, (String)iconPath);
        }
    }

    public ContextType getType() {
        return this.type;
    }

    public IQ7Viewer<Context> getViewer() {
        return this.viewer;
    }

    public ImageDescriptor getIcon() {
        return this.icon;
    }

    private String getVal(IConfigurationElement element, String attr) {
        String val = element.getAttribute(attr);
        if (val == null || val.length() == 0) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.ContextViewer_EmptyErrorMsg, (Object)attr));
        }
        return val;
    }
}

