/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.bindings.keys.KeyBindingDispatcher;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.keys.BindingPersistence;
import org.eclipse.ui.internal.keys.GlobalKeyAssistDialog;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;
import org.eclipse.ui.keys.IBindingService;

public final class BindingService
implements IBindingService {
    @Inject
    private MApplication application;
    @Inject
    private EBindingService bindingService;
    @Inject
    private ECommandService commandService;
    @Inject
    private CommandManager commandManager;
    @Inject
    private BindingManager manager;
    @Inject
    private BindingTableManager tableManager;
    @Inject
    @Optional
    private KeyBindingDispatcher dispatcher;
    private BindingPersistence bp;
    private Map<String, MBindingContext> bindingContexts = new HashMap<String, MBindingContext>();
    private String[] activeSchemeIds;
    private GlobalKeyAssistDialog keyAssistDialog;
    private IEclipseContext context;

    @PostConstruct
    void init() {
        Scheme activeScheme = this.manager.getActiveScheme();
        if (activeScheme != null) {
            this.activeSchemeIds = this.getSchemeIds(activeScheme.getId());
            this.tableManager.setActiveSchemes(this.activeSchemeIds);
        }
        this.bp = new BindingPersistence(this.manager, this.commandManager){

            @Override
            public void reRead() {
                super.reRead();
                BindingService.this.persistToModel(BindingService.this.manager.getActiveScheme());
            }
        };
    }

    @Override
    public void dispose() {
        if (this.bp != null) {
            this.bp.dispose();
        }
    }

    @Inject
    public void setContext(IEclipseContext context) {
        this.context = context;
    }

    @Override
    public void addBindingManagerListener(IBindingManagerListener listener) {
        this.manager.addBindingManagerListener(listener);
    }

    @Override
    public void removeBindingManagerListener(IBindingManagerListener listener) {
        this.manager.removeBindingManagerListener(listener);
    }

    @Override
    public TriggerSequence[] getActiveBindingsFor(ParameterizedCommand parameterizedCommand) {
        Collection seq = this.bindingService.getSequencesFor(parameterizedCommand);
        return seq.toArray(new TriggerSequence[seq.size()]);
    }

    @Override
    public TriggerSequence[] getActiveBindingsFor(String commandId) {
        return this.getActiveBindingsFor(this.commandService.createCommand(commandId, null));
    }

    @Override
    public Scheme getActiveScheme() {
        return this.manager.getActiveScheme();
    }

    @Override
    public TriggerSequence getBestActiveBindingFor(ParameterizedCommand command) {
        return this.bindingService.getBestSequenceFor(command);
    }

    @Override
    public TriggerSequence getBestActiveBindingFor(String commandId) {
        ParameterizedCommand cmd = this.commandService.createCommand(commandId, null);
        return this.bindingService.getBestSequenceFor(cmd);
    }

    @Override
    public String getBestActiveBindingFormattedFor(String commandId) {
        TriggerSequence sequence = this.bindingService.getBestSequenceFor(this.commandService.createCommand(commandId, null));
        return sequence == null ? null : sequence.format();
    }

    @Override
    public Binding[] getBindings() {
        return this.manager.getBindings();
    }

    @Override
    public TriggerSequence getBuffer() {
        if (this.dispatcher == null) {
            return KeySequence.getInstance();
        }
        return this.dispatcher.getBuffer();
    }

    @Override
    public String getDefaultSchemeId() {
        return BindingPersistence.getDefaultSchemeId();
    }

    @Override
    public Scheme[] getDefinedSchemes() {
        return this.manager.getDefinedSchemes();
    }

    @Override
    public String getLocale() {
        return this.manager.getLocale();
    }

    @Override
    public Map getPartialMatches(TriggerSequence trigger) {
        Collection partialMatches = this.bindingService.getPartialMatches(trigger);
        HashMap<TriggerSequence, Binding> result = new HashMap<TriggerSequence, Binding>(partialMatches.size());
        for (Binding binding : partialMatches) {
            result.put(binding.getTriggerSequence(), binding);
        }
        return result;
    }

    @Override
    public Binding getPerfectMatch(TriggerSequence trigger) {
        return this.bindingService.getPerfectMatch(trigger);
    }

    @Override
    public String getPlatform() {
        return Util.getWS();
    }

    @Override
    public Scheme getScheme(String schemeId) {
        return this.manager.getScheme(schemeId);
    }

    @Override
    public boolean isKeyFilterEnabled() {
        return this.dispatcher == null ? false : this.dispatcher.getKeyDownFilter().isEnabled();
    }

    @Override
    public boolean isPartialMatch(TriggerSequence trigger) {
        return this.bindingService.isPartialMatch(trigger);
    }

    @Override
    public boolean isPerfectMatch(TriggerSequence trigger) {
        return this.bindingService.isPerfectMatch(trigger);
    }

    @Override
    public void openKeyAssistDialog() {
        if (this.keyAssistDialog == null) {
            Display.getCurrent();
            this.keyAssistDialog = new GlobalKeyAssistDialog(this.context, this.dispatcher);
        }
        if (this.keyAssistDialog.getShell() == null) {
            this.keyAssistDialog.setParentShell(Display.getCurrent().getActiveShell());
        }
        this.keyAssistDialog.open();
    }

    @Override
    public void readRegistryAndPreferences(ICommandService commandService) {
        this.bp.read();
    }

    private void saveLegacyPreferences(Scheme activeScheme, Binding[] bindings) throws IOException {
        BindingPersistence.write(activeScheme, bindings);
        try {
            this.manager.setActiveScheme(activeScheme);
        }
        catch (NotDefinedException e) {
            WorkbenchPlugin.log("The active scheme is not currently defined.", WorkbenchPlugin.getStatus(e));
        }
        this.manager.setBindings(bindings);
    }

    @Override
    public void savePreferences(Scheme activeScheme, Binding[] bindings) throws IOException {
        this.saveLegacyPreferences(activeScheme, bindings);
        this.persistToModel(activeScheme);
    }

    private void persistToModel(Scheme activeScheme) {
        MKeyBinding model;
        this.writeSchemeToModel(activeScheme);
        this.activeSchemeIds = this.getSchemeIds(activeScheme.getId());
        this.tableManager.setActiveSchemes(this.activeSchemeIds);
        HashSet activeBindings = new HashSet(this.manager.getActiveBindingsDisregardingContextFlat());
        HashMap<Binding, MKeyBinding> bindingToKey = new HashMap<Binding, MKeyBinding>();
        for (MBindingTable table : this.application.getBindingTables()) {
            for (MKeyBinding modelBinding : table.getBindings()) {
                Object obj = modelBinding.getTransientData().get("binding");
                if (!(obj instanceof Binding)) continue;
                bindingToKey.put((Binding)obj, modelBinding);
            }
        }
        HashSet deleted = new HashSet(bindingToKey.keySet());
        deleted.removeAll(activeBindings);
        for (Binding binding : deleted) {
            if (binding.getType() == 1) {
                this.removeBinding(binding);
                continue;
            }
            model = (MKeyBinding)bindingToKey.get(binding);
            if (model.getTags().contains("deleted")) continue;
            model.getTags().add("deleted");
        }
        for (Binding binding : activeBindings) {
            MKeyBinding toAddModel = model = (MKeyBinding)bindingToKey.get(binding);
            Binding toAddBinding = binding;
            Binding conflict = this.findPotentialConflict(binding);
            if (conflict != null && conflict.getContextId().equals(binding.getContextId())) {
                int rc = this.compareTo(conflict, binding);
                if (rc < 0) {
                    MKeyBinding conflictModel = (MKeyBinding)bindingToKey.get(conflict);
                    if (conflict.getType() == 1) {
                        this.removeBinding(conflict);
                    } else if (conflictModel != null && !conflictModel.getTags().contains("deleted")) {
                        conflictModel.getTags().add("deleted");
                    }
                } else if (rc > 0) {
                    if (binding.getType() == 1) {
                        this.removeBinding(binding);
                    } else if (model != null && !model.getTags().contains("deleted")) {
                        model.getTags().add("deleted");
                    }
                    toAddModel = null;
                    toAddBinding = null;
                }
            }
            if (toAddModel != null) {
                if (!toAddModel.getTags().contains("deleted")) continue;
                toAddModel.getTags().remove("deleted");
                continue;
            }
            if (toAddBinding == null) continue;
            this.addBinding(toAddBinding);
        }
    }

    private Binding findPotentialConflict(Binding binding) {
        Binding perfectMatch;
        BindingTable table = this.tableManager.getTable(binding.getContextId());
        if (table != null && (perfectMatch = table.getPerfectMatch(binding.getTriggerSequence())) != null) {
            return perfectMatch;
        }
        return this.bindingService.getPerfectMatch(binding.getTriggerSequence());
    }

    private String[] getSchemeIds(String schemeId) {
        ArrayList<String> strings = new ArrayList<String>();
        while (schemeId != null) {
            strings.add(schemeId);
            try {
                schemeId = this.getScheme(schemeId).getParentId();
            }
            catch (NotDefinedException notDefinedException) {
                return new String[0];
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    private int compareSchemes(String schemeId1, String schemeId2) {
        if (this.activeSchemeIds == null) {
            return 0;
        }
        if (!schemeId2.equals(schemeId1)) {
            String[] stringArray = this.activeSchemeIds;
            int n = this.activeSchemeIds.length;
            int n2 = 0;
            while (n2 < n) {
                String schemePointer = stringArray[n2];
                if (schemeId2.equals(schemePointer)) {
                    return 1;
                }
                if (schemeId1.equals(schemePointer)) {
                    return -1;
                }
                ++n2;
            }
        }
        return 0;
    }

    private int compareTo(Binding current, Binding addition) {
        int rc;
        Scheme s2;
        Scheme s1 = this.manager.getScheme(current.getSchemeId());
        if (!s1.equals((Object)(s2 = this.manager.getScheme(addition.getSchemeId()))) && (rc = this.compareSchemes(s1.getId(), s2.getId())) != 0) {
            return rc > 0 ? -1 : 1;
        }
        return current.getType() - addition.getType();
    }

    private void writeSchemeToModel(Scheme activeScheme) {
        List tags = this.application.getTags();
        boolean found = false;
        Iterator i = tags.iterator();
        while (i.hasNext() && !found) {
            String tag = (String)i.next();
            if (!tag.startsWith("activeSchemeId")) continue;
            i.remove();
            found = true;
        }
        tags.add("activeSchemeId:" + activeScheme.getId());
    }

    @Override
    public void setKeyFilterEnabled(boolean enabled) {
        if (this.dispatcher != null) {
            this.dispatcher.getKeyDownFilter().setEnabled(enabled);
        }
    }

    @Override
    public Collection<Binding> getConflictsFor(TriggerSequence sequence) {
        return this.bindingService.getConflictsFor(sequence);
    }

    public MBindingContext getBindingContext(String id) {
        MBindingContext result = this.bindingContexts.get(id);
        if (result == null) {
            result = this.searchContexts(id, this.application.getRootContext());
            if (result == null) {
                result = MCommandsFactory.INSTANCE.createBindingContext();
                result.setElementId(id);
                result.setName("Auto::" + id);
                this.application.getRootContext().add(result);
            }
            if (result != null) {
                this.bindingContexts.put(id, result);
            }
        }
        return result;
    }

    private MBindingContext searchContexts(String id, List<MBindingContext> rootContext) {
        for (MBindingContext context : rootContext) {
            if (context.getElementId().equals(id)) {
                return context;
            }
            MBindingContext result = this.searchContexts(id, context.getChildren());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void addBinding(Binding binding) {
        MBindingTable table = this.getMTable(binding.getContextId());
        BindingService.createORupdateMKeyBinding(this.application, table, binding);
    }

    private MBindingTable getMTable(String contextId) {
        for (MBindingTable bt : this.application.getBindingTables()) {
            if (!bt.getBindingContext().getElementId().equals(contextId)) continue;
            return bt;
        }
        MBindingTable table = CommandsFactoryImpl.eINSTANCE.createBindingTable();
        table.setBindingContext(this.getBindingContext(contextId));
        table.setElementId(contextId);
        this.application.getBindingTables().add(table);
        return table;
    }

    private static boolean isSameBinding(MKeyBinding existingBinding, MCommand cmd, Binding binding) {
        if (!cmd.equals(existingBinding.getCommand())) {
            return false;
        }
        String existingKeySequence = existingBinding.getKeySequence();
        if (existingKeySequence == null) {
            return false;
        }
        try {
            KeySequence existingSequence = KeySequence.getInstance((String)existingKeySequence);
            if (!existingSequence.equals((Object)binding.getTriggerSequence())) {
                return false;
            }
        }
        catch (ParseException parseException) {
            return false;
        }
        List modelTags = existingBinding.getTags();
        String schemeId = binding.getSchemeId();
        if (schemeId != null && !schemeId.equals(BindingPersistence.getDefaultSchemeId()) && !modelTags.contains("schemeId:" + schemeId)) {
            return false;
        }
        String locale = binding.getLocale();
        if (locale != null && !modelTags.contains("locale:" + locale)) {
            return false;
        }
        String platform = binding.getPlatform();
        if (platform != null && !modelTags.contains("platform:" + platform)) {
            return false;
        }
        return binding.getType() != 1 || modelTags.contains("type:user");
    }

    public static MKeyBinding createORupdateMKeyBinding(MApplication application, MBindingTable table, Binding binding) {
        boolean addToTable = false;
        ParameterizedCommand parmCmd = binding.getParameterizedCommand();
        String id = parmCmd.getId();
        MCommand cmd = application.getCommand(id);
        if (cmd == null) {
            return null;
        }
        MKeyBinding keyBinding = null;
        for (MKeyBinding mKeyBinding : table.getBindings()) {
            Binding b = (Binding)mKeyBinding.getTransientData().get("binding");
            if (binding.equals((Object)b)) {
                keyBinding = mKeyBinding;
                break;
            }
            if (!BindingService.isSameBinding(mKeyBinding, cmd, binding)) continue;
            keyBinding = mKeyBinding;
            break;
        }
        if (keyBinding == null) {
            addToTable = true;
            keyBinding = CommandsFactoryImpl.eINSTANCE.createKeyBinding();
            keyBinding.setCommand(cmd);
            keyBinding.setKeySequence(binding.getTriggerSequence().toString());
            for (Object object : parmCmd.getParameterMap().entrySet()) {
                Map.Entry entry = (Map.Entry)object;
                String paramID = (String)entry.getKey();
                if (paramID == null) continue;
                List bindingParams = keyBinding.getParameters();
                MParameter p = null;
                for (MParameter param : bindingParams) {
                    if (!paramID.equals(param.getElementId())) continue;
                    p = param;
                    break;
                }
                if (p == null) {
                    p = CommandsFactoryImpl.eINSTANCE.createParameter();
                    p.setElementId((String)entry.getKey());
                    keyBinding.getParameters().add(p);
                }
                p.setName((String)entry.getKey());
                p.setValue((String)entry.getValue());
            }
            List list = keyBinding.getTags();
            if (binding.getSchemeId() != null && !binding.getSchemeId().equals(BindingPersistence.getDefaultSchemeId())) {
                list.add("schemeId:" + binding.getSchemeId());
            }
            if (binding.getLocale() != null) {
                list.add("locale:" + binding.getLocale());
            }
            if (binding.getPlatform() != null) {
                list.add("platform:" + binding.getPlatform());
            }
            if (binding.getType() == 1) {
                list.add("type:user");
            }
        }
        keyBinding.getTransientData().put("binding", binding);
        if (addToTable) {
            table.getBindings().add(keyBinding);
        }
        return keyBinding;
    }

    private MKeyBinding findMKeyBinding(MBindingTable table, Binding binding) {
        String bindingSchemeId;
        List mBindings = table.getBindings();
        String string = bindingSchemeId = binding.getSchemeId() == null ? "org.eclipse.ui.defaultAcceleratorConfiguration" : binding.getSchemeId();
        if (binding.getParameterizedCommand() != null) {
            String commandId = binding.getParameterizedCommand().getId();
            for (MKeyBinding curr : mBindings) {
                Binding transientBinding = (Binding)curr.getTransientData().get("binding");
                if (transientBinding != null) {
                    if (!binding.equals((Object)transientBinding)) continue;
                    return curr;
                }
                if (!curr.getKeySequence().equals(binding.getTriggerSequence().toString()) || curr.getCommand() == null || !curr.getCommand().getElementId().equals(commandId)) continue;
                String schemeId = "org.eclipse.ui.defaultAcceleratorConfiguration";
                List tags = curr.getTags();
                for (String tag : tags) {
                    if (!tag.startsWith("schemeId")) continue;
                    schemeId = tag.substring(9);
                    break;
                }
                if (!schemeId.equals(bindingSchemeId)) continue;
                return curr;
            }
        }
        return null;
    }

    public void removeBinding(Binding binding) {
        MBindingTable table = null;
        for (MBindingTable bt : this.application.getBindingTables()) {
            if (!bt.getBindingContext().getElementId().equals(binding.getContextId())) continue;
            table = bt;
            break;
        }
        if (table == null) {
            return;
        }
        if (binding.getType() == 1) {
            MKeyBinding mKeyBinding = this.findMKeyBinding(table, binding);
            if (mKeyBinding != null) {
                table.getBindings().remove(mKeyBinding);
            }
        } else {
            MKeyBinding mKeyBinding = this.findMKeyBinding(table, binding);
            if (mKeyBinding != null) {
                mKeyBinding.getTags().add("deleted");
            }
        }
    }

    public BindingManager getBindingManager() {
        return this.manager;
    }

    public Collection<Binding> getActiveBindings() {
        return this.bindingService.getActiveBindings();
    }

    public WorkbenchKeyboard getKeyboard() {
        return new WorkbenchKeyboard(this.dispatcher);
    }
}

