/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.internal.commands;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.data.commands.WriteXmlFile;
import org.eclipse.rcptt.ecl.data.internal.EclDataPlugin;
import org.eclipse.rcptt.ecl.data.internal.commands.XmlFileService;
import org.eclipse.rcptt.ecl.data.objects.Attribute;
import org.eclipse.rcptt.ecl.data.objects.Tree;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.filesystem.FileResolver;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WriteXmlFileService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        WriteXmlFile wxf = (WriteXmlFile)command;
        Tree tree = wxf.getTree();
        String uri = wxf.getUri();
        EclFile file = FileResolver.resolve((String)uri);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return EclDataPlugin.createErr(e, "Error writing file %s", file.toURI());
        }
        Document document = docBuilder.newDocument();
        Element root = this.readElement(document, tree);
        document.appendChild(root);
        XmlFileService.writeXml(file, document);
        context.getOutput().write((Object)tree);
        return Status.OK_STATUS;
    }

    private Element readElement(Document document, Tree item) {
        Element element = document.createElement(item.getName());
        for (Attribute attribute : item.getAttributes()) {
            Attr attr = document.createAttribute(attribute.getName());
            attr.setValue(attribute.getValue());
            element.setAttributeNode(attr);
        }
        for (Tree child : item.getChildren()) {
            element.appendChild(this.readElement(document, child));
        }
        if (item.getChildren().size() == 0) {
            element.setTextContent(item.getText());
        }
        return element;
    }
}

