/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.events;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.rap.rwt.service.UISessionEvent;
import org.eclipse.rap.rwt.service.UISessionListener;
import org.eclipse.rcptt.tesla.core.am.rap.RecordingModeFeature;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.swt.events.IRwtWorkbenchListener;
import org.eclipse.rcptt.tesla.swt.events.ITeslaEventListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class TeslaEventManager {
    private static TeslaEventManager manager = new TeslaEventManager();
    private static Shell activeShell;
    private Set<ITeslaEventListener> listeners = new HashSet<ITeslaEventListener>();
    private Set<IRwtWorkbenchListener> workbenchListeners = new HashSet<IRwtWorkbenchListener>();
    private List<WeakReference<Menu>> popupMenus = new ArrayList<WeakReference<Menu>>();
    private final List<Menu> allRegisteredMenu = new ArrayList<Menu>();
    private Map<Menu, Control> popupMenuParents = new WeakHashMap<Menu, Control>();
    private Widget lastWidget;
    private int lastWidgetX;
    private int lastWidgetY;
    private List<ContextManagement.Context> syncExecs = new ArrayList<ContextManagement.Context>();
    private WeakReference<Control> forceFocusControl;
    private boolean ignoreMenuShow = false;
    private Map<Shell, String> shellMethodsMap = new WeakHashMap<Shell, String>();
    private boolean statusDialogModeAllowed = false;
    private boolean showingAlert = false;
    private Display lastDisplay;
    private Object lastWorkbench;
    private IUnhandledNativeDialogHandler unhandledNativeDialogHandler;
    private volatile boolean unfreeze;
    private boolean noWaitForJob = false;
    Map<Display, Boolean> synced = new HashMap<Display, Boolean>();
    private ServerPushSession session;
    private Boolean needSync = false;

    public void setShowingAlert(boolean showing) {
        this.showingAlert = showing;
    }

    public boolean getShowingAlert() {
        return this.showingAlert;
    }

    public boolean isUnfreeze() {
        return this.unfreeze;
    }

    public void setUnfreeze(boolean unfreeze) {
        this.unfreeze = unfreeze;
    }

    private TeslaEventManager() {
        this.startSynchronizer();
    }

    public static TeslaEventManager getManager() {
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(ITeslaEventListener listener) {
        Set<ITeslaEventListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(ITeslaEventListener listener) {
        Set<ITeslaEventListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        Set<ITeslaEventListener> set = this.listeners;
        synchronized (set) {
            this.listeners.clear();
        }
    }

    public boolean doProcessing(ContextManagement.Context currentContext) {
        boolean hasEvent = false;
        List<ITeslaEventListener> copy = this.getListeners();
        for (ITeslaEventListener listener : copy) {
            if (!listener.doProcessing(currentContext)) continue;
            hasEvent = true;
        }
        return hasEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ITeslaEventListener> getListeners() {
        ArrayList<ITeslaEventListener> copy = null;
        Set<ITeslaEventListener> set = this.listeners;
        synchronized (set) {
            copy = new ArrayList<ITeslaEventListener>(this.listeners);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IRwtWorkbenchListener> getWorkbenchListeners() {
        ArrayList<IRwtWorkbenchListener> copy = null;
        Set<ITeslaEventListener> set = this.listeners;
        synchronized (set) {
            copy = new ArrayList<IRwtWorkbenchListener>(this.workbenchListeners);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        Set<ITeslaEventListener> set = this.listeners;
        synchronized (set) {
            return !this.listeners.isEmpty();
        }
    }

    public synchronized boolean proceedMenu(Menu menu, boolean value) {
        if (this.hasListeners() && !this.isUnfreeze()) {
            if (value) {
                if ((menu.getStyle() & 6) != 0) {
                    return false;
                }
                this.popupMenus.clear();
                this.popupMenus.add(new WeakReference<Menu>(menu));
            } else {
                this.popupMenus.clear();
            }
            return true;
        }
        return false;
    }

    public synchronized void registerPopupMenu(Menu menu) {
        this.allRegisteredMenu.add(menu);
    }

    public synchronized void clearRegisteredPopupMenu() {
        this.allRegisteredMenu.clear();
    }

    public List<WeakReference<Menu>> getPopupMenus() {
        return this.popupMenus;
    }

    public List<Menu> getAllRegisteredMenus() {
        return Collections.unmodifiableList(this.allRegisteredMenu);
    }

    public Map<Menu, Control> getPopupMenuParents() {
        return this.popupMenuParents;
    }

    public Point getCursotLocation(Point point) {
        if (this.listeners.size() == 0) {
            return point;
        }
        if (this.lastWidget != null && this.lastWidget instanceof Control && !this.lastWidget.isDisposed()) {
            Control ctrl = (Control)this.lastWidget;
            return ctrl.toDisplay(this.lastWidgetX, this.lastWidgetY);
        }
        return point;
    }

    public void setLastWidget(Widget widget, int x, int y) {
        this.lastWidget = widget;
        this.lastWidgetX = x;
        this.lastWidgetY = y;
    }

    public void addMenuControl(Menu menu, Control parent) {
        this.popupMenuParents.put(menu, parent);
    }

    public synchronized void syncExecCalled(ContextManagement.Context ctx) {
        this.syncExecs.add(ctx);
    }

    public void hasEvent(HasEventKind hasEventKind, String name) {
        List<ITeslaEventListener> copy = this.getListeners();
        for (ITeslaEventListener listener : copy) {
            listener.hasEvent(hasEventKind, name);
        }
    }

    public synchronized void syncExecEnd(ContextManagement.Context ctx) {
        int i = 0;
        while (i < this.syncExecs.size()) {
            if (this.syncExecs.get(i) == ctx) {
                this.syncExecs.remove(i);
                return;
            }
            ++i;
        }
        this.syncExecs.remove(ctx);
    }

    public synchronized List<ContextManagement.Context> getSyncExecs() {
        return new ArrayList<ContextManagement.Context>(this.syncExecs);
    }

    public static void setActiveShell(Shell shell) {
        activeShell = shell;
        TeslaEventManager.updateActiveShell();
    }

    public static void updateActiveShell() {
    }

    public static Shell getActiveShell() {
        return activeShell;
    }

    public synchronized boolean isJobInSyncExec(Job job, ContextManagement.Context context) {
        for (ContextManagement.Context context2 : this.syncExecs) {
            String clName;
            if (!context2.containsClass(clName = job.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isFiltering() {
        return TeslaEventManager.getManager().hasListeners() && !RecordingModeFeature.isRecordingModeActive() && !this.isUnfreeze();
    }

    public Control getForceFocusControl() {
        Control ctrl;
        Control control = ctrl = this.forceFocusControl == null ? null : (Control)this.forceFocusControl.get();
        if (ctrl != null && ctrl.isDisposed()) {
            return null;
        }
        return ctrl;
    }

    public boolean setForceFocusControl(Control focusControl) {
        if (this.forceFocusControl == null || focusControl != this.forceFocusControl.get()) {
            this.forceFocusControl = new WeakReference<Control>(focusControl);
            return true;
        }
        return false;
    }

    public void ignoreMenuShow(boolean b) {
        this.ignoreMenuShow = b;
    }

    public boolean isIgnoreMenuShow() {
        return this.ignoreMenuShow;
    }

    public void setShellCreationMethod(Shell shell, String clName, String methodName) {
        for (Shell sh : new HashSet<Shell>(this.shellMethodsMap.keySet())) {
            if (sh == null || !sh.isDisposed()) continue;
            this.shellMethodsMap.remove(sh);
        }
        this.shellMethodsMap.put(shell, String.valueOf(clName) + "." + methodName);
    }

    public String getShellCreationMethod(Shell shell) {
        return this.shellMethodsMap.get(shell);
    }

    public boolean isStatusDialogModeAllowed() {
        return this.statusDialogModeAllowed;
    }

    public void setStatusDialogModeAllowed(boolean value) {
        this.statusDialogModeAllowed = value;
    }

    public void setNoWaitForJobs(boolean disableJobWaiting) {
        this.noWaitForJob = disableJobWaiting;
    }

    public boolean isNoWaitForJob() {
        return this.noWaitForJob;
    }

    public void unhandledNativeDialog(Class clazz, String message) {
        if (this.unhandledNativeDialogHandler != null) {
            this.unhandledNativeDialogHandler.handle(clazz, message);
        }
    }

    public void setUnhandledNativeDialogHandler(IUnhandledNativeDialogHandler unhandledNativeDialogHandler) {
        this.unhandledNativeDialogHandler = unhandledNativeDialogHandler;
    }

    public Object getWorkbench() {
        return this.lastWorkbench;
    }

    public Display getDisplay() {
        return this.lastDisplay;
    }

    public void setLastDisplay(Display lastDisplay) {
        if (this.lastDisplay != lastDisplay) {
            Display old = this.lastDisplay;
            this.lastDisplay = lastDisplay;
            this.synced.remove(old);
            this.popupMenuParents.clear();
            this.popupMenus.clear();
            this.allRegisteredMenu.clear();
            if (lastDisplay != null) {
                RWT.getUISession().addUISessionListener(new UISessionListener(){
                    private static final long serialVersionUID = 1L;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void beforeDestroy(UISessionEvent event) {
                        Boolean bl = TeslaEventManager.this.needSync;
                        synchronized (bl) {
                            TeslaEventManager.this.session = null;
                        }
                    }
                });
                this.session = new ServerPushSession();
                this.session.start();
                this.synced.put(lastDisplay, true);
            }
        }
    }

    public void setLastWorkbench(Object lastWorkbench) {
        Object old = this.lastWorkbench;
        this.lastWorkbench = lastWorkbench;
        for (IRwtWorkbenchListener listener : this.getWorkbenchListeners()) {
            listener.workbenchChnage(old, lastWorkbench);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        Boolean bl = this.needSync;
        synchronized (bl) {
            if (!this.needSync.booleanValue() && this.session != null) {
                this.session.start();
                this.needSync = true;
            }
        }
    }

    private void startSynchronizer() {
        Runnable bgRunnable = new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        this.push();
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void push() {
                Boolean bl = TeslaEventManager.this.needSync;
                synchronized (bl) {
                    if (TeslaEventManager.this.needSync.booleanValue() && TeslaEventManager.this.lastDisplay != null && !TeslaEventManager.this.lastDisplay.isDisposed() && Boolean.TRUE.equals(TeslaEventManager.this.synced.get(TeslaEventManager.this.lastDisplay))) {
                        final Display executor = TeslaEventManager.this.lastDisplay;
                        executor.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (RWT.getUISession() != null && TeslaEventManager.this.session != null) {
                                        TeslaEventManager.this.session.stop();
                                    }
                                }
                                finally {
                                    if ((this).TeslaEventManager.this.synced.containsKey(executor)) {
                                        (this).TeslaEventManager.this.synced.put(executor, true);
                                    }
                                    TeslaEventManager.this.needSync = false;
                                }
                            }
                        });
                        TeslaEventManager.this.synced.put(executor, false);
                    }
                }
            }
        };
        Thread bgThread = new Thread(bgRunnable);
        bgThread.setDaemon(true);
        bgThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkbenchListener(IRwtWorkbenchListener listener) {
        Set<IRwtWorkbenchListener> set = this.workbenchListeners;
        synchronized (set) {
            this.workbenchListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorkbenchListener(IRwtWorkbenchListener listener) {
        Set<IRwtWorkbenchListener> set = this.workbenchListeners;
        synchronized (set) {
            this.workbenchListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivatePushSession() {
        Boolean bl = this.needSync;
        synchronized (bl) {
            this.session.stop();
            this.lastDisplay = null;
            this.lastWorkbench = null;
            this.session = null;
        }
    }

    public static enum HasEventKind {
        async,
        sync,
        timer;

    }

    public static interface IUnhandledNativeDialogHandler {
        public void handle(Class var1, String var2);
    }
}

