/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler;

import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.garbagecollector.GarbageCollector;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatePlugin;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.LastAutoCheckForUpdateMemo;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration.MigrationSupport;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateChecker;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateListener;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.UpdateEvent;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

public class AutomaticUpdateScheduler
implements IStartup {
    public static final String MIGRATION_DIALOG_SHOWN = "migrationDialogShown";
    public static final String P_FUZZY_RECURRENCE = "fuzzy_recurrence";
    public static final String[] FUZZY_RECURRENCE = new String[]{AutomaticUpdateMessages.SchedulerStartup_OnceADay, AutomaticUpdateMessages.SchedulerStartup_OnceAWeek, AutomaticUpdateMessages.SchedulerStartup_OnceAMonth};
    private static final int ONE_HOUR_IN_MS = 3600000;
    private static final int ONE_DAY_IN_MS = 86400000;
    private IUpdateListener listener;
    private IUpdateChecker checker;

    public void earlyStartup() {
        AutomaticUpdatePlugin.getDefault().setScheduler(this);
        Job updateJob = new Job("Update Job"){

            protected IStatus run(IProgressMonitor monitor) {
                IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)AutomaticUpdatePlugin.getContext(), IProvisioningAgent.class);
                if (agent == null) {
                    String message = "No provisioning agent service found";
                    AutomaticUpdatePlugin.getDefault().getLog().warn(message, (Throwable)new IllegalStateException(message));
                    return Status.CANCEL_STATUS;
                }
                IProfileRegistry registry = (IProfileRegistry)agent.getService(IProfileRegistry.class);
                IProfile currentProfile = registry.getProfile("_SELF_");
                if (currentProfile != null && new MigrationSupport().performMigration(agent, registry, currentProfile)) {
                    return Status.OK_STATUS;
                }
                AutomaticUpdateScheduler.this.removeUnusedPlugins(registry, agent);
                AutomaticUpdateScheduler.this.scheduleUpdate();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return AutomaticUpdateScheduler.class == family;
            }

            public boolean shouldRun() {
                return PlatformUI.isWorkbenchRunning();
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule(20000L);
    }

    private void removeUnusedPlugins(IProfileRegistry registry, IProvisioningAgent agent) {
        IPreferenceStore pref = AutomaticUpdatePlugin.getDefault().getPreferenceStore();
        if (!pref.getBoolean("gcOnStartup")) {
            return;
        }
        GarbageCollector collector = (GarbageCollector)agent.getService(GarbageCollector.class);
        if (collector == null || registry == null) {
            return;
        }
        IProfile profile = registry.getProfile("_SELF_");
        if (profile == null) {
            return;
        }
        collector.runGC(profile);
    }

    public void shutdown() {
        this.removeUpdateListener();
    }

    public void rescheduleUpdate() {
        this.removeUpdateListener();
        this.scheduleUpdate();
    }

    private void scheduleUpdate() {
        IPreferenceStore pref = AutomaticUpdatePlugin.getDefault().getPreferenceStore();
        if (!pref.getBoolean("enabled")) {
            return;
        }
        String schedule = pref.getString("schedule");
        long delay = -1L;
        long poll = -1L;
        if (!schedule.equals("on-startup") && schedule.equals("on-fuzzy-schedule")) {
            delay = AutomaticUpdateScheduler.computeFuzzyDelay(pref);
            poll = AutomaticUpdateScheduler.computeFuzzyPoll(pref);
        }
        this.listener = new IUpdateListener(){

            public void updatesAvailable(UpdateEvent event) {
                AutomaticUpdatePlugin.getDefault().getAutomaticUpdater().updatesAvailable(event);
            }

            public void checkingForUpdates() {
                AutomaticUpdatePlugin.getDefault().getAutomaticUpdater().checkingForUpdates();
            }
        };
        IProvisioningAgent pagent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)AutomaticUpdatePlugin.getContext(), IProvisioningAgent.class);
        if (pagent == null) {
            String message = "No provisioning agent service found";
            AutomaticUpdatePlugin.getDefault().getLog().warn(message, (Throwable)new IllegalStateException(message));
            return;
        }
        this.checker = (IUpdateChecker)pagent.getService(IUpdateChecker.class);
        if (this.checker == null) {
            Status status = new Status(4, "org.eclipse.equinox.p2.ui.sdk.scheduler", AutomaticUpdateMessages.AutomaticUpdateScheduler_UpdateNotInitialized);
            StatusManager.getManager().handle((IStatus)status, 1);
            return;
        }
        this.checker.addUpdateCheck("_SELF_", this.getProfileQuery(), delay, poll, this.listener);
    }

    private IQuery<IInstallableUnit> getProfileQuery() {
        return new IUProfilePropertyQuery("org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
    }

    private static long computeFuzzyDelay(IPreferenceStore pref) {
        long poll;
        long lastCheckForUpdateSinceEpoch;
        Date nowDate = Calendar.getInstance().getTime();
        long now = nowDate.getTime();
        if (now - (lastCheckForUpdateSinceEpoch = new LastAutoCheckForUpdateMemo(AutomaticUpdatePlugin.getDefault().getAgentLocation()).readAndStoreIfAbsent(nowDate).getTime()) >= (poll = AutomaticUpdateScheduler.computeFuzzyPoll(pref)) + AutomaticUpdateScheduler.getMaxDelay(pref)) {
            return new Random().nextInt(3600000);
        }
        long delay = now - lastCheckForUpdateSinceEpoch;
        return poll - delay + (long)new Random().nextInt(28800000);
    }

    private static long getMaxDelay(IPreferenceStore pref) {
        String recurrence = pref.getString(P_FUZZY_RECURRENCE);
        if (AutomaticUpdateMessages.SchedulerStartup_OnceADay.equals(recurrence)) {
            return 21600000L;
        }
        if (AutomaticUpdateMessages.SchedulerStartup_OnceAWeek.equals(recurrence)) {
            return 172800000L;
        }
        return 518400000L;
    }

    private static long computeFuzzyPoll(IPreferenceStore pref) {
        String recurrence = pref.getString(P_FUZZY_RECURRENCE);
        if (AutomaticUpdateMessages.SchedulerStartup_OnceADay.equals(recurrence)) {
            return 86400000L;
        }
        if (AutomaticUpdateMessages.SchedulerStartup_OnceAWeek.equals(recurrence)) {
            return 604800000L;
        }
        return -1702967296L;
    }

    private void removeUpdateListener() {
        if (this.listener != null && this.checker != null) {
            this.checker.removeUpdateCheck(this.listener);
            this.listener = null;
        }
    }
}

