/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.internal.ui.views.ViewContextService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ViewContextManager
implements IWindowListener {
    private Map<IWorkbenchWindow, ViewContextService> fWindowToService = new HashMap<IWorkbenchWindow, ViewContextService>();
    private static ViewContextManager fgManager;

    public static ViewContextManager getDefault() {
        if (fgManager == null) {
            fgManager = new ViewContextManager();
        }
        return fgManager;
    }

    private ViewContextManager() {
        IWorkbenchWindow[] workbenchWindows;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = workbench.getWorkbenchWindows();
        int n = workbenchWindows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.windowOpened(window);
            ++n2;
        }
        workbench.addWindowListener((IWindowListener)this);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        ViewContextService service = this.fWindowToService.get(window);
        if (service != null) {
            this.fWindowToService.remove(window);
            service.dispose();
        }
    }

    public void windowOpened(IWorkbenchWindow window) {
        ViewContextService service = this.fWindowToService.get(window);
        if (service == null) {
            service = new ViewContextService(window);
            this.fWindowToService.put(window, service);
        }
    }

    public ViewContextService getService(IWorkbenchWindow window) {
        return this.fWindowToService.get(window);
    }
}

