/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.packager;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.packager.DeltaPackScriptGenerator;
import org.eclipse.pde.internal.build.packager.PackageScriptGenerator;
import org.eclipse.pde.internal.build.site.BuildTimeSiteFactory;

public class PackagerGenerator
extends BuildScriptGenerator {
    private String featureList = null;
    private String propertyFile;
    private boolean groupConfigs2;

    public PackagerGenerator() {
        this.generateBuildScript = false;
        this.children = true;
        this.groupConfigs2 = false;
    }

    public void setFeatureList(String features) {
        this.featureList = features;
    }

    @Override
    protected void sortElements(List<String> features, List<String> plugins) {
        String[] allFeatures;
        String[] stringArray = allFeatures = Utils.getArrayFromString(this.featureList);
        int n = allFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            String feature2 = stringArray[n2];
            features.add(feature2);
            ++n2;
        }
    }

    @Override
    protected void generatePackageScripts(AssemblyInformation assemblageInformation, String[] featureInfo, BuildTimeSiteFactory factory) throws CoreException {
        PackageScriptGenerator assembler = null;
        assembler = this.groupConfigs2 ? new DeltaPackScriptGenerator(workingDirectory, assemblageInformation, featureInfo[0]) : new PackageScriptGenerator(workingDirectory, assemblageInformation, featureInfo[0]);
        assembler.setSignJars(this.signJars);
        assembler.setGenerateJnlp(this.generateJnlp);
        assembler.setArchivesFormat(this.getArchivesFormat());
        assembler.setPropertyFile(this.propertyFile);
        assembler.setBackwardCompatibleName(true);
        assembler.setBuildSiteFactory(factory);
        assembler.setProduct(this.product);
        assembler.setProductQualifier(this.productQualifier);
        assembler.setVersionsList(this.generateVersionsList);
        assembler.generate();
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    public void groupConfigs(boolean value) {
        this.groupConfigs2 = value;
    }
}

