/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.parts.PluginVersionPart;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DependencyPropertiesDialog
extends StatusDialog {
    private Button fReexportButton;
    private Button fOptionalButton;
    private boolean fEditable;
    private boolean fShowReexport;
    private boolean fExported;
    private boolean fOptional;
    private PluginVersionPart fVersionPart;
    private boolean fShowOptional;
    private String fVersion;
    private String fPluginId;

    public DependencyPropertiesDialog(boolean editable, IPluginImport plugin) {
        this(editable, true, plugin.isReexported(), plugin.isOptional(), plugin.getVersion(), true, true, plugin.getId(), true);
    }

    public DependencyPropertiesDialog(boolean editable, ImportPackageObject object) {
        this(editable, false, false, object.isOptional(), object.getVersion(), true, true, object.getName(), false);
    }

    public DependencyPropertiesDialog(boolean editable, ExportPackageObject object) {
        this(editable, false, false, false, object.getVersion(), false, false, null, false);
    }

    public DependencyPropertiesDialog(boolean editable, boolean showReexport, boolean export, boolean optional, String version, boolean showOptional, boolean isImport, String pluginId, boolean isPlugin) {
        super(PDEPlugin.getActiveWorkbenchShell());
        this.fEditable = editable;
        this.fShowReexport = showReexport;
        this.fExported = export;
        this.fOptional = optional;
        this.fShowOptional = showOptional;
        this.fPluginId = pluginId;
        this.fVersionPart = isImport ? new PluginVersionPart(true, isPlugin) : new PluginVersionPart(false, isPlugin){

            @Override
            protected String getGroupText() {
                return PDEUIMessages.DependencyPropertiesDialog_exportGroupText;
            }
        };
        this.fVersionPart.setVersion(version);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, PDEUIMessages.DependencyPropertiesDialog_closeButtonLabel, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        if (this.fShowOptional || this.fShowReexport) {
            GridData gd;
            Group container = new Group(comp, 0);
            container.setText(PDEUIMessages.DependencyPropertiesDialog_properties);
            container.setLayout((Layout)new GridLayout());
            container.setLayoutData((Object)new GridData(768));
            if (this.fShowOptional) {
                this.fOptionalButton = new Button((Composite)container, 32);
                this.fOptionalButton.setText(PDEUIMessages.DependencyPropertiesDialog_optional);
                gd = new GridData();
                gd.horizontalSpan = 2;
                this.fOptionalButton.setLayoutData((Object)gd);
                this.fOptionalButton.setEnabled(this.fEditable);
                this.fOptionalButton.setSelection(this.fOptional);
            }
            if (this.fShowReexport) {
                this.fReexportButton = new Button((Composite)container, 32);
                this.fReexportButton.setText(PDEUIMessages.DependencyPropertiesDialog_reexport);
                gd = new GridData();
                gd.horizontalSpan = 2;
                this.fReexportButton.setLayoutData((Object)gd);
                this.fReexportButton.setEnabled(this.fEditable);
                this.fReexportButton.setSelection(this.fExported);
            }
        }
        this.fVersionPart.createVersionFields(comp, true, this.fEditable);
        ModifyListener ml = e -> this.updateStatus(this.fVersionPart.validateFullVersionRangeText(true));
        this.fVersionPart.addListeners(ml, ml);
        if (this.fPluginId != null && !this.fPluginId.equals("system.bundle")) {
            this.fVersionPart.createVersionSelectionField(comp, this.fPluginId);
        }
        return comp;
    }

    public boolean isReexported() {
        return this.fExported;
    }

    public boolean isOptional() {
        return this.fOptional;
    }

    public String getVersion() {
        return this.fVersion;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.fOptional = this.fOptionalButton == null ? false : this.fOptionalButton.getSelection();
        this.fExported = this.fReexportButton == null ? false : this.fReexportButton.getSelection();
        this.fVersion = this.fVersionPart.getVersion();
        super.okPressed();
    }
}

