/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.core.workspace.IWorkspaceFinder;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.core.workspace.WorkspaceFinder;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.Q7InternalTestCase;

public final class ModelCycleDetector {
    private ModelCycleDetector() {
    }

    public static boolean hasCycles(IQ7NamedElement[] elements) {
        return ModelCycleDetector.buildCycles((IQ7NamedElement[])elements, null, (IProgressMonitor)new NullProgressMonitor()).cycle;
    }

    public static boolean hasCycles(NamedElement ... elements) {
        IQ7NamedElement[] els = new IQ7NamedElement[elements.length];
        int i = 0;
        while (i < els.length) {
            els[i] = (IQ7NamedElement)RcpttCore.create((IResource)Q7Utils.getLocation(elements[i]));
            ++i;
        }
        return ModelCycleDetector.hasCycles(els);
    }

    public static CycleGraph buildCycles(IQ7NamedElement[] elements, IWorkspaceFinder finder, IProgressMonitor monitor) {
        try {
            CycleGraph gr = new CycleGraph();
            gr.graph = new HashMap<String, List<String>>();
            gr.elementsMap = new HashMap();
            monitor.beginTask("Check for circular dependencies", elements.length + 1);
            IQ7NamedElement[] iQ7NamedElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7NamedElement element = iQ7NamedElementArray[n2];
                if (monitor.isCanceled()) {
                    CycleGraph cycleGraph = gr;
                    return cycleGraph;
                }
                if (element instanceof ITestCase) {
                    ModelCycleDetector.addScenarioToGraph((ITestCase)element, gr, finder);
                } else if (element instanceof IContext) {
                    ModelCycleDetector.addContextToGraph((IContext)element, gr, finder);
                } else if (element instanceof ITestSuite) {
                    ModelCycleDetector.addTestSuiteToGraph((ITestSuite)element, gr, finder);
                }
                monitor.worked(1);
                ++n2;
            }
            int prevVal = 0;
            while (true) {
                if (monitor.isCanceled()) {
                    CycleGraph cycleGraph = gr;
                    return cycleGraph;
                }
                ModelCycleDetector.processGraph(gr.graph);
                if (gr.graph.size() == prevVal) break;
                prevVal = gr.graph.size();
            }
            gr.cycle = gr.graph.size() >= 2;
            CycleGraph cycleGraph = gr;
            return cycleGraph;
        }
        finally {
            monitor.done();
        }
    }

    private static void processGraph(Map<String, List<String>> graph) {
        Set<Map.Entry<String, List<String>>> nodes = graph.entrySet();
        Iterator<Map.Entry<String, List<String>>> it = nodes.iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<String>> entry = it.next();
            List<String> childIds = entry.getValue();
            Iterator<String> it2 = childIds.iterator();
            while (it2.hasNext()) {
                String childId = it2.next();
                if (graph.containsKey(childId)) continue;
                it2.remove();
            }
            if (childIds.size() != 0) continue;
            it.remove();
        }
    }

    private static void addContextToGraph(IContext context, CycleGraph graph, IWorkspaceFinder finder) {
        IContext[] children = RcpttCore.getInstance().getContexts(context, finder, true);
        try {
            String cid = ModelCycleDetector.getIdBy(context);
            graph.elementsMap.put(cid, context);
            IContext[] iContextArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    List<String> childIds;
                    IContext child;
                    block7: {
                        block6: {
                            child = iContextArray[n2];
                            if (RcpttCore.getInstance().getContextReferences(child).isEmpty()) break block5;
                            childIds = graph.graph.get(cid);
                            if (childIds != null) break block6;
                            childIds = new ArrayList<String>();
                            graph.graph.put(cid, childIds);
                            break block7;
                        }
                        if (childIds.contains(ModelCycleDetector.getIdBy(child))) break block5;
                    }
                    childIds.add(ModelCycleDetector.getIdBy(child));
                    ModelCycleDetector.addContextToGraph(child, graph, finder);
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)((Object)e));
        }
    }

    private static void addTestSuiteToGraph(ITestSuite suite, CycleGraph graph, IWorkspaceFinder finder) {
        if (finder == null) {
            finder = WorkspaceFinder.getInstance();
        }
        try {
            TestSuiteItem[] items = suite.getItems();
            try {
                String cid = ModelCycleDetector.getIdBy(suite);
                graph.elementsMap.put(cid, suite);
                if (items != null && items.length > 0) {
                    List<String> childIds = graph.graph.get(cid);
                    TestSuiteItem[] testSuiteItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TestSuiteItem testSuiteItem = testSuiteItemArray[n2];
                        String childID = testSuiteItem.getNamedElementId();
                        if (childIds == null || !childIds.contains(childID)) {
                            ITestSuite[] suites;
                            int n3;
                            if (childIds == null) {
                                childIds = new ArrayList<String>();
                                graph.graph.put(cid, childIds);
                            }
                            childIds.add(childID);
                            ITestCase[] cases = finder.findTestcase(suite, childID);
                            if (cases != null) {
                                ITestCase[] iTestCaseArray = cases;
                                n3 = cases.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    ITestCase iTestCase = iTestCaseArray[n4];
                                    ModelCycleDetector.addScenarioToGraph(iTestCase, graph, finder);
                                    ++n4;
                                }
                            }
                            if ((suites = finder.findTestsuites(suite, childID)) != null) {
                                ITestSuite[] iTestSuiteArray = suites;
                                int n5 = suites.length;
                                n3 = 0;
                                while (n3 < n5) {
                                    ITestSuite testSuite = iTestSuiteArray[n3];
                                    ModelCycleDetector.addTestSuiteToGraph(testSuite, graph, finder);
                                    ++n3;
                                }
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (ModelException e) {
                RcpttPlugin.log((Throwable)((Object)e));
            }
        }
        catch (ModelException e1) {
            RcpttPlugin.log((Throwable)((Object)e1));
        }
    }

    private static String getIdBy(IQ7NamedElement context) throws ModelException {
        String cid = Q7SearchCore.findIDByDocument(context);
        if (cid == null) {
            cid = context.getID();
        }
        return cid;
    }

    private static void addScenarioToGraph(ITestCase scenario, CycleGraph graph, IWorkspaceFinder finder) {
        IContext[] contexts;
        if (scenario instanceof Q7InternalTestCase) {
            return;
        }
        try {
            if (!scenario.exists()) {
                return;
            }
        }
        catch (Exception e) {
            RcpttPlugin.log(e);
            return;
        }
        IContext[] iContextArray = contexts = RcpttCore.getInstance().getContexts(scenario, finder, true);
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IContext c = iContextArray[n2];
            if (!RcpttCore.getInstance().isNotGroupOrSuperOrCapabilityContext(c)) {
                ModelCycleDetector.addContextToGraph(c, graph, finder);
            }
            ++n2;
        }
    }

    public static class CycleGraph {
        public Map<String, List<String>> graph;
        public boolean cycle;
        public HashMap<String, IQ7NamedElement> elementsMap;
    }
}

