/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.utils;

import java.util.List;
import org.eclipse.rcptt.tesla.core.ui.StyleRangeEntry;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;

public class RangeUtils {
    public static StyleRange[] fromEMF(List<StyleRangeEntry> entries, Device device) {
        StyleRange[] ranges = new StyleRange[entries.size()];
        int i = 0;
        while (i < entries.size()) {
            ranges[i] = RangeUtils.fromEMF(entries.get(i), device);
            ++i;
        }
        return ranges;
    }

    public static StyleRange fromEMF(StyleRangeEntry entry, Device device) {
        StyleRange range = new StyleRange();
        range.background = RangeUtils.colorFromEMF(entry.getBackgroundColor(), device);
        range.borderColor = RangeUtils.colorFromEMF(entry.getBorderColor(), device);
        range.borderStyle = RangeUtils.borderFromEMF(entry.getBorderStyle());
        range.font = null;
        range.fontStyle = RangeUtils.fontFromEMF(entry.getFontStyle());
        range.foreground = RangeUtils.colorFromEMF(entry.getForegroundColor(), device);
        range.length = entry.getLength();
        range.metrics = null;
        range.rise = entry.getRise() == null ? 0 : entry.getRise();
        range.start = entry.getStart();
        range.strikeout = entry.getStrikeout() == null ? false : entry.getStrikeout();
        range.strikeoutColor = RangeUtils.colorFromEMF(entry.getStrikeoutColor(), device);
        range.underline = entry.getUnderline() != null;
        range.underlineColor = RangeUtils.colorFromEMF(entry.getUnderlineColor(), device);
        range.underlineStyle = RangeUtils.underlineFromEMF(entry.getUnderline());
        return range;
    }

    private static int underlineFromEMF(String style) {
        int result = 0;
        if (style == null) {
            return result;
        }
        if (style.equals("single")) {
            result = 0;
        } else if (style.equals("double")) {
            result = 1;
        } else if (style.equals("squiggle")) {
            result = 3;
        } else if (style.equals("error")) {
            result = 2;
        } else if (style.equals("link")) {
            result = 4;
        }
        return result;
    }

    private static int fontFromEMF(String style) {
        int result = 0;
        if (style == null) {
            return result;
        }
        if (style.equals("bold")) {
            result = 1;
        } else if (style.equals("italic")) {
            result = 2;
        } else if (style.equals("bold-italic")) {
            result = 3;
        }
        return result;
    }

    public static int borderFromEMF(String style) {
        int result = 0;
        if (style == null) {
            return result;
        }
        if (style.equals("solid")) {
            result = 1;
        } else if (style.equals("dot")) {
            result = 4;
        } else if (style.equals("dash")) {
            result = 2;
        }
        return result;
    }

    public static Color colorFromEMF(org.eclipse.rcptt.tesla.core.ui.Color color, Device device) {
        if (color == null) {
            return null;
        }
        return new Color(device, color.getRed(), color.getGreen(), color.getBlue());
    }
}

