/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.TextEditorPropertyAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.WhitespaceCharacterPainter;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ShowWhitespaceAction
extends TextEditorPropertyAction {
    private IPainter whitespaceCharPainter;

    public ShowWhitespaceAction(ITextViewer viewer) {
        this(viewer, false);
    }

    public ShowWhitespaceAction(ITextViewer viewer, boolean initiallyOff) {
        super(UIText.SpellcheckableMessageArea_showWhitespace, viewer, "showWhitespaceCharacters", initiallyOff);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property == null) {
            return;
        }
        switch (property) {
            case "showEnclosedSpaces": 
            case "showLeadingSpaces": 
            case "showTrailingIdeographicSpaces": 
            case "showLeadingTabs": 
            case "showEnclosedIdeographicSpaces": 
            case "showWhitespaceCharacters": 
            case "showLineFeed": 
            case "whitespaceCharacterAlphaValue": 
            case "showTrailingTabs": 
            case "showEnclosedTabs": 
            case "showLeadingIdeographicSpaces": 
            case "showTrailingSpaces": 
            case "showCarriageReturn": {
                this.synchronizeWithPreference();
                break;
            }
        }
    }

    @Override
    protected final String getPreferenceKey() {
        return "showWhitespaceCharacters";
    }

    @Override
    protected void toggleState(boolean checked) {
        if (checked) {
            this.installPainter();
        } else {
            this.uninstallPainter();
        }
    }

    private void installPainter() {
        Assert.isTrue((this.whitespaceCharPainter == null ? 1 : 0) != 0);
        ITextViewer v = this.getTextViewer();
        if (v instanceof ITextViewerExtension2) {
            IPreferenceStore store = this.getStore();
            this.whitespaceCharPainter = new WhitespaceCharacterPainter(v, store.getBoolean("showLeadingSpaces"), store.getBoolean("showEnclosedSpaces"), store.getBoolean("showTrailingSpaces"), store.getBoolean("showLeadingIdeographicSpaces"), store.getBoolean("showEnclosedIdeographicSpaces"), store.getBoolean("showTrailingIdeographicSpaces"), store.getBoolean("showLeadingTabs"), store.getBoolean("showEnclosedTabs"), store.getBoolean("showTrailingTabs"), store.getBoolean("showCarriageReturn"), store.getBoolean("showLineFeed"), store.getInt("whitespaceCharacterAlphaValue"));
            ((ITextViewerExtension2)v).addPainter(this.whitespaceCharPainter);
        }
    }

    private void uninstallPainter() {
        if (this.whitespaceCharPainter == null) {
            return;
        }
        ITextViewer v = this.getTextViewer();
        if (v instanceof ITextViewerExtension2) {
            ((ITextViewerExtension2)v).removePainter(this.whitespaceCharPainter);
        }
        this.whitespaceCharPainter.deactivate(true);
        this.whitespaceCharPainter = null;
    }
}

