/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.sourcelookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.sourcelookup.AbstractSourceContainerBrowser;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ProjectSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.sourcelookup.SourceLookupMessages;
import org.eclipse.jdt.launching.sourcelookup.containers.ClasspathContainerSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.ClasspathVariableSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;

public class JavaProjectSourceContainerBrowser
extends AbstractSourceContainerBrowser {
    public ISourceContainer[] addSourceContainers(Shell shell, ISourceLookupDirector director) {
        List<IJavaProject> projects = this.getPossibleAdditions(director);
        ProjectSelectionDialog dialog = new ProjectSelectionDialog(shell, projects);
        dialog.setTitle(SourceLookupMessages.JavaProjectSourceContainerBrowser_1);
        MultiStatus status = new MultiStatus(JDIDebugUIPlugin.getUniqueIdentifier(), 150, "Failed to add project(s)", null);
        ArrayList<ISourceContainer> sourceContainers = new ArrayList<ISourceContainer>();
        if (dialog.open() == 0) {
            Object[] selections = dialog.getResult();
            ArrayList<IJavaProject> additions = new ArrayList<IJavaProject>(selections.length);
            try {
                Object[] objectArray = selections;
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selection = objectArray[n2];
                    IJavaProject jp = (IJavaProject)selection;
                    if (dialog.isAddRequiredProjects()) {
                        this.collectRequiredProjects(jp, additions);
                    } else {
                        additions.add(jp);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                status.add(e.getStatus());
            }
            for (IJavaProject jp : additions) {
                sourceContainers.add((ISourceContainer)new JavaProjectSourceContainer(jp));
                if (!dialog.isAddExportedEntries()) continue;
                try {
                    this.collectExportedEntries(jp, sourceContainers);
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
            }
        }
        if (!status.isOK()) {
            JDIDebugUIPlugin.statusDialog((IStatus)status);
        }
        return sourceContainers.toArray(new ISourceContainer[sourceContainers.size()]);
    }

    protected List<IJavaProject> getPossibleAdditions(ISourceLookupDirector director) {
        IJavaProject[] projects;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
            projects = new IJavaProject[]{};
        }
        ArrayList<IJavaProject> remaining = new ArrayList<IJavaProject>();
        IJavaProject[] iJavaProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            remaining.add(project);
            ++n2;
        }
        ArrayList<IJavaProject> alreadySelected = new ArrayList<IJavaProject>();
        ISourceContainer[] iSourceContainerArray = director.getSourceContainers();
        int n3 = iSourceContainerArray.length;
        n = 0;
        while (n < n3) {
            ISourceContainer container = iSourceContainerArray[n];
            if (container.getType().getId().equals(JavaProjectSourceContainer.TYPE_ID)) {
                alreadySelected.add(((JavaProjectSourceContainer)container).getJavaProject());
            }
            ++n;
        }
        remaining.removeAll(alreadySelected);
        return remaining;
    }

    protected void collectRequiredProjects(IJavaProject proj, List<IJavaProject> res) throws JavaModelException {
        if (!res.contains(proj)) {
            res.add(proj);
            IJavaModel model = proj.getJavaModel();
            IClasspathEntry[] iClasspathEntryArray = proj.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject ref;
                IClasspathEntry curr = iClasspathEntryArray[n2];
                if (curr.getEntryKind() == 2 && (ref = model.getJavaProject(curr.getPath().segment(0))).exists()) {
                    this.collectRequiredProjects(ref, res);
                }
                ++n2;
            }
        }
    }

    protected void collectExportedEntries(IJavaProject proj, List<ISourceContainer> list) throws CoreException {
        IClasspathEntry[] iClasspathEntryArray = proj.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            ClasspathVariableSourceContainer sourceContainer = null;
            if (entry.isExported()) {
                switch (entry.getEntryKind()) {
                    case 5: {
                        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)proj);
                        sourceContainer = new ClasspathContainerSourceContainer(container.getPath());
                        break;
                    }
                    case 1: {
                        IPackageFragmentRoot[] roots = proj.findPackageFragmentRoots(entry);
                        if (roots == null || roots.length <= 0) break;
                        sourceContainer = new PackageFragmentRootSourceContainer(roots[0]);
                        break;
                    }
                    case 2: {
                        IJavaProject jp;
                        String name = entry.getPath().segment(0);
                        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        if (!p.exists() || !(jp = JavaCore.create((IProject)p)).exists()) break;
                        sourceContainer = new JavaProjectSourceContainer(jp);
                        break;
                    }
                    case 4: {
                        sourceContainer = new ClasspathVariableSourceContainer(entry.getPath());
                        break;
                    }
                }
                if (sourceContainer != null && !list.contains(sourceContainer)) {
                    list.add((ISourceContainer)sourceContainer);
                }
            }
            ++n2;
        }
    }

    class ContentProvider
    implements IStructuredContentProvider {
        private final List<IJavaProject> fProjects;

        public ContentProvider(List<IJavaProject> projects) {
            this.fProjects = projects;
        }

        public Object[] getElements(Object inputElement) {
            return this.fProjects.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

