/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.externaltools.internal.launchConfigurations;

import org.eclipse.core.externaltools.internal.launchConfigurations.ExternalToolsProgramMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.debug.core.model.IProcess;

public class BackgroundResourceRefresher
implements IDebugEventSetListener {
    private final ILaunchConfiguration fConfiguration;
    private final IProcess fProcess;

    public BackgroundResourceRefresher(ILaunchConfiguration configuration, IProcess process) {
        this.fConfiguration = configuration;
        this.fProcess = process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBackgroundRefresh() {
        IProcess iProcess = this.fProcess;
        synchronized (iProcess) {
            if (this.fProcess.isTerminated()) {
                this.refresh();
            } else {
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getSource() == this.fProcess && event.getKind() == 8) {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                this.refresh();
                break;
            }
            ++n2;
        }
    }

    protected void refresh() {
        Job.create((String)ExternalToolsProgramMessages.BackgroundResourceRefresher_0, monitor -> RefreshUtil.refreshResources((ILaunchConfiguration)this.fConfiguration, (IProgressMonitor)monitor)).schedule();
    }
}

