/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommit;

class SWTWalk
extends PlotWalk {
    @NonNull
    private final Repository repo;
    private Ref head;
    private boolean headInitialized;

    SWTWalk(@NonNull Repository repo) {
        super(repo);
        this.repo = repo;
    }

    @NonNull
    Repository getRepository() {
        return this.repo;
    }

    protected void reset(int retainFlags) {
        this.headInitialized = false;
        this.head = null;
        super.reset(retainFlags);
    }

    public RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (!this.headInitialized) {
            this.head = this.determineHead();
            this.headInitialized = true;
        }
        return super.next();
    }

    public Ref getHead() throws IOException {
        if (!this.headInitialized) {
            this.head = this.determineHead();
            this.headInitialized = true;
        }
        return this.head;
    }

    protected RevCommit createCommit(AnyObjectId id) {
        return new SWTCommit(id, this);
    }

    private Ref determineHead() throws IOException {
        Ref h = this.repo.exactRef("HEAD");
        if (h != null && h.isSymbolic()) {
            return h;
        }
        return null;
    }
}

