/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.InterruptibleVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class StaticInnerClassCleanUpCore
extends AbstractMultiFix {
    private static final String JUPITER_NESTED = "org.junit.jupiter.api.Nested";

    public StaticInnerClassCleanUpCore() {
        this(Collections.emptyMap());
    }

    public StaticInnerClassCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.static_inner_class");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.static_inner_class")) {
            return new String[]{MultiFixMessages.StaticInnerClassCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        if (this.isEnabled("cleanup.static_inner_class")) {
            bld.append("public static class InnerClass {\n");
        } else {
            bld.append("public class InnerClass {\n");
        }
        bld.append("    int i;\n");
        bld.append("\n");
        bld.append("    public boolean anotherMethod() {\n");
        bld.append("        return true;\n");
        bld.append("    }\n");
        bld.append("}\n");
        return bld.toString();
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.static_inner_class")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(TypeDeclaration visited) {
                if (!visited.isInterface() && !Modifier.isStatic((int)visited.getModifiers()) && visited.resolveBinding() != null) {
                    HashSet<ITypeBinding> genericityTypes = new HashSet<ITypeBinding>();
                    ASTNode enclosingType = ASTNodes.getFirstAncestorOrNull((ASTNode)visited, TypeDeclaration.class, MethodDeclaration.class);
                    if (enclosingType instanceof TypeDeclaration && ((TypeDeclaration)enclosingType).isInterface()) {
                        return true;
                    }
                    List modifiers = visited.modifiers();
                    for (IExtendedModifier modifier : modifiers) {
                        Name name;
                        ITypeBinding nameBinding;
                        Annotation annotation;
                        if (!modifier.isAnnotation() || !(annotation = (Annotation)modifier).isMarkerAnnotation() || (nameBinding = (name = annotation.getTypeName()).resolveTypeBinding()) == null || !nameBinding.getQualifiedName().equals(StaticInnerClassCleanUpCore.JUPITER_NESTED)) continue;
                        return true;
                    }
                    TypeDeclaration topLevelClass = null;
                    while (enclosingType instanceof TypeDeclaration) {
                        topLevelClass = (TypeDeclaration)enclosingType;
                        if (!Modifier.isPrivate((int)visited.getModifiers()) && !Modifier.isFinal((int)topLevelClass.getModifiers())) {
                            return true;
                        }
                        ITypeBinding topLevelClassBinding = topLevelClass.resolveBinding();
                        if (topLevelClassBinding == null) {
                            return true;
                        }
                        Collections.addAll(genericityTypes, topLevelClassBinding.getTypeParameters());
                        enclosingType = ASTNodes.getTypedAncestor((ASTNode)topLevelClass, TypeDeclaration.class);
                        if (enclosingType == null || Modifier.isStatic((int)topLevelClass.getModifiers())) continue;
                        return true;
                    }
                    if (topLevelClass != null && !this.hasInnerDynamicMotherType(visited)) {
                        TopLevelClassMemberVisitor topLevelClassMemberVisitor = new TopLevelClassMemberVisitor(visited, genericityTypes);
                        topLevelClassMemberVisitor.traverseNodeInterruptibly((ASTNode)visited);
                        if (!topLevelClassMemberVisitor.isTopLevelClassMemberUsed()) {
                            DynamicClassInstanceCreationVisitor dynamicClassInstanceCreationVisitor = new DynamicClassInstanceCreationVisitor(visited.resolveBinding());
                            topLevelClass.accept((ASTVisitor)dynamicClassInstanceCreationVisitor);
                            rewriteOperations.add(new StaticInnerClassOperation(visited, dynamicClassInstanceCreationVisitor.getDynamicClassInstanceCreations()));
                            return false;
                        }
                    }
                }
                return true;
            }

            private boolean hasInnerDynamicMotherType(TypeDeclaration visited) {
                if (visited.resolveBinding() == null) {
                    return true;
                }
                ITypeBinding motherType = visited.resolveBinding().getSuperclass();
                while (motherType != null) {
                    if (motherType.getDeclaringClass() != null && !Modifier.isStatic((int)motherType.getModifiers())) {
                        return true;
                    }
                    motherType = motherType.getSuperclass();
                }
                return false;
            }

            class DynamicClassInstanceCreationVisitor
            extends ASTVisitor {
                private final ITypeBinding innerClass;
                private final List<ClassInstanceCreation> dynamicClassInstanceCreations = new ArrayList<ClassInstanceCreation>();

                public DynamicClassInstanceCreationVisitor(ITypeBinding innerClass) {
                    this.innerClass = innerClass;
                }

                public List<ClassInstanceCreation> getDynamicClassInstanceCreations() {
                    return this.dynamicClassInstanceCreations;
                }

                public boolean visit(ClassInstanceCreation node) {
                    if (this.innerClass.getErasure().isEqualTo((IBinding)node.getType().resolveBinding().getErasure()) && node.getExpression() != null) {
                        this.dynamicClassInstanceCreations.add(node);
                    }
                    return true;
                }

                public boolean visit(TypeDeclaration node) {
                    return !this.innerClass.getErasure().isEqualTo((IBinding)node.resolveBinding().getErasure());
                }
            }

            class TopLevelClassMemberVisitor
            extends InterruptibleVisitor {
                private final TypeDeclaration innerClass;
                private final Set<ITypeBinding> genericityTypes;
                private boolean isTopLevelClassMemberUsed;

                public TopLevelClassMemberVisitor(TypeDeclaration innerClass, Set<ITypeBinding> genericityTypes) {
                    this.innerClass = innerClass;
                    this.genericityTypes = genericityTypes;
                }

                public boolean isTopLevelClassMemberUsed() {
                    return this.isTopLevelClassMemberUsed;
                }

                public boolean visit(SimpleName node) {
                    ASTNode declaration;
                    MethodInvocation methodInvocation;
                    if (this.innerClass.getName() == node || node.getLocationInParent() == QualifiedName.NAME_PROPERTY || node.getLocationInParent() == FieldAccess.NAME_PROPERTY || node.getLocationInParent() == SuperFieldAccess.NAME_PROPERTY) {
                        return true;
                    }
                    if (node.getLocationInParent() == MethodInvocation.NAME_PROPERTY && (methodInvocation = (MethodInvocation)node.getParent()).getExpression() != null) {
                        return true;
                    }
                    IBinding binding = node.resolveBinding();
                    ASTNode root = node.getRoot();
                    if (binding == null || !(root instanceof CompilationUnit)) {
                        this.isTopLevelClassMemberUsed = true;
                        return this.interruptVisit();
                    }
                    if (!(Modifier.isStatic((int)binding.getModifiers()) || binding.getKind() == 5 || binding.getKind() == 6 || binding.getKind() == 7 || binding.getKind() == 1 || binding.getKind() == 2 || (declaration = ((CompilationUnit)root).findDeclaringNode(binding)) != null && ASTNodes.isParent(declaration, (ASTNode)this.innerClass))) {
                        this.isTopLevelClassMemberUsed = true;
                        return this.interruptVisit();
                    }
                    return true;
                }

                public boolean visit(ThisExpression node) {
                    if (node.getQualifier() == null || ASTNodes.isSameVariable((ASTNode)this.innerClass.getName(), (ASTNode)node.getQualifier())) {
                        return true;
                    }
                    this.isTopLevelClassMemberUsed = true;
                    return this.interruptVisit();
                }

                public boolean visit(ClassInstanceCreation node) {
                    if (node.getExpression() != null) {
                        return true;
                    }
                    ITypeBinding type = node.resolveTypeBinding();
                    if (type != null && (type.isTopLevel() || Modifier.isStatic((int)type.getModifiers()))) {
                        return true;
                    }
                    this.isTopLevelClassMemberUsed = true;
                    return this.interruptVisit();
                }

                public boolean visit(SimpleType node) {
                    if (node.resolveBinding() == null || this.genericityTypes.contains(node.resolveBinding())) {
                        this.isTopLevelClassMemberUsed = true;
                        return this.interruptVisit();
                    }
                    return true;
                }
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.StaticInnerClassCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class StaticInnerClassOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final TypeDeclaration visited;
        private final List<ClassInstanceCreation> dynamicClassInstanceCreations;

        public StaticInnerClassOperation(TypeDeclaration visited, List<ClassInstanceCreation> dynamicClassInstanceCreations) {
            this.visited = visited;
            this.dynamicClassInstanceCreations = dynamicClassInstanceCreations;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)this.visited, TypeDeclaration.MODIFIERS2_PROPERTY);
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.StaticInnerClassCleanUp_description, cuRewrite);
            for (ClassInstanceCreation dynamicClassInstanceCreation : this.dynamicClassInstanceCreations) {
                if (!dynamicClassInstanceCreation.getType().isQualifiedType() && dynamicClassInstanceCreation.getType().resolveBinding() != null) {
                    ThisExpression thisExpression = ASTNodes.as(dynamicClassInstanceCreation.getExpression(), ThisExpression.class);
                    if (thisExpression != null) {
                        if (thisExpression.getQualifier() != null) {
                            SimpleName newSimpleName = ast.newSimpleName(dynamicClassInstanceCreation.getType().resolveBinding().getName());
                            QualifiedName newQualifiedName = ast.newQualifiedName(ASTNodes.createMoveTarget(rewrite, thisExpression.getQualifier()), newSimpleName);
                            SimpleType newType = ast.newSimpleType((Name)newQualifiedName);
                            rewrite.replace((ASTNode)dynamicClassInstanceCreation.getType(), (ASTNode)newType, group);
                        }
                    } else {
                        String qualifiedName = dynamicClassInstanceCreation.getExpression().resolveTypeBinding().getErasure().getQualifiedName();
                        String[] qualifiedNameTokens = qualifiedName.split("\\.");
                        Object newQualifiedName = null;
                        String[] stringArray = qualifiedNameTokens;
                        int n = qualifiedNameTokens.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String qualifiedNameToken = stringArray[n2];
                            newQualifiedName = newQualifiedName == null ? ast.newSimpleName(qualifiedNameToken) : ast.newQualifiedName((Name)newQualifiedName, ast.newSimpleName(qualifiedNameToken));
                            ++n2;
                        }
                        SimpleName newSimpleName = ast.newSimpleName(dynamicClassInstanceCreation.getType().resolveBinding().getName());
                        newQualifiedName = ast.newQualifiedName((Name)newQualifiedName, newSimpleName);
                        SimpleType newType = ast.newSimpleType((Name)newQualifiedName);
                        rewrite.replace((ASTNode)dynamicClassInstanceCreation.getType(), (ASTNode)newType, group);
                    }
                }
                rewrite.set((ASTNode)dynamicClassInstanceCreation, (StructuralPropertyDescriptor)ClassInstanceCreation.EXPRESSION_PROPERTY, null, group);
            }
            List modifiers = this.visited.modifiers();
            Modifier static0 = ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD);
            if (modifiers.isEmpty()) {
                listRewrite.insertFirst((ASTNode)static0, group);
            } else {
                IExtendedModifier lastModifier = (IExtendedModifier)modifiers.get(modifiers.size() - 1);
                if (lastModifier.isModifier() && ((Modifier)lastModifier).isFinal()) {
                    listRewrite.insertBefore((ASTNode)static0, (ASTNode)lastModifier, group);
                } else {
                    listRewrite.insertLast((ASTNode)static0, group);
                }
            }
        }
    }
}

