/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.provider;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IPropertyEditorFactory;

public abstract class PropertyEditorFactory
implements IPropertyEditorFactory {
    protected final URI propertyEditorFactoryURI;

    public PropertyEditorFactory(URI propertyEditorFactoryURI) {
        this.propertyEditorFactoryURI = propertyEditorFactoryURI;
    }

    public URI getPropertyEditorFactoryURI() {
        return this.propertyEditorFactoryURI;
    }

    @Override
    public IItemLabelProvider createLabelProvider(Object object, IItemPropertyDescriptor propertyDescriptor) {
        return null;
    }

    public boolean validate(EModelElement eModelElement, URI propertyEditorSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    protected EStructuralFeature getEStructuralFeature(Object object, IItemPropertyDescriptor propertyDescriptor) {
        Object feature = propertyDescriptor.getFeature(object);
        if (feature instanceof EStructuralFeature) {
            return (EStructuralFeature)feature;
        }
        return null;
    }

    protected URI getPropertyEditorURI(Object object, IItemPropertyDescriptor propertyDescriptor) {
        Object editorFactory;
        if (propertyDescriptor instanceof IPropertyEditorFactory.Provider && (editorFactory = ((IPropertyEditorFactory.Provider)((Object)propertyDescriptor)).getEditorFactory(object)) instanceof URI) {
            return (URI)editorFactory;
        }
        return null;
    }

    protected int getStyle(String style, Map<String, Integer> styles) {
        int result = 0;
        for (String styleElement : this.getStyleElements(style)) {
            Integer value = styles.get(styleElement);
            if (value == null) continue;
            result |= value.intValue();
        }
        return result;
    }

    protected List<String> getStyleElements(String style) {
        String[] styleElements = style.split("\\|");
        return Arrays.asList(styleElements);
    }

    public Set<String> getChoices(EModelElement eModelElement) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add("");
        return result;
    }

    protected BasicDiagnostic createDiagnostic(int severity, int code, String message, Object ... data) {
        return new BasicDiagnostic(severity, this.getPropertyEditorFactoryURI().authority(), code, message, data);
    }

    protected String getString(String key, Object ... substitutions) {
        return this.getString(this.getResourceLocator(), key, substitutions);
    }

    protected String getString(ResourceLocator resourceLocator, String key, Object ... substitutions) {
        return substitutions == null ? resourceLocator.getString(key) : resourceLocator.getString(key, substitutions);
    }

    protected ResourceLocator getResourceLocator() {
        return this.getEMFEditResourceLocator();
    }

    protected ResourceLocator getEMFEditResourceLocator() {
        return EMFEditPlugin.INSTANCE;
    }
}

