/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol.diagram;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MouseCommandKind implements Enumerator
{
    DOWN(0, "Down", "Down"),
    UP(1, "Up", "Up"),
    MOVE(2, "Move", "Move"),
    DRAG(3, "Drag", "Drag"),
    DOUBLE_CLICK(4, "DoubleClick", "DoubleClick"),
    NATIVE_DRAG_STARTED(5, "NativeDragStarted", "NativeDragStarted"),
    NATIVE_DRAG_FINISHED(6, "NativeDragFinished", "NativeDragFinished"),
    ENTER(7, "Enter", "Enter"),
    EXIT(8, "Exit", "Exit"),
    HOVER(9, "Hover", "Hover");

    public static final int DOWN_VALUE = 0;
    public static final int UP_VALUE = 1;
    public static final int MOVE_VALUE = 2;
    public static final int DRAG_VALUE = 3;
    public static final int DOUBLE_CLICK_VALUE = 4;
    public static final int NATIVE_DRAG_STARTED_VALUE = 5;
    public static final int NATIVE_DRAG_FINISHED_VALUE = 6;
    public static final int ENTER_VALUE = 7;
    public static final int EXIT_VALUE = 8;
    public static final int HOVER_VALUE = 9;
    private static final MouseCommandKind[] VALUES_ARRAY;
    public static final List<MouseCommandKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MouseCommandKind[]{DOWN, UP, MOVE, DRAG, DOUBLE_CLICK, NATIVE_DRAG_STARTED, NATIVE_DRAG_FINISHED, ENTER, EXIT, HOVER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MouseCommandKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MouseCommandKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MouseCommandKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MouseCommandKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MouseCommandKind get(int value) {
        switch (value) {
            case 0: {
                return DOWN;
            }
            case 1: {
                return UP;
            }
            case 2: {
                return MOVE;
            }
            case 3: {
                return DRAG;
            }
            case 4: {
                return DOUBLE_CLICK;
            }
            case 5: {
                return NATIVE_DRAG_STARTED;
            }
            case 6: {
                return NATIVE_DRAG_FINISHED;
            }
            case 7: {
                return ENTER;
            }
            case 8: {
                return EXIT;
            }
            case 9: {
                return HOVER;
            }
        }
        return null;
    }

    private MouseCommandKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

