/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.views.repository;

import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.RequirementImpl;
import org.eclipse.pde.bnd.ui.Resources;
import org.eclipse.pde.bnd.ui.views.repository.SearchPanel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.osgi.resource.Requirement;

public class ServiceSearchPanel
extends SearchPanel {
    private String serviceClass;
    private Control focusControl;

    @Override
    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        Label lblInstruction = new Label(container, 16448);
        lblInstruction.setText("Enter a service interface type name, which may contain wildcard characters (\"*\").");
        lblInstruction.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        new Label(container, 0).setText("Service Interface:");
        Text txtName = new Text(container, 2048);
        if (this.serviceClass != null) {
            txtName.setText(this.serviceClass);
        }
        txtName.setLayoutData((Object)new GridData(4, 4, true, false));
        txtName.addModifyListener(e -> {
            this.serviceClass = txtName.getText().trim();
            this.validate();
        });
        this.focusControl = txtName;
        this.validate();
        return container;
    }

    public void validate() {
        if (this.serviceClass == null || this.serviceClass.trim().isEmpty()) {
            this.setError(null);
            this.setRequirement(null);
        } else {
            RequirementImpl requirement = CapReqBuilder.createServiceRequirement((String)this.serviceClass).buildSyntheticRequirement();
            this.setError(null);
            this.setRequirement((Requirement)requirement);
        }
    }

    @Override
    public void setFocus() {
        this.focusControl.setFocus();
    }

    @Override
    public Image createImage(Device device) {
        return Resources.getImage("service");
    }

    public void saveState(IMemento memento) {
        memento.putString("serviceClass", this.serviceClass);
    }

    @Override
    public void restoreState(IMemento memento) {
        this.serviceClass = memento.getString("serviceClass");
    }
}

