/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ui.internal.preferences;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.ui.internal.preferences.ICategoryTreeNode;
import org.eclipse.emf.validation.ui.internal.preferences.IConstraintNode;
import org.eclipse.jface.viewers.CheckStateChangedEvent;

public class ConstraintNode
implements IConstraintNode {
    private static final Map<String, IConstraintNode> instanceMap = new HashMap<String, IConstraintNode>();
    private final IConstraintDescriptor constraint;
    private Boolean mandatory;
    private boolean checked = false;
    private final Set<ICategoryTreeNode> categories = new HashSet<ICategoryTreeNode>();

    private ConstraintNode(IConstraintDescriptor constraint) {
        this.constraint = constraint;
        this.checked = constraint.isEnabled();
    }

    static IConstraintNode getInstance(IConstraintDescriptor constraint) {
        String id = constraint.getId();
        IConstraintNode result = null;
        if (id != null && (result = instanceMap.get(id)) == null) {
            result = new ConstraintNode(constraint);
            instanceMap.put(id, result);
        }
        return result;
    }

    public static void flushCache() {
        instanceMap.clear();
    }

    @Override
    public String getId() {
        return this.constraint.getId();
    }

    @Override
    public String getName() {
        return this.constraint.getName();
    }

    @Override
    public String getDescription() {
        return this.constraint.getDescription();
    }

    @Override
    public Collection<Category> getCategories() {
        return this.constraint.getCategories();
    }

    @Override
    public String getEvaluationMode() {
        return this.constraint.getEvaluationMode().getLocalizedName();
    }

    @Override
    public String getSeverity() {
        return this.constraint.getSeverity().getLocalizedName();
    }

    @Override
    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public void setChecked(boolean checked) {
        if (checked != this.isChecked()) {
            this.checked = this.isMandatory() ? true : (this.isErrored() ? false : checked);
            this.updateCategories();
        }
    }

    @Override
    public boolean isMandatory() {
        if (this.mandatory == null) {
            boolean m = false;
            Iterator iter = this.constraint.getCategories().iterator();
            while (!m && iter.hasNext()) {
                if (!((Category)iter.next()).isMandatory()) continue;
                m = true;
            }
            this.mandatory = m ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.mandatory;
    }

    @Override
    public boolean isErrored() {
        return this.constraint.isError();
    }

    @Override
    public void addCategory(ICategoryTreeNode category) {
        this.categories.add(category);
    }

    @Override
    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getChecked() != this.isChecked()) {
            if (this.isMandatory() && !event.getChecked()) {
                event.getCheckable().setChecked((Object)this, true);
            } else if (this.isErrored() && event.getChecked()) {
                event.getCheckable().setChecked((Object)this, false);
            } else {
                this.checked = event.getChecked();
            }
            this.updateCategories();
        }
    }

    @Override
    public void applyToPreferences() {
        EMFModelValidationPreferences.setConstraintDisabled((String)this.constraint.getId(), (!this.isChecked() ? 1 : 0) != 0);
        this.constraint.setEnabled(this.isChecked());
    }

    @Override
    public void revertFromPreferences() {
        this.setChecked(!EMFModelValidationPreferences.isConstraintDisabled((String)this.constraint.getId()));
    }

    @Override
    public void restoreDefaults() {
        this.setChecked(!EMFModelValidationPreferences.isConstraintDisabledByDefault((String)this.constraint.getId()));
    }

    private void updateCategories() {
        for (ICategoryTreeNode next : this.categories) {
            next.updateCheckState(this);
        }
    }
}

