/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.sef;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.descriptors.EncapsulateFieldDescriptor;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class SelfEncapsulateFieldCompositeRefactoring
extends Refactoring {
    private final List<SelfEncapsulateFieldRefactoring> fRefactorings;
    private final HashMap<ICompilationUnit, ImportRewrite> fImportRewritesMap = new HashMap();
    private final HashMap<ICompilationUnit, ASTRewrite> fRewritersMap = new HashMap();
    private final HashMap<ICompilationUnit, CompilationUnit> fRootsMap = new HashMap();
    private final HashMap<ICompilationUnit, List<TextEditGroup>> fDescriptionsMap = new HashMap();
    private final List<TextChange> changes = new ArrayList<TextChange>();

    public List<SelfEncapsulateFieldRefactoring> getRefactorings() {
        return this.fRefactorings;
    }

    public SelfEncapsulateFieldCompositeRefactoring(List<IField> fields) throws JavaModelException {
        this.fRefactorings = this.getRefactoringFromFields(fields);
    }

    public List<SelfEncapsulateFieldRefactoring> getRefactoringFromFields(List<IField> fields) throws JavaModelException {
        ArrayList<SelfEncapsulateFieldRefactoring> refactorings = new ArrayList<SelfEncapsulateFieldRefactoring>();
        for (IField field : fields) {
            if (!RefactoringAvailabilityTesterCore.isSelfEncapsulateAvailable(field)) continue;
            refactorings.add(new SelfEncapsulateFieldRefactoring(field, this));
        }
        return refactorings;
    }

    public String getName() {
        return RefactoringCoreMessages.SelfEncapsulateField_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus fInitialConditions = new RefactoringStatus();
        for (SelfEncapsulateFieldRefactoring selfEncapsulateFieldRefactoring : this.fRefactorings) {
            fInitialConditions.merge(selfEncapsulateFieldRefactoring.checkInitialConditions(pm));
        }
        return fInitialConditions;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask(RefactoringCoreMessages.SelfEncapsulateField_create_changes, this.changes.size());
        DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange(this.getDescriptor(), this.getName());
        for (TextChange change : this.changes) {
            result.add((Change)change);
            pm.worked(1);
        }
        pm.done();
        return result;
    }

    public EncapsulateFieldDescriptor getDescriptor() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.getSelectedRefactorings().get(0).getField().getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        String fieldLabels = (this.getSelectedRefactorings().size() <= 3 ? this.getSelectedRefactorings() : this.getSelectedRefactorings().subList(0, 3)).stream().map(refactoring -> refactoring.getField().getElementName()).collect(Collectors.joining(", ")) + ", ...";
        String description = Messages.format(RefactoringCoreMessages.SelfEncapsulateField_descriptor_description_short, fieldLabels);
        int flags = 589830;
        try {
            boolean isAnonymousOrLocal;
            IType declaring = this.getSelectedRefactorings().get(0).getField().getDeclaringType();
            boolean bl = isAnonymousOrLocal = declaring.isAnonymous() || declaring.isLocal();
            if (isAnonymousOrLocal) {
                flags |= 0x40000;
            }
        }
        catch (JavaModelException exception) {
            JavaManipulationPlugin.log(exception);
        }
        String comment = this.getSelectedRefactorings().stream().map(refactoring -> refactoring.getCommentsForDescriptor().asString()).collect(Collectors.joining(", "));
        this.getSelectedRefactorings().forEach(refactoring -> refactoring.getArgumentsForDescriptor().forEach((key, value) -> {
            String string = arguments.merge((String)key, (String)value, (v1, v2) -> v1 + ", " + v2);
        }));
        EncapsulateFieldDescriptor descriptor = RefactoringSignatureDescriptorFactory.createEncapsulateFieldDescriptor(project, description, comment, arguments, flags);
        return descriptor;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.clearResources();
        RefactoringStatus fFinalConditions = new RefactoringStatus();
        for (SelfEncapsulateFieldRefactoring selfEncapsulateFieldRefactoring : this.getSelectedRefactorings()) {
            fFinalConditions.merge(selfEncapsulateFieldRefactoring.checkFinalConditions(pm));
        }
        this.makeDeclarationsPrivate();
        TextChangeManager fChangeManager = new TextChangeManager();
        for (Map.Entry<ICompilationUnit, ASTRewrite> entry : this.fRewritersMap.entrySet()) {
            TextChange change = fChangeManager.get(entry.getKey());
            MultiTextEdit root = new MultiTextEdit();
            change.setEdit((TextEdit)root);
            root.addChild(this.fImportRewritesMap.get(entry.getKey()).rewriteImports(null));
            root.addChild(entry.getValue().rewriteAST());
            for (TextEditGroup textEditGroup : this.fDescriptionsMap.get(entry.getKey())) {
                change.addTextEditGroup(textEditGroup);
            }
            this.changes.add(change);
        }
        return fFinalConditions;
    }

    private void makeDeclarationsPrivate() throws CoreException {
        for (SelfEncapsulateFieldRefactoring refactoring : this.getSelectedRefactorings()) {
            refactoring.makeDeclarationPrivateIfNeeded();
        }
    }

    public void clearResources() {
        this.fImportRewritesMap.clear();
        this.fRewritersMap.clear();
        this.fRootsMap.clear();
        this.fDescriptionsMap.clear();
        this.changes.clear();
    }

    public ASTRewrite getRewriterForUnit(ICompilationUnit cu, CompilationUnit root) {
        ASTRewrite rewriter;
        if (this.fRewritersMap.get(cu) == null) {
            rewriter = ASTRewrite.create((AST)root.getAST());
            this.fRewritersMap.put(cu, rewriter);
        } else {
            rewriter = this.fRewritersMap.get(cu);
        }
        return rewriter;
    }

    public ImportRewrite getImportRewriterForUnit(ICompilationUnit cu, CompilationUnit root) {
        ImportRewrite importRewrite;
        if (this.fImportRewritesMap.get(cu) == null) {
            importRewrite = StubUtility.createImportRewrite(root, true);
            this.fImportRewritesMap.put(cu, importRewrite);
        } else {
            importRewrite = this.fImportRewritesMap.get(cu);
        }
        return importRewrite;
    }

    public CompilationUnit getRootForUnit(ICompilationUnit cu) {
        CompilationUnit root;
        if (this.fRootsMap.get(cu) == null) {
            root = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse((ITypeRoot)cu, true);
            this.fRootsMap.put(cu, root);
        } else {
            root = this.fRootsMap.get(cu);
        }
        return root;
    }

    public List<TextEditGroup> getDescriptionsForUnit(ICompilationUnit cu) {
        ArrayList<TextEditGroup> descriptions;
        if (this.fDescriptionsMap.get(cu) == null) {
            descriptions = new ArrayList();
            this.fDescriptionsMap.put(cu, descriptions);
        } else {
            descriptions = this.fDescriptionsMap.get(cu);
        }
        return descriptions;
    }

    public List<SelfEncapsulateFieldRefactoring> getSelectedRefactorings() {
        return this.fRefactorings.stream().filter(SelfEncapsulateFieldRefactoring::isSelected).toList();
    }
}

