/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.rename;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.editors.NamedElementEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class RenameContainerChange
extends ResourceChange {
    private static final String RENAME_MESSAGE = Messages.RenameContainerChange_Msg;
    private static final String RENAME_PROGRESS_MESSAGE = Messages.RenameContainerChange_ProgressMsg;
    private final String fNewName;
    private final IPath fResourcePath;
    private final long fStampToRestore;
    private ChangeDescriptor fDescriptor;

    public RenameContainerChange(IPath resourcePath, String newName) {
        this(resourcePath, newName, -1L);
    }

    protected RenameContainerChange(IPath resourcePath, String newName, long stampToRestore) {
        if (resourcePath == null || newName == null || newName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.fResourcePath = resourcePath;
        this.fNewName = newName;
        this.fStampToRestore = stampToRestore;
        this.fDescriptor = null;
        this.setValidationMethod(2);
    }

    public ChangeDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    protected IResource getModifiedResource() {
        return this.getResource();
    }

    public String getName() {
        return MessageFormat.format(RENAME_MESSAGE, RenameContainerChange.getPathLabel(this.fResourcePath), RenameContainerChange.getResourceName(this.fNewName));
    }

    private static String getPathLabel(IPath path) {
        String label = path.makeRelative().toString();
        return TextProcessor.process((String)label, (String)"/\\:.");
    }

    private static String getResourceName(String resourceName) {
        return TextProcessor.process((String)resourceName, (String)":.");
    }

    public String getNewName() {
        return this.fNewName;
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RENAME_PROGRESS_MESSAGE, 1);
            IResource resource = this.getResource();
            long currentStamp = resource.getModificationStamp();
            IPath newPath = RenameContainerChange.renamedResourcePath(this.fResourcePath, this.fNewName);
            resource.move(newPath, 32, pm);
            if (this.fStampToRestore != -1L) {
                IResource newResource = ResourcesPlugin.getWorkspace().getRoot().findMember(newPath);
                newResource.revertModificationStamp(this.fStampToRestore);
            }
            String oldName = this.fResourcePath.lastSegment();
            this.updateEditorInputs(newPath);
            IResource renamedResource = this.getResource(newPath);
            if (renamedResource instanceof IProject) {
                this.updateProjectReferences(pm, (IProject)renamedResource);
            }
            RenameContainerChange renameContainerChange = new RenameContainerChange(newPath, oldName, currentStamp);
            return renameContainerChange;
        }
        finally {
            pm.done();
        }
    }

    private IResource getResource(IPath resourcePath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath);
    }

    private static IPath renamedResourcePath(IPath path, String newName) {
        return path.removeLastSegments(1).append(newName);
    }

    private void updateEditorInputs(final IPath newPath) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorReference[] references;
                IWorkbenchWindow window = Q7UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return;
                }
                IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    IEditorPart part = reference.getEditor(false);
                    if (part instanceof NamedElementEditor) {
                        NamedElementEditor editor = (NamedElementEditor)part;
                        RenameContainerChange.this.updateEditorInput(editor, newPath);
                    }
                    ++n2;
                }
            }
        });
    }

    private void updateEditorInput(NamedElementEditor editor, IPath newPath) {
    }

    private void updateProjectReferences(IProgressMonitor pm, IProject renamedProject) throws CoreException {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects(8);
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject currentProject = iProjectArray[n2];
            IProjectDescription description = currentProject.getDescription();
            IProject[] referenceProject = description.getReferencedProjects();
            boolean changed = false;
            int i = 0;
            while (i < referenceProject.length) {
                if (referenceProject[i].getFullPath().equals((Object)this.fResourcePath)) {
                    referenceProject[i] = renamedProject;
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                description.setReferencedProjects(referenceProject);
                currentProject.setDescription(description, pm);
            }
            ++n2;
        }
    }
}

