/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.expression.QueryResult;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.spi.AbstractArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.Messages;

public class VirtualArtifactRepository
extends AbstractArtifactRepository {
    private static final String NAME = "Non-IU Artifact Repository @ ";
    private static final String DESCRIPTION = "In-Memory repository created for a single Non-IU repository, used\nduring the planner resolution of a real IU repository.\n";
    private static final String MEMORY_PREFIX = "memory://";
    private final Map<IArtifactDescriptor, Object> artifacts = new HashMap<IArtifactDescriptor, Object>();

    public VirtualArtifactRepository(IProvisioningAgent agent, ITargetLocation targetLocation) {
        super(agent, NAME + VirtualArtifactRepository.getLocationSafe(targetLocation), targetLocation.getType(), null, URI.create(MEMORY_PREFIX + String.valueOf(UUID.randomUUID())), "In-Memory repository created for a single Non-IU repository, used\nduring the planner resolution of a real IU repository.\n\n" + targetLocation.serialize(), null, null);
        Assert.isTrue((boolean)targetLocation.isResolved());
        Object[] objectArray = targetLocation.getBundles();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TargetBundle targetBundle = objectArray[n2];
            if (!targetBundle.getStatus().isOK()) {
                PDECore.log(Status.warning((String)NLS.bind((String)Messages.VirtualArtifactRepository_0, (Object)targetBundle)));
            } else {
                BundleInfo bundleInfo = targetBundle.getBundleInfo();
                IArtifactKey artifactKey = BundlesAction.createBundleArtifactKey((String)bundleInfo.getSymbolicName(), (String)bundleInfo.getVersion());
                ArtifactDescriptor artifactDesriptor = new ArtifactDescriptor(artifactKey);
                this.artifacts.put((IArtifactDescriptor)artifactDesriptor, bundleInfo);
            }
            ++n2;
        }
        objectArray = targetLocation.getFeatures();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object targetFeature = objectArray[n2];
            IArtifactKey artifactKey = FeaturesAction.createFeatureArtifactKey((String)((TargetFeature)targetFeature).getId(), (String)((TargetFeature)targetFeature).getVersion());
            ArtifactDescriptor artifactDesriptor = new ArtifactDescriptor(artifactKey);
            this.artifacts.put((IArtifactDescriptor)artifactDesriptor, ((TargetFeature)targetFeature).getFeatureModel());
            ++n2;
        }
    }

    private static String getLocationSafe(ITargetLocation targetLocation) {
        try {
            return targetLocation.getLocation(false);
        }
        catch (CoreException e) {
            return "<unknown>";
        }
    }

    public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        Object artifactModel = this.artifacts.get(descriptor);
        if (artifactModel == null) {
            return Status.error((String)NLS.bind((String)Messages.VirtualArtifactRepository_1, (Object)descriptor));
        }
        try {
            this.transferArtifact(artifactModel, destination);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return Status.error((String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void transferArtifact(Object artifactModel, OutputStream destination) throws Exception {
        if (artifactModel instanceof BundleInfo) {
            BundleInfo bundleInfo = (BundleInfo)artifactModel;
            URI location = bundleInfo.getLocation();
            if (location == null) {
                throw new FileNotFoundException(bundleInfo.getSymbolicName());
            }
            File bundleLocation = new File(location);
            if (bundleLocation.isFile()) {
                Files.copy(bundleLocation.toPath(), destination);
            } else {
                ZipOutputStream zip = this.getZipStream(destination, bundleLocation);
                FileUtils.zip((ZipOutputStream)zip, (File)bundleLocation, Set.of(), (FileUtils.IPathComputer)FileUtils.createRootPathComputer((File)bundleLocation));
                zip.finish();
                zip.flush();
            }
        } else if (artifactModel instanceof IFeatureModel) {
            File featureJar;
            IFeatureModel featureModel = (IFeatureModel)artifactModel;
            String installLocation = featureModel.getInstallLocation();
            if (installLocation != null && (featureJar = new File(installLocation)).isFile()) {
                Files.copy(featureJar.toPath(), destination);
                return;
            }
            IFeature feature = featureModel.getFeature();
            JarOutputStream jos = new JarOutputStream(destination);
            jos.putNextEntry(new JarEntry("feature.xml"));
            PrintWriter printWriter = new PrintWriter(jos);
            feature.write("", printWriter);
            printWriter.flush();
            jos.finish();
        } else {
            throw new IllegalArgumentException(artifactModel.toString());
        }
    }

    private ZipOutputStream getZipStream(OutputStream destination, File bundleLocation) throws IOException {
        File manifestFile = new File(bundleLocation, "META-INF/MANIFEST.MF");
        if (manifestFile.isFile()) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileInputStream fileInputStream = new FileInputStream(manifestFile);){
                return new JarOutputStream(destination, new Manifest(fileInputStream));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return new ZipOutputStream(destination);
    }

    public IQueryable<IArtifactDescriptor> descriptorQueryable() {
        return (query, monitor) -> query.perform(this.artifacts.keySet().iterator());
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        return new QueryResult(this.artifacts.keySet().stream().map(IArtifactDescriptor::getArtifactKey).iterator());
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        return this.artifacts.containsKey(descriptor);
    }

    public boolean contains(IArtifactKey key) {
        return this.artifacts.keySet().stream().anyMatch(descriptor -> key.equals(descriptor.getArtifactKey()));
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.getRawArtifact(descriptor, destination, monitor);
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        return (IArtifactDescriptor[])this.artifacts.keySet().stream().filter(descriptor -> key.equals(descriptor.getArtifactKey())).toArray(IArtifactDescriptor[]::new);
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        MultiStatus multiStatus = new MultiStatus(((Object)((Object)this)).getClass(), 1, "Perform Artifact Requests");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)requests.length);
        IArtifactRequest[] iArtifactRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactRequest request = iArtifactRequestArray[n2];
            request.perform((IArtifactRepository)this, (IProgressMonitor)subMonitor.split(1));
            multiStatus.add(request.getResult());
            ++n2;
        }
        return multiStatus.isOK() ? Status.OK_STATUS : multiStatus;
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
        throw new ProvisionException("Artifact repository must not be modified!");
    }
}

