/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld;

public enum JsonLdVersion {
    V1_0("json-ld-1.0"),
    V1_1("json-ld-1.1");

    private final String text;

    private JsonLdVersion(String text) {
        this.text = text;
    }

    public static JsonLdVersion of(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (JsonLdVersion.V1_0.text.equalsIgnoreCase(text)) {
            return V1_0;
        }
        if (JsonLdVersion.V1_1.text.equalsIgnoreCase(text)) {
            return V1_1;
        }
        return null;
    }

    public String toString() {
        return this.text;
    }
}

