/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.config;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.sail.base.config.BaseSailConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.memory.config.MemoryStoreSchema;

public class MemoryStoreConfig
extends BaseSailConfig {
    private boolean persist = false;
    private long syncDelay = 0L;

    public MemoryStoreConfig() {
        super("openrdf:MemoryStore");
    }

    public MemoryStoreConfig(boolean persist) {
        this();
        this.setPersist(persist);
    }

    public MemoryStoreConfig(boolean persist, long syncDelay) {
        this(persist);
        this.setSyncDelay(syncDelay);
    }

    public boolean getPersist() {
        return this.persist;
    }

    public void setPersist(boolean persist) {
        this.persist = persist;
    }

    public long getSyncDelay() {
        return this.syncDelay;
    }

    public void setSyncDelay(long syncDelay) {
        this.syncDelay = syncDelay;
    }

    public Resource export(Model m) {
        if (Configurations.useLegacyConfig()) {
            return this.exportLegacy(m);
        }
        Resource implNode = super.export(m);
        m.setNamespace(CONFIG.NS);
        if (this.persist) {
            m.add(implNode, CONFIG.Mem.persist, (Value)BooleanLiteral.TRUE, new Resource[0]);
        }
        if (this.syncDelay != 0L) {
            m.add(implNode, CONFIG.Mem.syncDelay, (Value)Values.literal((long)this.syncDelay), new Resource[0]);
        }
        return implNode;
    }

    private Resource exportLegacy(Model m) {
        Resource implNode = super.export(m);
        m.setNamespace("ms", "http://www.openrdf.org/config/sail/memory#");
        if (this.persist) {
            m.add(implNode, MemoryStoreSchema.PERSIST, (Value)BooleanLiteral.TRUE, new Resource[0]);
        }
        if (this.syncDelay != 0L) {
            m.add(implNode, MemoryStoreSchema.SYNC_DELAY, (Value)Values.literal((long)this.syncDelay), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Model graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        try {
            Configurations.getLiteralValue((Model)graph, (Resource)implNode, (IRI)CONFIG.Mem.persist, (IRI)MemoryStoreSchema.PERSIST).ifPresent(persistValue -> {
                try {
                    this.setPersist(persistValue.booleanValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Boolean value required for " + CONFIG.Mem.persist + " property, found " + persistValue);
                }
            });
            Configurations.getLiteralValue((Model)graph, (Resource)implNode, (IRI)CONFIG.Mem.syncDelay, (IRI)MemoryStoreSchema.SYNC_DELAY).ifPresent(syncDelayValue -> {
                try {
                    this.setSyncDelay(syncDelayValue.longValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Long integer value required for " + CONFIG.Mem.syncDelay + " property, found " + syncDelayValue);
                }
            });
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), (Throwable)e);
        }
    }
}

