/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.collection.factory.mapdb;

import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.eclipse.rdf4j.collection.factory.api.BindingSetKey;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.collection.factory.impl.DefaultCollectionFactory;
import org.eclipse.rdf4j.collection.factory.mapdb.BindingSetKeySerializer;
import org.eclipse.rdf4j.collection.factory.mapdb.BindingSetSerializer;
import org.eclipse.rdf4j.collection.factory.mapdb.MapDb3BindingSetKey;
import org.eclipse.rdf4j.collection.factory.mapdb.ValueSerializer;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.SerializerJava;
import org.mapdb.serializer.SerializerLong;

public class MapDb3CollectionFactory
implements CollectionFactory {
    private static final int DEFAULT_SWITCH_TO_DISK_BASED_SET_AT_SIZE = 16;
    protected volatile DB db;
    protected volatile long colectionId = 0L;
    protected final long iterationCacheSyncThreshold;
    private final CollectionFactory delegate;
    private static final boolean ON_32_BIT_VM = "32".equals(System.getProperty("sun.arch.data.model"));

    public MapDb3CollectionFactory(long iterationCacheSyncThreshold) {
        this(iterationCacheSyncThreshold, (CollectionFactory)new DefaultCollectionFactory());
    }

    public MapDb3CollectionFactory(long iterationCacheSyncThreshold, CollectionFactory delegate) {
        this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        if (this.db == null) {
            MapDb3CollectionFactory mapDb3CollectionFactory = this;
            synchronized (mapDb3CollectionFactory) {
                if (this.db == null) {
                    try {
                        DBMaker.Maker dbmaker = DBMaker.tempFileDB().closeOnJvmShutdown();
                        if (!ON_32_BIT_VM) {
                            dbmaker.fileMmapEnable();
                        }
                        this.db = dbmaker.make();
                    }
                    catch (DBException e) {
                        throw new RDF4jMapDB3Exception("could not initialize temp db", (Exception)((Object)e));
                    }
                }
            }
        }
    }

    public <T> List<T> createList() {
        return this.delegate.createList();
    }

    public List<Value> createValueList() {
        return this.delegate.createValueList();
    }

    public Set<BindingSet> createSetOfBindingSets(Supplier<MutableBindingSet> create, Function<String, Predicate<BindingSet>> getHas, Function<String, Function<BindingSet, Value>> getget, Function<String, BiConsumer<Value, MutableBindingSet>> getSet) {
        if (this.iterationCacheSyncThreshold > 0L) {
            return new SyncThresholdAwareSet<BindingSet>(this.delegate.createSet(), this.iterationCacheSyncThreshold, previousSet -> {
                this.init();
                Serializer<BindingSet> serializer = this.createBindingSetSerializer(create, getHas, getget, getSet);
                MemoryTillSizeXSet<BindingSet> set = new MemoryTillSizeXSet<BindingSet>(this.colectionId++, this.delegate.createSetOfBindingSets(), serializer, 16L);
                CommitingSet<BindingSet> bindingSets = new CommitingSet<BindingSet>(set, this.iterationCacheSyncThreshold, this.db);
                bindingSets.addAll((Collection<BindingSet>)previousSet);
                return bindingSets;
            });
        }
        return this.delegate.createSetOfBindingSets();
    }

    public <T> Set<T> createSet() {
        if (this.iterationCacheSyncThreshold > 0L) {
            return new SyncThresholdAwareSet(this.delegate.createSet(), this.iterationCacheSyncThreshold, previousSet -> {
                this.init();
                Serializer serializer = this.createAnySerializer();
                MemoryTillSizeXSet set = new MemoryTillSizeXSet(this.colectionId++, this.delegate.createSet(), serializer, 16L);
                CommitingSet ts = new CommitingSet(set, this.iterationCacheSyncThreshold, this.db);
                ts.addAll((Collection)previousSet);
                return ts;
            });
        }
        return this.delegate.createSet();
    }

    public Set<Value> createValueSet() {
        if (this.iterationCacheSyncThreshold > 0L) {
            return new SyncThresholdAwareSet<Value>(this.delegate.createValueSet(), this.iterationCacheSyncThreshold, previousSet -> {
                this.init();
                Serializer<Value> serializer = this.createValueSerializer();
                MemoryTillSizeXSet<Value> set = new MemoryTillSizeXSet<Value>(this.colectionId++, this.delegate.createValueSet(), serializer, 16L);
                CommitingSet<Value> values = new CommitingSet<Value>(set, this.iterationCacheSyncThreshold, this.db);
                values.addAll((Collection<Value>)previousSet);
                return values;
            });
        }
        return this.delegate.createValueSet();
    }

    public <K, V> Map<K, V> createMap() {
        if (this.iterationCacheSyncThreshold > 0L) {
            return new SyncThresholdAwareMap(this.delegate.createMap(), this.iterationCacheSyncThreshold, previousMap -> {
                Serializer keySerializer = this.createAnySerializer();
                Serializer valueSerializer = this.createAnySerializer();
                DB.HashMapMaker hashMap = this.db.hashMap(Long.toHexString(this.colectionId++), keySerializer, valueSerializer);
                HTreeMap create = hashMap.create();
                CommitingMap map = new CommitingMap(create, this.iterationCacheSyncThreshold, this.db);
                map.putAll(previousMap);
                return map;
            });
        }
        return this.delegate.createMap();
    }

    public <V> Map<Value, V> createValueKeyedMap() {
        if (this.iterationCacheSyncThreshold > 0L) {
            return new SyncThresholdAwareMap(this.delegate.createValueKeyedMap(), this.iterationCacheSyncThreshold, previousMap -> {
                this.init();
                Serializer<Value> keySerializer = this.createValueSerializer();
                Serializer valueSerializer = this.createAnySerializer();
                CommitingMap map = new CommitingMap(this.db.hashMap(Long.toHexString(this.colectionId++), keySerializer, valueSerializer).create(), this.iterationCacheSyncThreshold, this.db);
                map.putAll(previousMap);
                return map;
            });
        }
        return this.delegate.createValueKeyedMap();
    }

    public <T> Queue<T> createQueue() {
        if (this.iterationCacheSyncThreshold > 0L) {
            return new SyncThresholdAwareQueue(this.delegate.createQueue(), this.iterationCacheSyncThreshold, prev -> {
                this.init();
                Serializer s = this.createAnySerializer();
                HTreeMap m = this.db.hashMap(Long.toHexString(this.colectionId++), (Serializer)new SerializerLong(), s).create();
                MemoryTillSizeXQueue ts = new MemoryTillSizeXQueue(this.delegate.createQueue(), 128L, () -> this.lambda$createQueue$5((Map)m));
                ts.addAll(prev);
                return ts;
            });
        }
        return this.delegate.createQueue();
    }

    public Queue<Value> createValueQueue() {
        if (this.iterationCacheSyncThreshold > 0L) {
            return new SyncThresholdAwareQueue<Value>(this.delegate.createValueQueue(), this.iterationCacheSyncThreshold, prev -> {
                this.init();
                Serializer<Value> s = this.createValueSerializer();
                HTreeMap m = this.db.hashMap(Long.toHexString(this.colectionId++), (Serializer)new SerializerLong(), s).create();
                MemoryTillSizeXQueue values = new MemoryTillSizeXQueue(this.delegate.createQueue(), 128L, () -> this.lambda$createValueQueue$7((Map)m));
                values.addAll(prev);
                return values;
            });
        }
        return this.delegate.createValueQueue();
    }

    @Experimental
    public Queue<BindingSet> createBindingSetQueue(Supplier<MutableBindingSet> create, Function<String, Predicate<BindingSet>> getHas, Function<String, Function<BindingSet, Value>> getget, Function<String, BiConsumer<Value, MutableBindingSet>> getSet) {
        if (this.iterationCacheSyncThreshold > 0L) {
            return new SyncThresholdAwareQueue<BindingSet>(this.delegate.createBindingSetQueue(), this.iterationCacheSyncThreshold, prev -> {
                this.init();
                Serializer<BindingSet> s = this.createBindingSetSerializer(create, getHas, getget, getSet);
                HTreeMap m = this.db.hashMap(Long.toHexString(this.colectionId++), (Serializer)new SerializerLong(), s).create();
                MemoryTillSizeXQueue bindingSets = new MemoryTillSizeXQueue(this.delegate.createBindingSetQueue(create, getHas, getget, getSet), 128L, () -> this.lambda$createBindingSetQueue$9((Map)m));
                bindingSets.addAll(prev);
                return bindingSets;
            });
        }
        return this.delegate.createBindingSetQueue();
    }

    public void close() throws RDF4JException {
        if (this.db != null) {
            this.db.close();
        }
    }

    public <E> Map<BindingSetKey, E> createGroupByMap() {
        if (this.iterationCacheSyncThreshold > 0L) {
            return new SyncThresholdAwareMap(this.delegate.createGroupByMap(), this.iterationCacheSyncThreshold, previousMap -> {
                this.init();
                Serializer<BindingSetKey> keySerializer = this.createBindingSetKeySerializer();
                Serializer valueSerializer = this.createAnySerializer();
                CommitingMap map = new CommitingMap(this.db.hashMap(Long.toHexString(this.colectionId++), keySerializer, valueSerializer).create(), this.iterationCacheSyncThreshold, this.db);
                map.putAll(previousMap);
                return map;
            });
        }
        return this.delegate.createGroupByMap();
    }

    public final BindingSetKey createBindingSetKey(BindingSet bindingSet, List<Function<BindingSet, Value>> getValues, ToIntFunction<BindingSet> hashOfBindingSetCalculator) {
        ArrayList<Value> values = new ArrayList<Value>(getValues.size());
        for (int i = 0; i < getValues.size(); ++i) {
            values.add(getValues.get(i).apply(bindingSet));
        }
        return new MapDb3BindingSetKey(values, hashOfBindingSetCalculator.applyAsInt(bindingSet));
    }

    protected Serializer<BindingSet> createBindingSetSerializer(Supplier<MutableBindingSet> create, Function<String, Predicate<BindingSet>> getHas, Function<String, Function<BindingSet, Value>> getGet, Function<String, BiConsumer<Value, MutableBindingSet>> getSet) {
        return new BindingSetSerializer(this.createValueSerializer(), create, getHas, getGet, getSet);
    }

    protected <T> Serializer<T> createAnySerializer() {
        return new SerializerJava();
    }

    protected Serializer<Value> createValueSerializer() {
        return new ValueSerializer();
    }

    protected final Serializer<BindingSetKey> createBindingSetKeySerializer() {
        return new BindingSetKeySerializer(this.createValueSerializer());
    }

    private /* synthetic */ Queue lambda$createBindingSetQueue$9(Map m) {
        return new MapDb3BackedQueue(m);
    }

    private /* synthetic */ Queue lambda$createValueQueue$7(Map m) {
        return new MapDb3BackedQueue(m);
    }

    private /* synthetic */ Queue lambda$createQueue$5(Map m) {
        return new MapDb3BackedQueue(m);
    }

    private static class SyncThresholdAwareMap<K, E>
    implements Map<K, E> {
        private int estimatedSize = 0;
        private final long threshold;
        private final Function<Map<K, E>, Map<K, E>> createSyncingMap;
        private Map<K, E> wrapped;
        private boolean switched = false;

        public SyncThresholdAwareMap(Map<K, E> wrapped, long threshold, Function<Map<K, E>, Map<K, E>> createSyncingMap) {
            this.wrapped = wrapped;
            this.threshold = threshold;
            this.createSyncingMap = createSyncingMap;
        }

        private void checkAndSwitch() {
            if (!this.switched && (long)this.estimatedSize > this.threshold && (long)this.wrapped.size() > this.threshold) {
                this.wrapped = this.createSyncingMap.apply(this.wrapped);
                this.switched = true;
            }
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.wrapped.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.wrapped.containsValue(value);
        }

        @Override
        public E get(Object key) {
            return this.wrapped.get(key);
        }

        @Override
        public E put(K key, E value) {
            E put = this.wrapped.put(key, value);
            if (put == null) {
                ++this.estimatedSize;
                this.checkAndSwitch();
            }
            return put;
        }

        @Override
        public E remove(Object key) {
            E remove = this.wrapped.remove(key);
            if (remove != null) {
                --this.estimatedSize;
            }
            return remove;
        }

        @Override
        public void putAll(Map<? extends K, ? extends E> m) {
            this.estimatedSize += m.size();
            this.checkAndSwitch();
            this.wrapped.putAll(m);
        }

        @Override
        public void clear() {
            this.estimatedSize = 0;
            this.wrapped.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.wrapped.keySet();
        }

        @Override
        public Collection<E> values() {
            return this.wrapped.values();
        }

        @Override
        public Set<Map.Entry<K, E>> entrySet() {
            return this.wrapped.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return this.wrapped.equals(o);
        }

        @Override
        public int hashCode() {
            return this.wrapped.hashCode();
        }

        @Override
        public E getOrDefault(Object key, E defaultValue) {
            return this.wrapped.getOrDefault(key, defaultValue);
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super E> action) {
            this.wrapped.forEach(action);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super E, ? extends E> function) {
            this.wrapped.replaceAll(function);
        }

        @Override
        public E putIfAbsent(K key, E value) {
            return this.wrapped.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            boolean remove = this.wrapped.remove(key, value);
            if (remove) {
                --this.estimatedSize;
            }
            return remove;
        }

        @Override
        public boolean replace(K key, E oldValue, E newValue) {
            return this.wrapped.replace(key, oldValue, newValue);
        }

        @Override
        public E replace(K key, E value) {
            return this.wrapped.replace(key, value);
        }

        @Override
        public E computeIfAbsent(K key, Function<? super K, ? extends E> mappingFunction) {
            ++this.estimatedSize;
            this.checkAndSwitch();
            return this.wrapped.computeIfAbsent((K)key, (Function<? super K, E>)mappingFunction);
        }

        @Override
        public E computeIfPresent(K key, BiFunction<? super K, ? super E, ? extends E> remappingFunction) {
            return this.wrapped.computeIfPresent((K)key, (BiFunction<? super K, E, E>)remappingFunction);
        }

        @Override
        public E compute(K key, BiFunction<? super K, ? super E, ? extends E> remappingFunction) {
            ++this.estimatedSize;
            this.checkAndSwitch();
            return this.wrapped.compute((K)key, (BiFunction<? super K, E, E>)remappingFunction);
        }

        @Override
        public E merge(K key, E value, BiFunction<? super E, ? super E, ? extends E> remappingFunction) {
            return this.wrapped.merge(key, value, remappingFunction);
        }
    }

    private static class SyncThresholdAwareSet<E>
    implements Set<E> {
        private int estimatedSize = 0;
        private final long threshold;
        private final Function<Set<E>, Set<E>> createSyncingSet;
        private Set<E> wrapped;
        private boolean switched = false;

        public SyncThresholdAwareSet(Set<E> wrapped, long threshold, Function<Set<E>, Set<E>> createSyncingSet) {
            this.wrapped = wrapped;
            this.threshold = threshold;
            this.createSyncingSet = createSyncingSet;
        }

        private void checkAndSwitch() {
            if (!this.switched && (long)this.estimatedSize > this.threshold && (long)this.wrapped.size() > this.threshold) {
                this.wrapped = this.createSyncingSet.apply(this.wrapped);
                this.switched = true;
            }
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.wrapped.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.wrapped.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.wrapped.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.wrapped.toArray(a);
        }

        @Override
        public boolean add(E e) {
            boolean add = this.wrapped.add(e);
            if (add) {
                ++this.estimatedSize;
                this.checkAndSwitch();
            }
            return add;
        }

        @Override
        public boolean remove(Object o) {
            boolean remove = this.wrapped.remove(o);
            if (remove) {
                --this.estimatedSize;
            }
            return remove;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.wrapped.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            this.estimatedSize += c.size();
            this.checkAndSwitch();
            return this.wrapped.addAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.wrapped.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.wrapped.removeAll(c);
        }

        @Override
        public void clear() {
            this.estimatedSize = 0;
            this.wrapped.clear();
        }

        @Override
        public boolean equals(Object o) {
            return this.wrapped.equals(o);
        }

        @Override
        public int hashCode() {
            return this.wrapped.hashCode();
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.wrapped.spliterator();
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> generator) {
            return this.wrapped.toArray(generator);
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            return this.wrapped.removeIf(filter);
        }

        @Override
        public Stream<E> stream() {
            return this.wrapped.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.wrapped.parallelStream();
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.wrapped.forEach(action);
        }
    }

    private static class SyncThresholdAwareQueue<E>
    implements Queue<E> {
        private int estimatedSize = 0;
        private final long threshold;
        private final Function<Queue<E>, Queue<E>> createSyncingQueue;
        private Queue<E> wrapped;
        private boolean switched = false;

        public SyncThresholdAwareQueue(Queue<E> wrapped, long threshold, Function<Queue<E>, Queue<E>> createSyncingQueue) {
            this.wrapped = wrapped;
            this.threshold = threshold;
            this.createSyncingQueue = createSyncingQueue;
        }

        private void checkAndSwitch() {
            if (!this.switched && (long)this.estimatedSize > this.threshold && (long)this.wrapped.size() > this.threshold) {
                this.wrapped = this.createSyncingQueue.apply(this.wrapped);
                this.switched = true;
            }
        }

        @Override
        public boolean add(E e) {
            boolean add = this.wrapped.add(e);
            if (add) {
                ++this.estimatedSize;
                this.checkAndSwitch();
            }
            return add;
        }

        @Override
        public boolean offer(E e) {
            boolean offer = this.wrapped.offer(e);
            if (offer) {
                ++this.estimatedSize;
                this.checkAndSwitch();
            }
            return offer;
        }

        @Override
        public E remove() {
            --this.estimatedSize;
            return this.wrapped.remove();
        }

        @Override
        public E poll() {
            --this.estimatedSize;
            return this.wrapped.poll();
        }

        @Override
        public E element() {
            return this.wrapped.element();
        }

        @Override
        public E peek() {
            return this.wrapped.peek();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.wrapped.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.wrapped.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.wrapped.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.wrapped.toArray(a);
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> generator) {
            return this.wrapped.toArray(generator);
        }

        @Override
        public boolean remove(Object o) {
            boolean remove = this.wrapped.remove(o);
            if (remove) {
                --this.estimatedSize;
            }
            return remove;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.wrapped.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            this.estimatedSize += c.size();
            this.checkAndSwitch();
            return this.wrapped.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.wrapped.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            return this.wrapped.removeIf(filter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.wrapped.retainAll(c);
        }

        @Override
        public void clear() {
            this.estimatedSize = 0;
            this.wrapped.clear();
        }

        @Override
        public boolean equals(Object o) {
            return this.wrapped.equals(o);
        }

        @Override
        public int hashCode() {
            return this.wrapped.hashCode();
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.wrapped.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.wrapped.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.wrapped.parallelStream();
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.wrapped.forEach(action);
        }
    }

    protected class MemoryTillSizeXQueue<V>
    extends AbstractQueue<V> {
        private Queue<V> wrapped;
        private final long switchToDiskAtSize;
        private final Supplier<Queue<V>> supplier;

        public MemoryTillSizeXQueue(Queue<V> wrapped, long switchToSize, Supplier<Queue<V>> supplier) {
            this.wrapped = wrapped;
            this.switchToDiskAtSize = switchToSize;
            this.supplier = supplier;
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public boolean offer(V e) {
            if (!(this.wrapped instanceof MapDb3BackedQueue) && (long)this.wrapped.size() > this.switchToDiskAtSize) {
                Queue<V> disk = this.supplier.get();
                disk.addAll(this.wrapped);
                this.wrapped = disk;
            }
            return this.wrapped.offer(e);
        }

        @Override
        public V peek() {
            return this.wrapped.peek();
        }

        @Override
        public V poll() {
            return this.wrapped.poll();
        }

        @Override
        public Iterator<V> iterator() {
            return this.wrapped.iterator();
        }
    }

    protected class MemoryTillSizeXSet<V>
    extends AbstractSet<V> {
        private Set<V> wrapped;
        private final long setName;
        private final Serializer<V> valueSerializer;
        private final long switchToDiskAtSize;

        public MemoryTillSizeXSet(long setName, Set<V> wrapped, Serializer<V> valueSerializer, long switchToSize) {
            this.setName = setName;
            this.wrapped = wrapped;
            this.valueSerializer = valueSerializer;
            this.switchToDiskAtSize = switchToSize;
        }

        @Override
        public boolean add(V e) {
            if (this.wrapped instanceof HashSet && (long)this.wrapped.size() > this.switchToDiskAtSize) {
                Set disk = (Set)MapDb3CollectionFactory.this.db.hashSet(Long.toHexString(this.setName), this.valueSerializer).create();
                disk.addAll(this.wrapped);
                this.wrapped = disk;
            }
            return this.wrapped.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends V> arg0) {
            if (this.wrapped instanceof HashSet && (long)arg0.size() > this.switchToDiskAtSize) {
                Set disk = (Set)MapDb3CollectionFactory.this.db.hashSet(Long.toHexString(this.setName), this.valueSerializer).create();
                disk.addAll(this.wrapped);
                this.wrapped = disk;
            }
            return this.wrapped.addAll(arg0);
        }

        @Override
        public void clear() {
            this.wrapped.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.wrapped.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> arg0) {
            return this.wrapped.containsAll(arg0);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            return this.wrapped.remove(o);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.wrapped.retainAll(c);
        }

        @Override
        public Object[] toArray() {
            return this.wrapped.toArray();
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            return this.wrapped.toArray(arg0);
        }

        @Override
        public Iterator<V> iterator() {
            return this.wrapped.iterator();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }
    }

    protected static final class CommitingMap<K, V>
    extends AbstractMap<K, V> {
        private final Map<K, V> wrapped;
        private final long iterationCacheSyncThreshold;
        private final DB db;
        private long iterationCount;

        public CommitingMap(Map<K, V> wrapped, long iterationCacheSyncThreshold, DB db) {
            this.wrapped = wrapped;
            this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
            this.db = db;
        }

        @Override
        public V put(K k, V v) {
            V res = this.wrapped.put(k, v);
            if (this.iterationCount++ % this.iterationCacheSyncThreshold == 0L) {
                this.db.commit();
            }
            return res;
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.wrapped.entrySet();
        }
    }

    protected static final class CommitingSet<T>
    extends AbstractSet<T> {
        private final Set<T> wrapped;
        private final long iterationCacheSyncThreshold;
        private final DB db;
        private long iterationCount;

        public CommitingSet(Set<T> wrapped, long iterationCacheSyncThreshold, DB db) {
            this.wrapped = wrapped;
            this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
            this.db = db;
        }

        @Override
        public boolean add(T e) {
            boolean res = this.wrapped.add(e);
            if (this.iterationCount++ % this.iterationCacheSyncThreshold == 0L) {
                this.db.commit();
            }
            return res;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean res = this.wrapped.addAll(c);
            if (this.iterationCount + (long)c.size() % this.iterationCacheSyncThreshold == 0L) {
                this.db.commit();
            }
            return res;
        }

        @Override
        public Iterator<T> iterator() {
            return this.wrapped.iterator();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }
    }

    protected static final class RDF4jMapDB3Exception
    extends RDF4JException {
        private static final long serialVersionUID = 1L;

        public RDF4jMapDB3Exception(String string, Exception e) {
            super(string, (Throwable)e);
        }
    }

    private final class MapDb3BackedQueue<T>
    extends AbstractQueue<T> {
        private final Map<Long, T> m;
        private long tail;
        private long head;

        private MapDb3BackedQueue(Map<Long, T> m) {
            this.m = m;
        }

        @Override
        public boolean offer(T arg0) {
            this.m.put(this.tail++, arg0);
            if (this.tail % MapDb3CollectionFactory.this.iterationCacheSyncThreshold == 0L) {
                MapDb3CollectionFactory.this.db.commit();
            }
            return true;
        }

        @Override
        public T peek() {
            return this.m.get(this.head);
        }

        @Override
        public T poll() {
            T r = this.m.remove(this.head++);
            if (this.head % MapDb3CollectionFactory.this.iterationCacheSyncThreshold == 0L) {
                MapDb3CollectionFactory.this.db.commit();
            }
            return r;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                long at;
                {
                    this.at = MapDb3BackedQueue.this.head;
                }

                @Override
                public boolean hasNext() {
                    return this.at < MapDb3BackedQueue.this.tail;
                }

                @Override
                public T next() {
                    if (this.at >= MapDb3BackedQueue.this.tail) {
                        throw new NoSuchElementException();
                    }
                    return MapDb3BackedQueue.this.m.get(this.at++);
                }
            };
        }

        @Override
        public int size() {
            return (int)(this.tail - this.head);
        }
    }
}

