/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps;

import java.util.Iterator;
import java.util.function.Function;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;

public class BindingSetAssignmentQueryEvaluationStep
implements QueryEvaluationStep {
    private final BindingSetAssignment node;
    private final Function<BindingSet, MutableBindingSet> bsMaker;

    public BindingSetAssignmentQueryEvaluationStep(BindingSetAssignment node, QueryEvaluationContext context) {
        this.node = node;
        this.bsMaker = context::createBindingSet;
    }

    @Override
    public CloseableIteration<BindingSet> evaluate(final BindingSet bindings) {
        final Iterator assignments = this.node.getBindingSets().iterator();
        if (bindings.isEmpty()) {
            return new CloseableIteratorIteration(assignments);
        }
        LookAheadIteration<BindingSet> result = new LookAheadIteration<BindingSet>(){

            protected BindingSet getNextElement() throws QueryEvaluationException {
                MutableBindingSet nextResult = null;
                block0: while (nextResult == null && assignments.hasNext()) {
                    BindingSet assignedBindings = (BindingSet)assignments.next();
                    for (String name : assignedBindings.getBindingNames()) {
                        Value assignedValue;
                        if (nextResult == null) {
                            nextResult = BindingSetAssignmentQueryEvaluationStep.this.bsMaker.apply(bindings);
                        }
                        if ((assignedValue = assignedBindings.getValue(name)) == null) continue;
                        Value existingValue = bindings.getValue(name);
                        if (existingValue == null || assignedValue.equals((Object)existingValue)) {
                            if (existingValue != null) continue;
                            nextResult.addBinding(name, assignedValue);
                            continue;
                        }
                        nextResult = null;
                        continue block0;
                    }
                }
                return nextResult;
            }

            protected void handleClose() {
            }
        };
        return result;
    }
}

