/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class PrefixIndex {
    private final List<Map.Entry<String, String>> entries;

    public PrefixIndex(Map<String, String> prefixes) {
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>();
        if (prefixes != null) {
            list.addAll(prefixes.entrySet());
        }
        this.entries = Collections.unmodifiableList(list);
    }

    public PrefixHit longestMatch(String iri) {
        if (iri == null) {
            return null;
        }
        PrefixHit best = null;
        int bestLen = -1;
        for (Map.Entry<String, String> e : this.entries) {
            int len;
            String ns = e.getValue();
            if (!iri.startsWith(ns) || (len = ns.length()) <= bestLen) continue;
            bestLen = len;
            best = new PrefixHit(e.getKey(), ns);
        }
        return best;
    }

    public static final class PrefixHit {
        public final String prefix;
        public final String namespace;

        public PrefixHit(String prefix, String namespace) {
            this.prefix = prefix;
            this.namespace = namespace;
        }
    }
}

