/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrMinus;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrService;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class UnwrapSingleBgpInUnionBranchesTransform
extends BaseTransform {
    private UnwrapSingleBgpInUnionBranchesTransform() {
    }

    public static IrBGP apply(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        Iterator<IrNode> iterator = bgp.getLines().iterator();
        while (iterator.hasNext()) {
            IrNode n;
            IrNode m = n = iterator.next();
            if (n instanceof IrUnion) {
                m = UnwrapSingleBgpInUnionBranchesTransform.unwrapUnionBranches((IrUnion)n);
            } else if (n instanceof IrGraph) {
                IrGraph g = (IrGraph)n;
                m = new IrGraph(g.getGraph(), UnwrapSingleBgpInUnionBranchesTransform.apply(g.getWhere()), g.isNewScope());
            } else if (n instanceof IrOptional) {
                IrOptional o = (IrOptional)n;
                m = new IrOptional(UnwrapSingleBgpInUnionBranchesTransform.apply(o.getWhere()), o.isNewScope());
            } else if (n instanceof IrMinus) {
                IrMinus mi = (IrMinus)n;
                m = new IrMinus(UnwrapSingleBgpInUnionBranchesTransform.apply(mi.getWhere()), mi.isNewScope());
            } else if (n instanceof IrService) {
                IrService s = (IrService)n;
                m = new IrService(s.getServiceRefText(), s.isSilent(), UnwrapSingleBgpInUnionBranchesTransform.apply(s.getWhere()), s.isNewScope());
            } else if (n instanceof IrBGP) {
                m = UnwrapSingleBgpInUnionBranchesTransform.apply((IrBGP)n);
            } else if (n instanceof IrSubSelect) {
                // empty if block
            }
            out.add(m);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    private static IrUnion unwrapUnionBranches(IrUnion u) {
        IrUnion u2 = new IrUnion(u.isNewScope());
        Iterator<IrBGP> iterator = u.getBranches().iterator();
        while (iterator.hasNext()) {
            IrBGP b;
            IrBGP cur = b = iterator.next();
            boolean branchScope = b.isNewScope();
            while (cur.getLines().size() == 1 && cur.getLines().get(0) instanceof IrBGP) {
                IrBGP inner = (IrBGP)cur.getLines().get(0);
                branchScope = branchScope || inner.isNewScope();
                IrBGP flattened = new IrBGP(false);
                for (IrNode ln : inner.getLines()) {
                    flattened.add(ln);
                }
                cur = flattened;
            }
            cur.setNewScope(branchScope);
            u2.addBranch(cur);
        }
        return u2;
    }
}

