/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.rdf4j.common.io.NioFile;

class TxnStatusFile {
    boolean disabled = false;
    public static final String FILE_NAME = "txn-status";
    private final NioFile nioFile;
    static final TxnStatus[] statusMapping = new TxnStatus[17];

    public void disable() {
        this.disabled = true;
    }

    public TxnStatusFile(File dataDir) throws IOException {
        File statusFile = new File(dataDir, FILE_NAME);
        this.nioFile = new NioFile(statusFile, "rwd");
    }

    public TxnStatusFile() {
        this.nioFile = null;
    }

    public void close() throws IOException {
        if (this.nioFile != null) {
            this.nioFile.close();
        }
    }

    public void setTxnStatus(TxnStatus txnStatus, boolean force) throws IOException {
        if (this.disabled) {
            return;
        }
        if (txnStatus == TxnStatus.NONE) {
            this.nioFile.truncate(0L);
        } else {
            this.nioFile.writeBytes(txnStatus.onDisk, 0L);
        }
        if (force) {
            this.nioFile.force(false);
        }
    }

    public TxnStatus getTxnStatus() throws IOException {
        if (this.disabled) {
            return TxnStatus.NONE;
        }
        try {
            return statusMapping[this.nioFile.readBytes(0L, 1)[0]];
        }
        catch (EOFException e) {
            return TxnStatus.NONE;
        }
        catch (IndexOutOfBoundsException e) {
            return this.getTxnStatusDeprecated();
        }
    }

    private TxnStatus getTxnStatusDeprecated() throws IOException {
        if (this.disabled) {
            return TxnStatus.NONE;
        }
        byte[] bytes = this.nioFile.readBytes(0L, (int)this.nioFile.size());
        String s = new String(bytes, StandardCharsets.US_ASCII);
        try {
            return TxnStatus.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            s = new String(bytes);
            try {
                return TxnStatus.valueOf(s);
            }
            catch (IllegalArgumentException e2) {
                return TxnStatus.UNKNOWN;
            }
        }
    }

    static {
        TxnStatusFile.statusMapping[0] = TxnStatus.NONE;
        TxnStatusFile.statusMapping[1] = TxnStatus.NONE;
        TxnStatusFile.statusMapping[2] = TxnStatus.ACTIVE;
        TxnStatusFile.statusMapping[4] = TxnStatus.COMMITTING;
        TxnStatusFile.statusMapping[8] = TxnStatus.ROLLING_BACK;
        TxnStatusFile.statusMapping[16] = TxnStatus.UNKNOWN;
    }

    public static enum TxnStatus {
        NONE(0),
        ACTIVE(2),
        COMMITTING(4),
        ROLLING_BACK(8),
        UNKNOWN(16);

        private final byte[] onDisk = new byte[1];
        static final byte NONE_BYTE = 0;
        static final byte OLD_NONE_BYTE = 1;
        static final byte ACTIVE_BYTE = 2;
        static final byte COMMITTING_BYTE = 4;
        static final byte ROLLING_BACK_BYTE = 8;
        static final byte UNKNOWN_BYTE = 16;

        private TxnStatus(byte onDisk) {
            this.onDisk[0] = onDisk;
        }

        byte[] getOnDisk() {
            return this.onDisk;
        }
    }
}

