/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupUtil;
import org.eclipse.birt.data.engine.impl.document.CacheProvider;
import org.eclipse.birt.data.engine.impl.document.IRDGroupUtil;

public final class RDGroupUtil
implements IRDGroupUtil {
    private List[] groups;
    private int leafGroupIdx = 0;
    private CacheProvider cacheProvider;
    private Map<Integer, int[]> groupStartEndIndexCache = new HashMap<Integer, int[]>();
    private List<RAInputStream> inputStreams;

    RDGroupUtil(String tempDir, int groupNumber, List<RAInputStream> inputStreams, CacheProvider cacheProvider) throws DataException {
        this.groups = new List[groupNumber];
        int i = 0;
        while (i < groupNumber) {
            this.groups[i] = new GroupCachedList(inputStreams.get(i));
            ++i;
        }
        this.cacheProvider = cacheProvider;
        this.inputStreams = inputStreams;
    }

    public RDGroupUtil(String tempDir, int groupNumber, List<RAInputStream> inputStreams) throws DataException {
        this(tempDir, groupNumber, inputStreams, null);
    }

    @Override
    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    @Override
    public List[] getGroups() {
        return this.groups;
    }

    public void setGroups(List[] groups) {
        this.groups = groups;
    }

    @Override
    public void close() throws DataException {
        try {
            if (this.inputStreams != null) {
                int i = 0;
                while (i < this.inputStreams.size()) {
                    this.inputStreams.get(i).close();
                    ++i;
                }
                this.inputStreams = null;
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    private GroupInfo findGroup(int groupLevel, int groupIndex) {
        if (groupIndex >= this.groups[groupLevel].size()) {
            return null;
        }
        try {
            return (GroupInfo)this.groups[groupLevel].get(groupIndex);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void checkStarted() throws DataException {
        if (this.cacheProvider == null) {
            throw new DataException("data.engine.NoCurrentRow");
        }
    }

    private void checkHasCurrentRow() throws DataException {
        this.checkStarted();
        if (this.cacheProvider.getCurrentIndex() >= this.cacheProvider.getCount() && this.cacheProvider.getCount() != -1) {
            throw new DataException("data.engine.NoCurrentRow");
        }
    }

    @Override
    public int getEndingGroupLevel() throws DataException {
        this.checkHasCurrentRow();
        if (this.cacheProvider.getCurrentIndex() == this.cacheProvider.getCount() - 1) {
            return 0;
        }
        if (this.groups.length == 0) {
            return 1;
        }
        int childGroupIdx = this.cacheProvider.getCurrentIndex();
        int currentGroupIdx = this.leafGroupIdx;
        int level = this.groups.length - 1;
        while (level >= 0) {
            GroupInfo nextGroup = this.findGroup(level, currentGroupIdx + 1);
            if (nextGroup == null || childGroupIdx != nextGroup.firstChild - 1) break;
            childGroupIdx = currentGroupIdx;
            currentGroupIdx = this.findGroup((int)level, (int)currentGroupIdx).parent;
            --level;
        }
        return level + 2;
    }

    @Override
    public int getStartingGroupLevel() throws DataException {
        this.checkHasCurrentRow();
        if (this.cacheProvider.getCurrentIndex() == 0) {
            return 0;
        }
        if (this.groups.length == 0) {
            return 1;
        }
        int childGroupIdx = this.cacheProvider.getCurrentIndex();
        int currentGroupIdx = this.leafGroupIdx;
        int level = this.groups.length - 1;
        while (level >= 0) {
            GroupInfo currentGroup = this.findGroup(level, currentGroupIdx);
            if (currentGroup == null || childGroupIdx != currentGroup.firstChild) break;
            childGroupIdx = currentGroupIdx;
            currentGroupIdx = currentGroup.parent;
            --level;
        }
        return level + 2;
    }

    private int findCurrentGroup(int groupLevel) {
        int currentGroupIdx = this.leafGroupIdx;
        int i = this.groups.length - 1;
        while (i > groupLevel) {
            currentGroupIdx = this.findGroup((int)i, (int)currentGroupIdx).parent;
            --i;
        }
        return currentGroupIdx;
    }

    @Override
    public void last(int groupLevel) throws DataException {
        if (groupLevel > this.groups.length || groupLevel < 0) {
            throw new DataException("data.engine.InvalidGroupLevel", groupLevel);
        }
        int currentGroupIdx = -1;
        if (--groupLevel >= 0) {
            currentGroupIdx = this.findCurrentGroup(groupLevel);
        }
        if (groupLevel < 0 || currentGroupIdx >= this.groups[groupLevel].size() - 1) {
            int currentRowID = this.cacheProvider.getCount() - 1;
            this.cacheProvider.moveTo(currentRowID);
            if (this.groups.length > 0) {
                this.leafGroupIdx = this.groups[this.groups.length - 1].size() - 1;
            }
            return;
        }
        ++currentGroupIdx;
        int i = groupLevel + 1;
        while (i < this.groups.length) {
            currentGroupIdx = this.findGroup((int)(i - 1), (int)currentGroupIdx).firstChild;
            ++i;
        }
        int currentRowID = this.findGroup((int)(this.groups.length - 1), (int)currentGroupIdx).firstChild - 1;
        this.cacheProvider.moveTo(currentRowID);
        this.leafGroupIdx = currentGroupIdx - 1;
    }

    @Override
    public void next(boolean hasNext) throws DataException {
        GroupInfo nextLeafGroup;
        if (hasNext && this.groups.length > 0 && (nextLeafGroup = this.findGroup(this.groups.length - 1, this.leafGroupIdx + 1)) != null && this.cacheProvider.getCurrentIndex() >= nextLeafGroup.firstChild) {
            ++this.leafGroupIdx;
        }
    }

    @Override
    public void move() throws DataException {
        if (this.groups.length > 0) {
            this.binaryMove();
        }
    }

    private void binaryMove() throws DataException {
        List groupList = this.getGroups()[this.groups.length - 1];
        int low = this.leafGroupIdx;
        if (groupList.size() == Integer.MAX_VALUE) {
            int i = 0;
            while (true) {
                GroupInfo info;
                if ((info = (GroupInfo)groupList.get(i)) == null) {
                    return;
                }
                if (info.firstChild > this.cacheProvider.getCurrentIndex()) {
                    this.leafGroupIdx = i - 1;
                    return;
                }
                ++i;
            }
        }
        int high = groupList.size() - 1;
        while (low <= high) {
            int mid = (high + low) / 2;
            if (((GroupInfo)groupList.get((int)mid)).firstChild > this.cacheProvider.getCurrentIndex()) {
                high = mid - 1;
                continue;
            }
            if (mid == groupList.size() - 1 || ((GroupInfo)groupList.get((int)(mid + 1))).firstChild > this.cacheProvider.getCurrentIndex()) {
                this.leafGroupIdx = mid;
                return;
            }
            low = mid + 1;
        }
    }

    public int getGroupLevel() {
        return this.groups.length;
    }

    @Override
    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        this.checkHasCurrentRow();
        if (groupLevel == 0) {
            return 0;
        }
        if (groupLevel < 0 || groupLevel > this.groups.length) {
            throw new DataException("data.engine.InvalidGroupLevel", groupLevel);
        }
        int currentGroupIdx = this.leafGroupIdx;
        int level = this.groups.length - 1;
        while (level > groupLevel - 1) {
            GroupInfo currentGroup = this.findGroup(level, currentGroupIdx);
            currentGroupIdx = currentGroup.parent;
            --level;
        }
        return currentGroupIdx;
    }

    @Override
    public int[] getGroupStartAndEndIndex(int groupLevel) {
        if (this.groupStartEndIndexCache.containsKey(groupLevel)) {
            return this.groupStartEndIndexCache.get(groupLevel);
        }
        int max = -1;
        if (this.cacheProvider != null) {
            max = this.cacheProvider.getCount();
        }
        if (groupLevel == 0) {
            int[] nArray = new int[2];
            nArray[1] = max;
            this.groupStartEndIndexCache.put(groupLevel, nArray);
            return this.groupStartEndIndexCache.get(groupLevel);
        }
        int unitCountInOneGroup = this.groups[groupLevel - 1].size();
        if (unitCountInOneGroup == 1) {
            int[] nArray = new int[2];
            nArray[1] = max;
            this.groupStartEndIndexCache.put(groupLevel, nArray);
            return this.groupStartEndIndexCache.get(groupLevel);
        }
        int[] unitInfo = new int[unitCountInOneGroup * 2];
        int i = 0;
        while (i < unitCountInOneGroup) {
            int startIndex = i;
            int endIndex = startIndex + 1;
            startIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, startIndex, this.groups, max);
            endIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, endIndex, this.groups, max);
            unitInfo[i * 2] = startIndex;
            unitInfo[i * 2 + 1] = endIndex;
            ++i;
        }
        this.groupStartEndIndexCache.put(groupLevel, unitInfo);
        return this.groupStartEndIndexCache.get(groupLevel);
    }

    private static class GroupCachedList
    implements List<GroupInfo> {
        private int size;
        private RAInputStream dataSource;
        private long initOffset;

        public GroupCachedList(RAInputStream input) throws DataException {
            this.dataSource = input;
            try {
                this.initOffset = this.dataSource.getOffset();
                this.size = IOUtil.readInt((InputStream)this.dataSource);
            }
            catch (IOException e) {
                throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Group Info");
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public GroupInfo get(int index) {
            GroupInfo groupInfo = new GroupInfo();
            try {
                this.dataSource.seek((long)((index * 2 + 1) * 4) + this.initOffset);
                groupInfo.parent = IOUtil.readInt((InputStream)this.dataSource);
                groupInfo.firstChild = IOUtil.readInt((InputStream)this.dataSource);
            }
            catch (IOException e) {
                try {
                    if (this.dataSource.length() == (long)((index * 2 + 1) * 4) + this.initOffset) {
                        return null;
                    }
                }
                catch (IOException iOException) {}
                throw new RuntimeException(e);
            }
            return groupInfo;
        }

        @Override
        public boolean add(GroupInfo o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, GroupInfo element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public GroupInfo remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public GroupInfo set(int index, GroupInfo element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray(Object[] a) {
            throw new UnsupportedOperationException();
        }
    }
}

