/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.tools.emf.ui.common.AbstractElementEditorContribution;
import org.eclipse.e4.tools.emf.ui.common.IContributionClassCreator;
import org.eclipse.e4.tools.emf.ui.common.IEditorDescriptor;
import org.eclipse.e4.tools.emf.ui.common.IEditorFeature;
import org.eclipse.e4.tools.emf.ui.common.IExtensionLookup;
import org.eclipse.e4.tools.emf.ui.common.IModelExtractor;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.common.IScriptingSupport;
import org.eclipse.e4.tools.emf.ui.common.MemoryTransfer;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.ComponentLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.ControlHighlighter;
import org.eclipse.e4.tools.emf.ui.internal.common.TreeViewerEx;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.tools.emf.ui.internal.common.component.AddonsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ApplicationEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.AreaEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.BindingContextEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.BindingTableEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CategoryEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CommandEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CommandParameterEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CompositePartEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CoreExpressionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DefaultEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DirectMenuItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DirectToolItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DynamicMenuContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandledMenuItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandledToolItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandlerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ImperativeExpressionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.KeyBindingEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuSeparatorEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ModelFragmentsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ParameterEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartDescriptorEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartSashContainerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartStackEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PerspectiveEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PerspectiveStackEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PlaceholderEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PopupMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.StringModelFragment;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolBarContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolBarEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolBarSeparatorEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolControlEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.TrimBarEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.TrimContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.TrimmedWindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.WindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.EmfUtil;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.IGotoObject;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.ListTab;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.XmiTab;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VApplicationAddons;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VApplicationCategoriesEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VApplicationWindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VBindingTableEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VCommandEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VHandlerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VItemParametersEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VMenuContributionsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VModelFragmentsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VModelImportsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPartDescriptor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPartDescriptorMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPartMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPerspectiveControlEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPerspectiveWindowsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VRootBindingContexts;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VSnippetsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VToolBarContributionsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VTrimContributionsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowControlEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowSharedElementsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowTrimEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowWindowsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.properties.ExportIdsHandler;
import org.eclipse.e4.tools.emf.ui.internal.common.properties.ExternalizeStringHandler;
import org.eclipse.e4.tools.emf.ui.internal.common.properties.ProjectOSGiTranslationProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.xml.EMFDocumentResourceMediator;
import org.eclipse.e4.tools.services.IClipboardService;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.dialogs.filteredtree.FilteredTree;
import org.eclipse.e4.ui.dialogs.filteredtree.PatternFilter;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationElementImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedPackageImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.e4.ui.model.fragment.MModelFragment;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.model.fragment.MStringModelFragment;
import org.eclipse.e4.ui.model.fragment.impl.FragmentPackageImpl;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.service.event.Event;

public class ModelEditor
implements IGotoObject {
    private static final String ORG_ECLIPSE_E4_TOOLS_MODELEDITOR_FILTEREDTREE_ENABLED_XMITAB_DISABLED = "org.eclipse.e4.tools.modeleditor.filteredtree.enabled.xmitab.disabled";
    public static final String CSS_CLASS_KEY = "org.eclipse.e4.ui.css.CssClassName";
    public static final String VIRTUAL_PART_MENU = "org.eclipse.e4.tools.emf.ui.VIRTUAL_PART_MENU";
    public static final String VIRTUAL_HANDLER = "org.eclipse.e4.tools.emf.ui.VIRTUAL_HANDLER";
    public static final String VIRTUAL_BINDING_TABLE = "org.eclipse.e4.tools.emf.ui.VIRTUAL_BINDING_TABLE";
    public static final String VIRTUAL_COMMAND = "org.eclipse.e4.tools.emf.ui.VIRTUAL_COMMAND";
    public static final String VIRTUAL_APPLICATION_WINDOWS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_APPLICATION_WINDOWS";
    public static final String VIRTUAL_PERSPECTIVE_WINDOWS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_PERSPECTIVE_WINDOWS";
    public static final String VIRTUAL_WINDOW_WINDOWS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_WINDOW_WINDOWS";
    public static final String VIRTUAL_WINDOW_CONTROLS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_WINDOW_CONTROLS";
    public static final String VIRTUAL_PART_DESCRIPTORS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_PART_DESCRIPTORS";
    public static final String VIRTUAL_PARTDESCRIPTOR_MENU = "org.eclipse.e4.tools.emf.ui.VIRTUAL_PARTDESCRIPTOR_MENU";
    public static final String VIRTUAL_TRIMMED_WINDOW_TRIMS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_TRIMMED_WINDOW_TRIMS";
    public static final String VIRTUAL_ADDONS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_ADDONS";
    public static final String VIRTUAL_MENU_CONTRIBUTIONS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_MENU_CONTRIBUTIONS";
    public static final String VIRTUAL_TOOLBAR_CONTRIBUTIONS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_TOOLBAR_CONTRIBUTIONS";
    public static final String VIRTUAL_TRIM_CONTRIBUTIONS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_TRIM_CONTRIBUTIONS";
    public static final String VIRTUAL_WINDOW_SHARED_ELEMENTS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_WINDOW_SHARED_ELEMENTS";
    public static final String VIRTUAL_WINDOW_SNIPPETS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_WINDOW_SNIPPETS";
    public static final String VIRTUAL_MODEL_FRAGEMENTS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_MODEL_FRAGEMENTS";
    public static final String VIRTUAL_MODEL_IMPORTS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_MODEL_IMPORTS";
    public static final String VIRTUAL_CATEGORIES = "org.eclipse.e4.tools.emf.ui.VIRTUAL_CATEGORIES";
    public static final String VIRTUAL_PARAMETERS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_PARAMETERS";
    public static final String VIRTUAL_MENUELEMENTS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_MENUELEMENTS";
    public static final String VIRTUAL_ROOT_CONTEXTS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_ROOT_CONTEXTS";
    public static final String VIRTUAL_PERSPECTIVE_CONTROLS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_PERSPECTIVE_CONTROLS";
    public static final String VIRTUAL_SNIPPETS = "org.eclipse.e4.tools.emf.ui.VIRTUAL_SNIPPETS";
    public static final int TAB_FORM = 0;
    public static final int TAB_XMI = 1;
    public static final int TAB_LIST = 2;
    private final Map<String, AbstractComponentEditor> editors = new HashMap<String, AbstractComponentEditor>();
    private final Map<String, Class<? extends AbstractComponentEditor>> editorsClasses = new HashMap<String, Class<? extends AbstractComponentEditor>>();
    private final Map<Class<?>, List<AbstractElementEditorContribution>> tabContributions = new HashMap();
    private final List<FeaturePath> labelFeaturePaths = new ArrayList<FeaturePath>();
    private final List<IEditorFeature> editorFeatures = new ArrayList<IEditorFeature>();
    private final List<IContributionClassCreator> contributionCreator = new ArrayList<IContributionClassCreator>();
    private TreeViewer viewer;
    private final IModelResource modelProvider;
    private final IProject project;
    private final ImageRegistry componentImages = new ImageRegistry();
    @Inject
    ESelectionService selectionService;
    @Inject
    MApplication app;
    private final IEclipseContext context;
    private boolean fragment;
    private IClipboardService.Handler clipboardHandler;
    @Inject
    @Optional
    private IClipboardService clipboardService;
    @Inject
    @Preference(nodePath="org.eclipse.e4.tools.emf.ui", value="autoCreateElementId")
    private boolean autoCreateElementId;
    @Inject
    @Preference(nodePath="org.eclipse.e4.tools.emf.ui", value="showXMIId")
    private boolean showXMIId;
    @Inject
    @Preference(nodePath="org.eclipse.e4.tools.emf.ui")
    IEclipsePreferences preferences;
    @Inject
    @Optional
    private IExtensionLookup extensionLookup;
    @Inject
    @Translation
    private Messages messages;
    @Inject
    @Optional
    private IModelExtractor modelExtractor;
    @Inject
    @Optional
    MPart currentPart;
    private final ObservablesManager obsManager;
    private final IResourcePool resourcePool;
    private EMFDocumentResourceMediator emfDocumentProvider;
    private AbstractComponentEditor currentEditor;
    private Listener keyListener;
    private CTabFolder editorTabFolder;
    private boolean mod1Down = false;
    private boolean saving;
    private ListTab listTab;
    private CTabItem tabItemXmi;
    private CTabItem tabItemList;
    private CTabItem tabItemTree;
    private XmiTab xmiTab;
    private Label sectionHeaderLabel;

    public ModelEditor(Composite composite, IEclipseContext context, IModelResource modelProvider, IProject project, IResourcePool resourcePool) {
        this.resourcePool = resourcePool;
        this.modelProvider = modelProvider;
        this.project = project;
        this.context = context;
        this.context.set(ModelEditor.class, (Object)this);
        this.obsManager = new ObservablesManager();
        if (project != null) {
            String localeString = "";
            Object object = this.context.get("org.eclipse.e4.core.locale");
            if (object != null) {
                localeString = object.toString();
            }
            ProjectOSGiTranslationProvider translationProvider = new ProjectOSGiTranslationProvider(project, localeString){

                @Override
                protected void updateResourceBundle() {
                    super.updateResourceBundle();
                    if (ModelEditor.this.viewer != null) {
                        ModelEditor.this.viewer.getControl().getDisplay().asyncExec(() -> ModelEditor.this.viewer.refresh());
                    }
                }
            };
            context.set(ProjectOSGiTranslationProvider.class, (Object)translationProvider);
        }
        this.labelFeaturePaths.add(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED}));
        this.labelFeaturePaths.add(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__VISIBLE}));
        composite.addDisposeListener(arg0 -> this.persistState());
    }

    @PersistState
    protected void persistState() {
        if (this.listTab != null) {
            this.listTab.saveSettings();
        }
    }

    @PostConstruct
    void postCreate(Composite composite) {
        if (this.project == null) {
            this.keyListener = event -> {
                if ((event.stateMask & 0x10000) == 65536) {
                    this.findAndHighlight(((Display)this.context.get(Display.class)).getFocusControl());
                }
            };
            ((Display)this.context.get(Display.class)).addFilter(4, this.keyListener);
        }
        this.context.set(ModelEditor.class, (Object)this);
        this.context.set(IResourcePool.class, (Object)this.resourcePool);
        this.context.set(EditingDomain.class, (Object)this.modelProvider.getEditingDomain());
        this.context.set(IModelResource.class, (Object)this.modelProvider);
        if (this.project != null) {
            this.context.set(IProject.class, (Object)this.project);
        }
        this.loadEditorFeatures();
        this.registerDefaultEditors();
        this.registerVirtualEditors();
        this.registerContributedEditors();
        this.registerContributedVirtualEditors();
        this.registerContributedEditorTabs();
        this.loadContributionCreators();
        this.fragment = this.modelProvider.getRoot().get(0) instanceof MModelFragments;
        this.emfDocumentProvider = new EMFDocumentResourceMediator(this.modelProvider);
        this.editorTabFolder = new CTabFolder(composite, 1024);
        this.tabItemTree = new CTabItem(this.editorTabFolder, 0);
        this.tabItemTree.setText(this.messages.ModelEditor_Form);
        this.tabItemTree.setControl((Control)this.createFormTab((Composite)this.editorTabFolder));
        this.tabItemTree.setImage(this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.application_form"));
        this.tabListShow(true);
        this.tabItemXmi = new CTabItem(this.editorTabFolder, 0);
        this.tabItemXmi.setText(this.messages.ModelEditor_XMI);
        this.xmiTab = this.createXMITab((Composite)this.editorTabFolder);
        this.tabItemXmi.setControl((Control)this.xmiTab);
        this.tabItemXmi.setImage(this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.chart_organisation"));
        this.editorTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ModelEditor.this.editorTabFolder.getSelectionIndex() == ModelEditor.getTabIndex(ModelEditor.this.tabItemXmi)) {
                    ModelEditor.this.emfDocumentProvider.updateFromEMF();
                }
            }
        });
        this.editorTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ModelEditor.this.listTab != null && ModelEditor.this.editorTabFolder.getSelectionIndex() == ModelEditor.getTabIndex(ModelEditor.this.listTab.getTabItem())) {
                    ModelEditor.this.app.getContext().set("org.eclipse.e4.tools.active-object-viewer", (Object)ModelEditor.this.listTab);
                } else {
                    ModelEditor.this.app.getContext().set("org.eclipse.e4.tools.active-object-viewer", null);
                }
            }
        });
        this.editorTabFolder.setSelection(0);
    }

    public static int getTabIndex(CTabItem tabItem) {
        return Arrays.asList(tabItem.getParent().getItems()).indexOf(tabItem);
    }

    private void findAndHighlight(Control control) {
        if (control != null) {
            MApplicationElement m;
            MApplicationElement o = m = this.findModelElement(control);
            if (m != null) {
                ArrayList<MApplicationElement> l = new ArrayList<MApplicationElement>();
                do {
                    l.add(m);
                } while ((m = (MApplicationElement)((EObject)m).eContainer()) != null);
                if (o instanceof MPart) {
                    System.err.println(String.valueOf(this.getClass().getName()) + ".findAndHighLight: " + o);
                    System.err.println(String.valueOf(this.getClass().getName()) + ".findAndHighLight: " + ((EObject)o).eContainingFeature());
                }
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)o));
            }
        }
    }

    private MApplicationElement findModelElement(Control control) {
        do {
            if (control.getData("modelElement") == null) continue;
            return (MApplicationElement)control.getData("modelElement");
        } while ((control = control.getParent()) != null);
        return null;
    }

    private XmiTab createXMITab(Composite composite) {
        IEclipseContext childContext = this.context.createChild();
        childContext.set(Composite.class, (Object)composite);
        childContext.set(EMFDocumentResourceMediator.class, (Object)this.emfDocumentProvider);
        childContext.set(IEclipsePreferences.class, (Object)this.preferences);
        childContext.set(IResourcePool.class, (Object)this.resourcePool);
        XmiTab ret = (XmiTab)((Object)ContextInjectionFactory.make(XmiTab.class, (IEclipseContext)childContext));
        return ret;
    }

    private Composite createFormTab(Composite composite) {
        SashForm form = new SashForm(composite, 256);
        form.setBackground(form.getDisplay().getSystemColor(1));
        this.viewer = this.createTreeViewerArea((Composite)form);
        Composite parent = new Composite((Composite)form, 0);
        FillLayout l = new FillLayout();
        parent.setLayout((Layout)l);
        Composite editingArea = new Composite(parent, 2048);
        GridLayout gl = new GridLayout();
        editingArea.setLayout((Layout)gl);
        Composite headerContainer = new Composite(editingArea, 0);
        headerContainer.setLayout((Layout)new GridLayout(3, false));
        headerContainer.setLayoutData((Object)new GridData(768));
        Label iconLabel = new Label(headerContainer, 0);
        iconLabel.setLayoutData((Object)new GridData(20, 20));
        this.sectionHeaderLabel = new Label(headerContainer, 0);
        this.sectionHeaderLabel.setLayoutData((Object)new GridData(768));
        Label separatorLabel = new Label(headerContainer, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        separatorLabel.setLayoutData((Object)gridData);
        StackLayout layout = new StackLayout();
        Composite contentContainer = new Composite(editingArea, 0);
        contentContainer.setLayoutData((Object)new GridData(1808));
        contentContainer.setLayout((Layout)layout);
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    Command cmd;
                    ArrayList<EObject> list = new ArrayList<EObject>();
                    IStructuredSelection selection = (IStructuredSelection)ModelEditor.this.viewer.getSelection();
                    for (Object o : ((StructuredSelection)selection).toList()) {
                        if (!(o instanceof EObject)) continue;
                        list.add((EObject)o);
                    }
                    if (!list.isEmpty() && (cmd = DeleteCommand.create((EditingDomain)ModelEditor.this.modelProvider.getEditingDomain(), list)).canExecute()) {
                        ModelEditor.this.modelProvider.getEditingDomain().getCommandStack().execute(cmd);
                    }
                }
            }
        });
        this.viewer.addSelectionChangedListener(event -> {
            if (!event.getSelection().isEmpty()) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                if (s.getFirstElement() instanceof EObject) {
                    EObject obj = (EObject)s.getFirstElement();
                    AbstractComponentEditor editor1 = this.getEditor(obj.eClass());
                    if (editor1 != null) {
                        this.currentEditor = editor1;
                        this.sectionHeaderLabel.setText(editor1.getLabel(obj));
                        iconLabel.setImage(editor1.getImage(obj));
                        this.obsManager.runAndCollect(() -> {
                            Composite comp = editor1.getEditor(contentContainer, s.getFirstElement());
                            comp.setBackgroundMode(1);
                            stackLayout.topControl = comp;
                            contentContainer.layout(true);
                        });
                    }
                } else {
                    VirtualEntry entry = (VirtualEntry)s.getFirstElement();
                    AbstractComponentEditor editor2 = this.getEditor(entry.getId());
                    if (editor2 != null) {
                        this.currentEditor = editor2;
                        this.sectionHeaderLabel.setText(editor2.getLabel(entry));
                        iconLabel.setImage(editor2.getImage(entry));
                        this.obsManager.runAndCollect(() -> {
                            Composite comp = editor2.getEditor(contentContainer, s.getFirstElement());
                            comp.setBackgroundMode(1);
                            stackLayout.topControl = comp;
                            contentContainer.layout(true);
                        });
                    }
                }
                if (this.selectionService != null) {
                    this.selectionService.setSelection(s.getFirstElement());
                }
            }
        });
        form.setWeights(new int[]{3, 4});
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(manager -> {
            IExtensionRegistry registry;
            IExtensionPoint extPoint;
            IConfigurationElement[] elements;
            final IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
            final List listOfSelections = s.toList();
            int noSelected = listOfSelections.size();
            boolean addSeparator = false;
            if (!s.isEmpty() && noSelected == 1) {
                List<Action> actions;
                if (s.getFirstElement() instanceof VirtualEntry) {
                    actions = this.getEditor(((VirtualEntry)s.getFirstElement()).getId()).getActions(s.getFirstElement());
                    if (actions.size() > 0) {
                        MenuManager addMenu1 = new MenuManager(this.messages.ModelEditor_AddChild);
                        for (Action a1 : actions) {
                            addSeparator = true;
                            addMenu1.add((IAction)a1);
                        }
                        manager.add((IContributionItem)addMenu1);
                    }
                    if ((actions = this.getEditor(((VirtualEntry)s.getFirstElement()).getId()).getActionsImport(s.getFirstElement())).size() > 0) {
                        MenuManager menu1 = new MenuManager(this.messages.ModelEditor_Import3x);
                        for (Action a2 : actions) {
                            addSeparator = true;
                            menu1.add((IAction)a2);
                        }
                        manager.add((IContributionItem)menu1);
                    }
                    if (addSeparator) {
                        manager.add((IContributionItem)new Separator());
                    }
                } else {
                    final EObject o = (EObject)s.getFirstElement();
                    AbstractComponentEditor editor = this.getEditor(o.eClass());
                    actions = editor != null ? new ArrayList<Action>(editor.getActions(s.getFirstElement())) : new ArrayList<Action>();
                    if (actions.size() > 0) {
                        MenuManager addMenu2 = new MenuManager(this.messages.ModelEditor_AddChild);
                        for (Action a3 : actions) {
                            addSeparator = true;
                            addMenu2.add((IAction)a3);
                        }
                        manager.add((IContributionItem)addMenu2);
                    }
                    if ((actions = editor != null ? new ArrayList<Action>(editor.getActionsImport(s.getFirstElement())) : new ArrayList<Action>()).size() > 0) {
                        MenuManager menu2 = new MenuManager(this.messages.ModelEditor_Import3x);
                        for (Action a4 : actions) {
                            addSeparator = true;
                            menu2.add((IAction)a4);
                        }
                        manager.add((IContributionItem)menu2);
                    }
                    if (o.eContainer() != null) {
                        addSeparator = true;
                        manager.add((IAction)new Action(this.messages.ModelEditor_Delete, ImageDescriptor.createFromImage((Image)this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.cross"))){

                            public void run() {
                                Command cmd = DeleteCommand.create((EditingDomain)ModelEditor.this.modelProvider.getEditingDomain(), (Object)o);
                                if (cmd.canExecute()) {
                                    ModelEditor.this.modelProvider.getEditingDomain().getCommandStack().execute(cmd);
                                }
                            }
                        });
                    }
                }
            }
            if (noSelected > 0 && !this.isModelFragment() && this.modelExtractor != null) {
                manager.add((IAction)new Action(this.messages.ModelEditor_ExtractFragment, ImageDescriptor.createFromImage((Image)this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.modelelements.ModelFragments"))){

                    public void run() {
                        Command cmd;
                        ArrayList<MApplicationElement> maes = new ArrayList<MApplicationElement>();
                        for (Object objSelect : listOfSelections) {
                            EObject container = null;
                            if (objSelect instanceof VirtualEntry) {
                                VirtualEntry ve = (VirtualEntry)objSelect;
                                container = (EObject)ve.getOriginalParent();
                                IObservableList list = ve.getList();
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    maes.add((MApplicationElement)iterator.next());
                                }
                            } else {
                                container = ((EObject)objSelect).eContainer();
                                MApplicationElement objSelect2 = (MApplicationElement)objSelect;
                                if (!(objSelect2 instanceof MApplication)) {
                                    maes.add(objSelect2);
                                } else {
                                    return;
                                }
                            }
                            String containerId = ((MApplicationElement)container).getElementId();
                            if (containerId != null && containerId.length() != 0) continue;
                            MessageDialog.openError((Shell)ModelEditor.this.viewer.getControl().getShell(), null, (String)((ModelEditor)ModelEditor.this).messages.ModelEditor_ExtractFragment_NoParentId);
                            return;
                        }
                        if (ModelEditor.this.modelExtractor.extract(ModelEditor.this.viewer.getControl().getShell(), ModelEditor.this.project, maes) && (cmd = DeleteCommand.create((EditingDomain)ModelEditor.this.modelProvider.getEditingDomain(), maes)).canExecute()) {
                            ModelEditor.this.modelProvider.getEditingDomain().getCommandStack().execute(cmd);
                        }
                    }
                });
            }
            if ((elements = (extPoint = (registry = RegistryFactory.getRegistry()).getExtensionPoint("org.eclipse.e4.tools.emf.ui.scripting")).getConfigurationElements()).length > 0 && !s.isEmpty() && s.getFirstElement() instanceof MApplicationElement && noSelected == 1) {
                if (addSeparator) {
                    manager.add((IContributionItem)new Separator());
                }
                addSeparator = false;
                MenuManager scriptExecute = new MenuManager(this.messages.ModelEditor_Script);
                manager.add((IContributionItem)scriptExecute);
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement e;
                    final IConfigurationElement le = e = iConfigurationElementArray[n2];
                    scriptExecute.add((IAction)new Action(e.getAttribute("label")){

                        public void run() {
                            try {
                                MApplicationElement o = (MApplicationElement)s.getFirstElement();
                                IScriptingSupport support = (IScriptingSupport)le.createExecutableExtension("class");
                                IEclipseContext ctx = null;
                                if (ModelEditor.this.project == null) {
                                    ctx = o instanceof MContext ? ((MContext)o).getContext() : ModelUtils.getContainingContext((MApplicationElement)o);
                                }
                                support.openEditor(ModelEditor.this.viewer.getControl().getShell(), s.getFirstElement(), ctx);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    ++n2;
                }
            }
            if (this.project != null) {
                if (addSeparator) {
                    manager.add((IContributionItem)new Separator());
                }
                Action nlsAction = new Action(this.messages.ModelEditor_ExternalizeStrings){

                    public void run() {
                        ExternalizeStringHandler h = (ExternalizeStringHandler)ContextInjectionFactory.make(ExternalizeStringHandler.class, (IEclipseContext)ModelEditor.this.context);
                        ContextInjectionFactory.invoke((Object)h, Execute.class, (IEclipseContext)ModelEditor.this.context);
                    }
                };
                Action extIdAction = new Action(this.messages.ModelEditor_ExportIds){

                    public void run() {
                        ExportIdsHandler h = (ExportIdsHandler)ContextInjectionFactory.make(ExportIdsHandler.class, (IEclipseContext)ModelEditor.this.context);
                        ContextInjectionFactory.invoke((Object)h, Execute.class, (IEclipseContext)ModelEditor.this.context);
                    }
                };
                manager.add((IAction)nlsAction);
                manager.add((IAction)extIdAction);
            } else {
                MUIElement el1;
                if (addSeparator) {
                    manager.add((IContributionItem)new Separator());
                }
                if (s.getFirstElement() instanceof MUIElement && (el1 = (MUIElement)s.getFirstElement()).getWidget() instanceof Control) {
                    manager.add((IAction)new Action(this.messages.ModelEditor_ShowControl){

                        public void run() {
                            ControlHighlighter.show((Control)el1.getWidget());
                        }
                    });
                }
            }
            if (addSeparator) {
                manager.add((IContributionItem)new Separator());
            }
            Action expandAction = new Action(this.messages.ModelEditor_ExpandSubtree){

                public void run() {
                    if (!s.isEmpty()) {
                        if (ModelEditor.this.viewer.getExpandedState(s.getFirstElement())) {
                            ModelEditor.this.viewer.collapseToLevel(s.getFirstElement(), -1);
                        } else {
                            ModelEditor.this.viewer.expandToLevel(s.getFirstElement(), -1);
                        }
                    }
                }
            };
            manager.add((IAction)expandAction);
            if (s.getFirstElement() instanceof EObject) {
                manager.add((IContributionItem)new Separator());
                final EObject el2 = (EObject)s.getFirstElement();
                Action gotoXmiAction = new Action(this.messages.ModelEditor_goto_xmi){

                    public void run() {
                        ModelEditor.this.gotoEObject(1, el2);
                    }
                };
                manager.add((IAction)gotoXmiAction);
                if (this.listTab != null && EmfUtil.getAttribute(el2, "elementId") != null) {
                    Action gotoListAction = new Action(this.messages.ModelEditor_goto_list){

                        public void run() {
                            ModelEditor.this.gotoEObject(2, el2);
                        }
                    };
                    manager.add((IAction)gotoListAction);
                }
            }
        });
        this.viewer.getTree().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (ModelEditor.this.mod1Down && (e.keyCode & SWT.MOD1) == SWT.MOD1) {
                    ModelEditor.this.mod1Down = false;
                }
            }

            public void keyPressed(KeyEvent e) {
                if (!ModelEditor.this.mod1Down && (e.keyCode & SWT.MOD1) == SWT.MOD1) {
                    ModelEditor.this.mod1Down = true;
                }
            }
        });
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                if (ModelEditor.this.mod1Down) {
                    ModelEditor.this.viewer.getTree().getDisplay().asyncExec(() -> ModelEditor.this.viewer.expandToLevel(event.getElement(), -1));
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                if (ModelEditor.this.mod1Down) {
                    ModelEditor.this.viewer.getTree().getDisplay().asyncExec(() -> ModelEditor.this.viewer.collapseToLevel(event.getElement(), -1));
                }
            }
        });
        this.viewer.getControl().setMenu(mgr.createContextMenu(this.viewer.getControl()));
        this.viewer.setSelection((ISelection)new StructuredSelection((List)this.modelProvider.getRoot()));
        return form;
    }

    public IExtensionLookup getExtensionLookup() {
        return this.extensionLookup;
    }

    public boolean isAutoCreateElementId() {
        return this.autoCreateElementId && this.project != null;
    }

    public IProject getProject() {
        return this.project;
    }

    public ImageRegistry getComponentImages() {
        return this.componentImages;
    }

    public boolean isShowXMIId() {
        return this.showXMIId;
    }

    private void loadContributionCreators() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("contributionClassCreator".equals(el.getName())) {
                try {
                    this.contributionCreator.add((IContributionClassCreator)el.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public IContributionClassCreator getContributionCreator(EClass eClass) {
        for (IContributionClassCreator c : this.contributionCreator) {
            if (!c.isSupported(eClass)) continue;
            return c;
        }
        return null;
    }

    private void loadEditorFeatures() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("editorfeature".equals(el.getName())) {
                try {
                    this.editorFeatures.add((IEditorFeature)el.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public boolean isModelFragment() {
        return this.fragment;
    }

    public boolean isLiveModel() {
        return !this.modelProvider.isSaveable();
    }

    public List<IEditorFeature.FeatureClass> getFeatureClasses(EClass eClass, EStructuralFeature feature) {
        ArrayList<IEditorFeature.FeatureClass> list = new ArrayList<IEditorFeature.FeatureClass>();
        for (IEditorFeature f : this.editorFeatures) {
            list.addAll(f.getFeatureClasses(eClass, feature));
        }
        return list;
    }

    private TreeViewer createTreeViewerArea(Composite parent) {
        Composite treeArea = new Composite(parent, 2048);
        treeArea.setLayout((Layout)new FillLayout());
        treeArea.setData(CSS_CLASS_KEY, (Object)"formContainer");
        treeArea.setBackgroundMode(1);
        TreeViewer tempViewer = null;
        String property = System.getProperty(ORG_ECLIPSE_E4_TOOLS_MODELEDITOR_FILTEREDTREE_ENABLED_XMITAB_DISABLED);
        if (property != null || this.preferences.getBoolean("tab-form-search-show", false)) {
            FilteredTree viewParent = new FilteredTree(treeArea, 66306, new PatternFilter(true));
            tempViewer = viewParent.getViewer();
        } else {
            tempViewer = new TreeViewerEx(treeArea, 66306, this.emfDocumentProvider, this.modelProvider);
        }
        final TreeViewer viewer = tempViewer;
        FontDescriptor italicFontDescriptor = FontDescriptor.createFrom((Font)viewer.getControl().getFont()).setStyle(2);
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ComponentLabelProvider(this, this.messages, italicFontDescriptor)));
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider((IObservableFactory)new ObservableFactoryImpl(), new TreeStructureAdvisor(){});
        viewer.setContentProvider((IContentProvider)contentProvider);
        WritableSet clearedSet = new WritableSet();
        contentProvider.getKnownElements().addSetChangeListener(event -> {
            for (Object o1 : event.diff.getAdditions()) {
                if (!(o1 instanceof EObject)) continue;
                clearedSet.add(o1);
            }
            for (Object o2 : event.diff.getRemovals()) {
                if (!(o2 instanceof EObject)) continue;
                clearedSet.remove(o2);
            }
        });
        for (FeaturePath p : this.labelFeaturePaths) {
            IObservableMap map = EMFProperties.value((FeaturePath)p).observeDetail((IObservableSet)clearedSet);
            map.addMapChangeListener(event -> viewer.update(event.diff.getChangedKeys().toArray(), null));
        }
        viewer.setInput((Object)this.modelProvider.getRoot());
        viewer.setAutoExpandLevel(2);
        viewer.expandToLevel(viewer.getAutoExpandLevel());
        viewer.addDoubleClickListener(event -> {
            TreeViewer viewer1 = (TreeViewer)event.getViewer();
            IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
            Object selectedNode = thisSelection.getFirstElement();
            if (this.mod1Down) {
                if (viewer1.getExpandedState(selectedNode)) {
                    viewer1.setExpandedState(selectedNode, false);
                } else {
                    viewer1.expandToLevel(selectedNode, -1);
                }
            } else {
                viewer1.setExpandedState(selectedNode, !viewer1.getExpandedState(selectedNode));
            }
        });
        viewer.getTree().addTreeListener((TreeListener)new TreeAdapter(){

            public void treeCollapsed(TreeEvent e) {
                viewer.expandToLevel(viewer.getAutoExpandLevel());
            }
        });
        viewer.addDragSupport(2, new Transfer[]{MemoryTransfer.getInstance()}, (DragSourceListener)new DragListener(viewer));
        viewer.addDropSupport(2, new Transfer[]{MemoryTransfer.getInstance()}, (DropTargetListener)new DropListener((Viewer)viewer, this.modelProvider.getEditingDomain()));
        return viewer;
    }

    private void registerContributedVirtualEditors() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("virtualeditor".equals(el.getName())) {
                IContributionFactory fact = (IContributionFactory)this.context.get(IContributionFactory.class);
                AbstractComponentEditor editor = (AbstractComponentEditor)fact.create("bundleclass://" + el.getContributor().getName() + "/" + el.getAttribute("class"), this.context);
                this.registerEditor(el.getAttribute("id"), editor);
            }
            ++n2;
        }
    }

    private void registerVirtualEditors() {
        this.registerEditor(VIRTUAL_PART_MENU, VPartMenuEditor.class);
        this.registerEditor(VIRTUAL_HANDLER, VHandlerEditor.class);
        this.registerEditor(VIRTUAL_BINDING_TABLE, VBindingTableEditor.class);
        this.registerEditor(VIRTUAL_COMMAND, VCommandEditor.class);
        this.registerEditor(VIRTUAL_APPLICATION_WINDOWS, VApplicationWindowEditor.class);
        this.registerEditor(VIRTUAL_WINDOW_WINDOWS, VWindowWindowsEditor.class);
        this.registerEditor(VIRTUAL_PERSPECTIVE_WINDOWS, VPerspectiveWindowsEditor.class);
        this.registerEditor(VIRTUAL_WINDOW_CONTROLS, VWindowControlEditor.class);
        this.registerEditor(VIRTUAL_WINDOW_SNIPPETS, VSnippetsEditor.class);
        this.registerEditor(VIRTUAL_PART_DESCRIPTORS, VPartDescriptor.class);
        this.registerEditor(VIRTUAL_PARTDESCRIPTOR_MENU, VPartDescriptorMenuEditor.class);
        this.registerEditor(VIRTUAL_TRIMMED_WINDOW_TRIMS, VWindowTrimEditor.class);
        this.registerEditor(VIRTUAL_ADDONS, VApplicationAddons.class);
        this.registerEditor(VIRTUAL_MENU_CONTRIBUTIONS, VMenuContributionsEditor.class);
        this.registerEditor(VIRTUAL_TOOLBAR_CONTRIBUTIONS, VToolBarContributionsEditor.class);
        this.registerEditor(VIRTUAL_TRIM_CONTRIBUTIONS, VTrimContributionsEditor.class);
        this.registerEditor(VIRTUAL_WINDOW_SHARED_ELEMENTS, VWindowSharedElementsEditor.class);
        this.registerEditor(VIRTUAL_MODEL_FRAGEMENTS, VModelFragmentsEditor.class);
        this.registerEditor(VIRTUAL_MODEL_IMPORTS, VModelImportsEditor.class);
        this.registerEditor(VIRTUAL_CATEGORIES, VApplicationCategoriesEditor.class);
        this.registerEditor(VIRTUAL_PARAMETERS, VItemParametersEditor.class);
        this.registerEditor(VIRTUAL_ROOT_CONTEXTS, VRootBindingContexts.class);
        this.registerEditor(VIRTUAL_PERSPECTIVE_CONTROLS, VPerspectiveControlEditor.class);
        this.registerEditor(VIRTUAL_SNIPPETS, VSnippetsEditor.class);
    }

    public void setSelection(Object element) {
        this.viewer.setSelection((ISelection)new StructuredSelection(element));
    }

    private void registerContributedEditors() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("editor".equals(el.getName())) {
                try {
                    IEditorDescriptor desc = (IEditorDescriptor)el.createExecutableExtension("descriptorClass");
                    EClass eClass = desc.getEClass();
                    IContributionFactory fact = (IContributionFactory)this.context.get(IContributionFactory.class);
                    AbstractComponentEditor editor = (AbstractComponentEditor)fact.create("bundleclass://" + el.getContributor().getName() + "/" + desc.getEditorClass().getName(), this.context);
                    this.registerEditor(eClass, editor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void registerContributedEditorTabs() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("editorTab".equals(el.getName())) {
                try {
                    Object o = el.createExecutableExtension("contribution");
                    if (o instanceof AbstractElementEditorContribution) {
                        AbstractElementEditorContribution contribution = (AbstractElementEditorContribution)o;
                        ContextInjectionFactory.inject((Object)contribution, (IEclipseContext)this.context);
                        Class<?> contribElem = contribution.getContributableTo();
                        if (contribElem != null) {
                            if (!this.tabContributions.containsKey(contribElem)) {
                                this.tabContributions.put(contribElem, new ArrayList());
                            }
                            List<AbstractElementEditorContribution> res = this.tabContributions.get(contribElem);
                            res.add(contribution);
                        }
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public List<AbstractElementEditorContribution> getTabContributionsForClass(Class<?> clazz) {
        ArrayList<AbstractElementEditorContribution> ret = new ArrayList<AbstractElementEditorContribution>();
        for (Class<?> clasz : this.tabContributions.keySet()) {
            if (!clasz.isAssignableFrom(clazz)) continue;
            ret.addAll((Collection<AbstractElementEditorContribution>)this.tabContributions.get(clasz));
        }
        return ret;
    }

    private void registerDefaultEditors() {
        this.registerEditor(ApplicationPackageImpl.Literals.APPLICATION, ApplicationEditor.class);
        this.registerEditor(ApplicationPackageImpl.Literals.ADDON, AddonsEditor.class);
        this.registerEditor(CommandsPackageImpl.Literals.KEY_BINDING, KeyBindingEditor.class);
        this.registerEditor(CommandsPackageImpl.Literals.HANDLER, HandlerEditor.class);
        this.registerEditor(CommandsPackageImpl.Literals.COMMAND, CommandEditor.class);
        this.registerEditor(CommandsPackageImpl.Literals.COMMAND_PARAMETER, CommandParameterEditor.class);
        this.registerEditor(CommandsPackageImpl.Literals.PARAMETER, ParameterEditor.class);
        this.registerEditor(CommandsPackageImpl.Literals.BINDING_TABLE, BindingTableEditor.class);
        this.registerEditor(CommandsPackageImpl.Literals.BINDING_CONTEXT, BindingContextEditor.class);
        this.registerEditor(CommandsPackageImpl.Literals.CATEGORY, CategoryEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.TOOL_BAR, ToolBarEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.DIRECT_TOOL_ITEM, DirectToolItemEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.HANDLED_TOOL_ITEM, HandledToolItemEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.TOOL_BAR_SEPARATOR, ToolBarSeparatorEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.TOOL_CONTROL, ToolControlEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.MENU, MenuEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.POPUP_MENU, PopupMenuEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.MENU_SEPARATOR, MenuSeparatorEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.HANDLED_MENU_ITEM, HandledMenuItemEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.DIRECT_MENU_ITEM, DirectMenuItemEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.MENU_CONTRIBUTION, MenuContributionEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.TOOL_BAR_CONTRIBUTION, ToolBarContributionEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.TRIM_CONTRIBUTION, TrimContributionEditor.class);
        this.registerEditor(MenuPackageImpl.Literals.DYNAMIC_MENU_CONTRIBUTION, DynamicMenuContributionEditor.class);
        this.registerEditor(UiPackageImpl.Literals.CORE_EXPRESSION, CoreExpressionEditor.class);
        this.registerEditor(UiPackageImpl.Literals.IMPERATIVE_EXPRESSION, ImperativeExpressionEditor.class);
        this.registerEditor(BasicPackageImpl.Literals.COMPOSITE_PART, CompositePartEditor.class);
        this.registerEditor(BasicPackageImpl.Literals.PART, PartEditor.class);
        this.registerEditor(BasicPackageImpl.Literals.WINDOW, WindowEditor.class);
        this.registerEditor(BasicPackageImpl.Literals.TRIMMED_WINDOW, TrimmedWindowEditor.class);
        this.registerEditor(BasicPackageImpl.Literals.PART_SASH_CONTAINER, PartSashContainerEditor.class);
        this.registerEditor(AdvancedPackageImpl.Literals.AREA, AreaEditor.class);
        this.registerEditor(BasicPackageImpl.Literals.PART_STACK, PartStackEditor.class);
        this.registerEditor(BasicPackageImpl.Literals.TRIM_BAR, TrimBarEditor.class);
        this.registerEditor(BasicPackageImpl.Literals.PART_DESCRIPTOR, PartDescriptorEditor.class);
        this.registerEditor(AdvancedPackageImpl.Literals.PERSPECTIVE_STACK, PerspectiveStackEditor.class);
        this.registerEditor(AdvancedPackageImpl.Literals.PERSPECTIVE, PerspectiveEditor.class);
        this.registerEditor(AdvancedPackageImpl.Literals.PLACEHOLDER, PlaceholderEditor.class);
        this.registerEditor(FragmentPackageImpl.Literals.MODEL_FRAGMENTS, ModelFragmentsEditor.class);
        this.registerEditor(FragmentPackageImpl.Literals.STRING_MODEL_FRAGMENT, StringModelFragment.class);
    }

    public void tabListShow(Boolean show) {
        if (this.editorTabFolder == null) {
            return;
        }
        if (!show.booleanValue()) {
            if (this.listTab != null) {
                this.listTab.getTabItem().dispose();
                ContextInjectionFactory.uninject((Object)this.listTab, (IEclipseContext)this.listTab.getContext());
                this.listTab = null;
            }
        } else if (this.listTab == null) {
            IEclipseContext child = this.context.createChild();
            child.set(CTabFolder.class, (Object)this.editorTabFolder);
            child.set(EMFDocumentResourceMediator.class, (Object)this.emfDocumentProvider);
            child.set(IGotoObject.class, (Object)this);
            child.set(Messages.class, (Object)this.messages);
            this.listTab = (ListTab)ContextInjectionFactory.make(ListTab.class, (IEclipseContext)child);
            this.tabItemList = this.listTab.getTabItem();
        }
    }

    @Inject
    public void setNotVisibleColor(@Preference(value="notVisibleColor") String color) {
        RGB current = JFaceResources.getColorRegistry().getRGB("NOT_VISIBLE_KEY");
        if (current == null || !current.equals((Object)color)) {
            JFaceResources.getColorRegistry().put("NOT_VISIBLE_KEY", StringConverter.asRGB((String)color, (RGB)new RGB(200, 200, 200)));
        }
        if (this.viewer != null) {
            this.viewer.refresh();
            this.viewer.getControl().redraw();
        }
    }

    @Inject
    public void setNotRenderedColor(@Preference(value="notRenderedColor") String color) {
        RGB current = JFaceResources.getColorRegistry().getRGB("NOT_RENDERED_STYLER");
        if (current == null || !current.equals((Object)color)) {
            JFaceResources.getColorRegistry().put("NOT_RENDERED_STYLER", StringConverter.asRGB((String)color, (RGB)new RGB(200, 200, 200)));
        }
        if (this.viewer != null) {
            this.viewer.refresh();
            this.viewer.getControl().redraw();
        }
    }

    @Inject
    public void setNotVisibleRenderedColor(@Preference(value="notVisibleAndRenderedColor") String color) {
        RGB current = JFaceResources.getColorRegistry().getRGB("NOT_VISIBLE_AND_RENDERED_KEY");
        if (current == null || !current.equals((Object)color)) {
            JFaceResources.getColorRegistry().put("NOT_VISIBLE_AND_RENDERED_KEY", StringConverter.asRGB((String)color, (RGB)new RGB(200, 200, 200)));
        }
        if (this.viewer != null) {
            this.viewer.refresh();
            this.viewer.getControl().redraw();
        }
    }

    private void registerEditor(EClass eClass, Class<? extends AbstractComponentEditor> clazz) {
        this.registerEditor(eClass.getInstanceClassName(), clazz);
    }

    private void registerEditor(String key, Class<? extends AbstractComponentEditor> clazz) {
        this.editorsClasses.put(key, clazz);
    }

    private void registerEditor(String key, AbstractComponentEditor editor) {
        this.editors.put(key, editor);
    }

    public AbstractComponentEditor getEditor(EClass eClass) {
        AbstractComponentEditor editor = this.getEditor(eClass.getInstanceClassName(), false);
        if (editor == null) {
            for (EClass cl : eClass.getESuperTypes()) {
                editor = this.getEditor(cl);
                if (editor != null) break;
            }
            if (editor == null) {
                editor = (AbstractComponentEditor)ContextInjectionFactory.make(DefaultEditor.class, (IEclipseContext)this.context);
            }
            this.editors.put(eClass.getInstanceClassName(), editor);
        }
        return editor;
    }

    public AbstractComponentEditor getEditor(String key) {
        return this.getEditor(key, true);
    }

    private AbstractComponentEditor getEditor(String key, boolean createDefaultIfNull) {
        Class<? extends AbstractComponentEditor> cz;
        AbstractComponentEditor editor = this.editors.get(key);
        if (editor == null && (cz = this.editorsClasses.get(key)) != null) {
            editor = (AbstractComponentEditor)ContextInjectionFactory.make(cz, (IEclipseContext)this.context);
            this.editors.put(key, editor);
            this.manageFeatureMap(editor);
        }
        return editor;
    }

    private void manageFeatureMap(AbstractComponentEditor editor) {
        FeaturePath[] featurePathArray = editor.getLabelProperties();
        int n = featurePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeaturePath p = featurePathArray[n2];
            boolean found = false;
            for (FeaturePath tmp : this.labelFeaturePaths) {
                if (!this.equalsPaths(p, tmp)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.labelFeaturePaths.add(p);
            }
            ++n2;
        }
    }

    public void registerEditor(EClass eClass, AbstractComponentEditor editor) {
        this.editors.put(eClass.getInstanceClassName(), editor);
        this.manageFeatureMap(editor);
    }

    private boolean equalsPaths(FeaturePath p1, FeaturePath p2) {
        if (p1.getFeaturePath().length == p2.getFeaturePath().length) {
            int i = 0;
            while (i < p1.getFeaturePath().length) {
                if (!p1.getFeaturePath()[i].equals(p2.getFeaturePath()[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Persist
    public void doSave(@Optional IProgressMonitor monitor) {
        try {
            this.setSaving(true);
            if (this.modelProvider.isSaveable()) {
                this.modelProvider.save();
            }
        }
        finally {
            this.setSaving(false);
        }
    }

    private void setSaving(boolean saving) {
        this.saving = saving;
    }

    protected boolean isSaving() {
        return this.saving;
    }

    @Focus
    public void setFocus() {
        if (this.clipboardHandler == null) {
            this.clipboardHandler = new ClipboardHandler();
        }
        if (this.clipboardService != null) {
            this.clipboardService.setHandler(this.clipboardHandler);
        }
    }

    public void setHeaderTitle(String title) {
        this.sectionHeaderLabel.setText(title);
    }

    @PreDestroy
    void dispose() {
        try {
            this.obsManager.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.project == null) {
            ((Display)this.context.get(Display.class)).removeFilter(4, this.keyListener);
        }
        ContextInjectionFactory.uninject((Object)((Object)this.xmiTab), (IEclipseContext)this.xmiTab.getContext());
    }

    public IModelResource getModelProvider() {
        return this.modelProvider;
    }

    private boolean isValidTarget(Object target, Object instance, boolean isIndex) {
        if (target instanceof MElementContainer) {
            MElementContainer container = (MElementContainer)target;
            if (isIndex || !container.getChildren().contains(instance)) {
                EClassifier classifier = ModelUtils.getTypeArgument((EClass)((EObject)container).eClass(), (EGenericType)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN.getEGenericType());
                return classifier.isInstance(instance);
            }
        } else if (target instanceof VirtualEntry) {
            VirtualEntry vTarget = (VirtualEntry)target;
            if ((isIndex || !vTarget.getList().contains(instance)) && vTarget.getProperty() instanceof IEMFProperty) {
                EStructuralFeature feature = ((IEMFProperty)vTarget.getProperty()).getStructuralFeature();
                EObject parent = (EObject)vTarget.getOriginalParent();
                EClassifier classifier = ModelUtils.getTypeArgument((EClass)parent.eClass(), (EGenericType)feature.getEGenericType());
                return classifier.isInstance(instance);
            }
        } else if (target instanceof EObject) {
            EObject eObj = (EObject)target;
            for (EStructuralFeature f : eObj.eClass().getEAllStructuralFeatures()) {
                EClassifier cl = ModelUtils.getTypeArgument((EClass)eObj.eClass(), (EGenericType)f.getEGenericType());
                if (!cl.isInstance(instance)) continue;
                return true;
            }
        }
        return false;
    }

    private String getObjectNameForCommand(Object data) {
        String clname = data instanceof ApplicationElementImpl ? ((ApplicationElementImpl)data).eClass().getName() : "Object";
        String dname = data instanceof MUILabel ? ((MUILabel)data).getLabel() : "";
        return String.valueOf(clname) + " " + dname;
    }

    @Override
    public void gotoEObject(int targetHint, EObject object) {
        if (object != null) {
            switch (targetHint) {
                case 0: {
                    ObservableListTreeContentProvider provider = (ObservableListTreeContentProvider)this.viewer.getContentProvider();
                    this.getFirstMatchingItem(object, provider, provider.getChildren(this.viewer.getInput()));
                    this.viewer.reveal((Object)object);
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)object));
                    this.editorTabFolder.setSelection(ModelEditor.getTabIndex(this.tabItemTree));
                    break;
                }
                case 1: {
                    this.editorTabFolder.setSelection(ModelEditor.getTabIndex(this.tabItemXmi));
                    this.emfDocumentProvider.updateFromEMF();
                    try {
                        this.xmiTab.gotoEObject(object);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    if (this.tabItemList == null || this.listTab == null) break;
                    this.editorTabFolder.setSelection(ModelEditor.getTabIndex(this.tabItemList));
                    this.listTab.getViewer().setSelection((ISelection)new StructuredSelection((Object)object), true);
                    break;
                }
            }
        }
    }

    private Object getFirstMatchingItem(EObject target, ObservableListTreeContentProvider provider, Object[] items) {
        int i = 0;
        while (i < items.length) {
            if (items[i] == target) {
                return items[i];
            }
            Object found = this.getFirstMatchingItem(target, provider, provider.getChildren(items[i]));
            if (found != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    @Inject
    @Optional
    public void refreshOnSave(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*") Event event, @Named(value="e4ActivePart") MPart part) {
        if (part != this.currentPart) {
            return;
        }
        Object type = event.getProperty("EventType");
        Object newValue = event.getProperty("NewValue");
        if ("SET".equals(type) && Boolean.FALSE.equals(newValue) && this.viewer != null) {
            this.viewer.refresh(true);
        }
    }

    class ClipboardHandler
    implements IClipboardService.Handler {
        ClipboardHandler() {
        }

        public void paste() {
            if (ModelEditor.this.editorTabFolder.getSelectionIndex() == 0) {
                if (ModelEditor.this.viewer.getControl().getDisplay().getFocusControl() == ModelEditor.this.viewer.getControl()) {
                    this.handleStructurePaste();
                } else if (ModelEditor.this.currentEditor != null) {
                    ModelEditor.this.currentEditor.handlePaste();
                }
            } else {
                ModelEditor.this.xmiTab.paste();
            }
        }

        private void handleStructurePaste() {
            EStructuralFeature targetFeature;
            MStringModelFragment stringModelFragment;
            EClass targetType;
            Clipboard clip = new Clipboard(ModelEditor.this.viewer.getControl().getDisplay());
            Object contents = clip.getContents((Transfer)MemoryTransfer.getInstance());
            clip.dispose();
            if (contents == null) {
                return;
            }
            ArrayList<EObject> toCopy = new ArrayList<EObject>();
            if (contents instanceof EObject) {
                toCopy.add(EcoreUtil.copy((EObject)((EObject)contents)));
            } else if (contents instanceof List) {
                List list = (List)contents;
                for (Object object : list) {
                    if (!(object instanceof EObject)) continue;
                    toCopy.add(EcoreUtil.copy((EObject)((EObject)object)));
                }
            }
            if (toCopy.isEmpty()) {
                return;
            }
            Object parent = ((IStructuredSelection)ModelEditor.this.viewer.getSelection()).getFirstElement();
            EObject probe = (EObject)toCopy.get(0);
            EStructuralFeature feature = null;
            EObject container = null;
            if (parent instanceof VirtualEntry) {
                VirtualEntry v = (VirtualEntry)parent;
                feature = ((IEMFProperty)v.getProperty()).getStructuralFeature();
                container = (EObject)v.getOriginalParent();
            } else if (parent instanceof EObject) {
                container = (EObject)parent;
                if (container instanceof MElementContainer) {
                    feature = UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN;
                } else {
                    feature = this.determineTargetFeature(probe, container);
                    if (feature == null && container.eClass().equals(probe.eClass()) && container.eContainer() != null) {
                        container = container.eContainer();
                        feature = this.determineTargetFeature(probe, container);
                    }
                }
            }
            if (container == null) {
                return;
            }
            if (feature == null) {
                return;
            }
            ArrayList<EClass> targetChildrenClasses = new ArrayList<EClass>();
            if (container instanceof MStringModelFragment && (targetType = StringModelFragment.findContainerType(stringModelFragment = (MStringModelFragment)container)) != null && (targetFeature = targetType.getEStructuralFeature(stringModelFragment.getFeaturename())) != null) {
                List<IEditorFeature.FeatureClass> classes = StringModelFragment.getTargetChildrenClasses(targetType, targetFeature.getName());
                for (IEditorFeature.FeatureClass fclass : classes) {
                    targetChildrenClasses.add(fclass.eClass);
                }
            }
            CompoundCommand cc = new CompoundCommand();
            EObject pastedObject = null;
            for (EObject eObject : toCopy) {
                if (!ModelEditor.this.isValidTarget(parent, eObject, false) || !targetChildrenClasses.isEmpty() && !targetChildrenClasses.contains(eObject.eClass())) continue;
                if (feature == FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS) {
                    MApplicationElement el = (MApplicationElement)EcoreUtil.create((EClass)eObject.eClass());
                    el.setElementId(((MApplicationElement)eObject).getElementId());
                    Command cmd = AddCommand.create((EditingDomain)ModelEditor.this.getModelProvider().getEditingDomain(), (Object)container, (Object)feature, (Object)el);
                    if (cmd.canExecute()) {
                        pastedObject = el;
                        cc.append(cmd);
                    }
                    return;
                }
                Command cmd = AddCommand.create((EditingDomain)ModelEditor.this.getModelProvider().getEditingDomain(), (Object)container, (Object)feature, (Object)eObject);
                pastedObject = eObject;
                if (!cmd.canExecute()) continue;
                cc.append(cmd);
                if (!ModelEditor.this.isLiveModel() || !(container instanceof MElementContainer) || !(probe instanceof MUIElement)) continue;
                ((MElementContainer)container).setSelectedElement((MUIElement)eObject);
            }
            if (!cc.isEmpty()) {
                if (cc.getCommandList().size() == 1) {
                    cc.setLabel(String.valueOf(((ModelEditor)ModelEditor.this).messages.ModelEditor_Paste) + " " + ModelEditor.this.getObjectNameForCommand(pastedObject));
                } else {
                    cc.setLabel(((ModelEditor)ModelEditor.this).messages.ModelEditor_PasteObjects);
                }
                ModelEditor.this.getModelProvider().getEditingDomain().getCommandStack().execute((Command)cc);
            }
        }

        private EStructuralFeature determineTargetFeature(EObject probe, EObject container) {
            EClass eClass = container.eClass();
            for (EStructuralFeature f : eClass.getEAllReferences()) {
                if (!ModelUtils.getTypeArgument((EClass)eClass, (EGenericType)f.getEGenericType()).isInstance((Object)probe)) continue;
                return f;
            }
            return null;
        }

        public void copy() {
            if (ModelEditor.this.editorTabFolder.getSelectionIndex() == 0) {
                if (ModelEditor.this.viewer.getControl().getDisplay().getFocusControl() == ModelEditor.this.viewer.getControl()) {
                    this.handleStructureCopy();
                } else if (ModelEditor.this.currentEditor != null) {
                    ModelEditor.this.currentEditor.handleCopy();
                }
            } else {
                ModelEditor.this.xmiTab.copy();
            }
        }

        private void handleStructureCopy() {
            IStructuredSelection structuredSelection = (IStructuredSelection)ModelEditor.this.viewer.getSelection();
            ArrayList<EObject> toCopy = new ArrayList<EObject>();
            for (Object obj : structuredSelection.toList()) {
                if (obj == null || !(obj instanceof EObject)) continue;
                EObject copy = EcoreUtil.copy((EObject)((EObject)obj));
                toCopy.add(copy);
            }
            if (toCopy.isEmpty()) {
                return;
            }
            Clipboard clip = new Clipboard(ModelEditor.this.viewer.getControl().getDisplay());
            clip.setContents(new Object[]{toCopy}, new Transfer[]{MemoryTransfer.getInstance()});
            clip.dispose();
        }

        public void cut() {
            if (ModelEditor.this.editorTabFolder.getSelectionIndex() == 0) {
                if (ModelEditor.this.viewer.getControl().getDisplay().getFocusControl() == ModelEditor.this.viewer.getControl()) {
                    this.handleStructureCut();
                } else if (ModelEditor.this.currentEditor != null) {
                    ModelEditor.this.currentEditor.handleCut();
                }
            } else {
                ModelEditor.this.xmiTab.cut();
            }
        }

        private void handleStructureCut() {
            ArrayList<EObject> objectsToCut = new ArrayList<EObject>();
            Clipboard clip = new Clipboard(ModelEditor.this.viewer.getControl().getDisplay());
            for (Object o : ((IStructuredSelection)ModelEditor.this.viewer.getSelection()).toList()) {
                if (o == null || !(o instanceof EObject)) continue;
                objectsToCut.add((EObject)o);
            }
            Command cmd = null;
            if (objectsToCut.isEmpty()) {
                return;
            }
            if (objectsToCut.size() == 1) {
                EObject o = (EObject)objectsToCut.iterator().next();
                cmd = RemoveCommand.create((EditingDomain)ModelEditor.this.getModelProvider().getEditingDomain(), (Object)o.eContainer(), (Object)o.eContainingFeature(), (Object)o);
                ((AbstractCommand)cmd).setLabel(String.valueOf(((ModelEditor)ModelEditor.this).messages.ModelEditor_Cut) + " " + ModelEditor.this.getObjectNameForCommand(o));
            } else {
                CompoundCommand cc = new CompoundCommand();
                cc.setLabel(((ModelEditor)ModelEditor.this).messages.ModelEditor_CutObjects);
                for (EObject o : objectsToCut) {
                    cc.append(RemoveCommand.create((EditingDomain)ModelEditor.this.getModelProvider().getEditingDomain(), (Object)o.eContainer(), (Object)o.eContainingFeature(), (Object)o));
                }
                cmd = cc;
            }
            if (cmd.canExecute()) {
                clip.setContents(new Object[]{objectsToCut}, new Transfer[]{MemoryTransfer.getInstance()});
                ModelEditor.this.getModelProvider().getEditingDomain().getCommandStack().execute(cmd);
            }
            clip.dispose();
        }
    }

    static class DragListener
    extends DragSourceAdapter {
        private final TreeViewer viewer;

        public DragListener(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void dragStart(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            event.doit = !selection.isEmpty() && (selection.getFirstElement() instanceof MApplicationElement || selection.getFirstElement() instanceof MModelFragment);
        }

        public void dragSetData(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            event.data = selection.toArray();
        }
    }

    class DropListener
    extends ViewerDropAdapter {
        private final EditingDomain domain;

        protected DropListener(Viewer viewer, EditingDomain domain) {
            super(viewer);
            this.domain = domain;
        }

        public boolean performDrop(Object data) {
            Object[] dropDataArray;
            if (!(data instanceof Object[])) {
                return false;
            }
            Object[] objectArray = dropDataArray = (Object[])data;
            int n = dropDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                boolean result = this.performSingleDrop(object);
                if (!result) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public boolean performSingleDrop(Object data) {
            block28: {
                block24: {
                    Command cmd;
                    EObject parent;
                    EReference feature;
                    block26: {
                        block27: {
                            block25: {
                                if (this.getCurrentLocation() != 3) break block24;
                                feature = null;
                                parent = null;
                                if (!(this.getCurrentTarget() instanceof MElementContainer)) break block25;
                                feature = UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN;
                                parent = (EObject)this.getCurrentTarget();
                                break block26;
                            }
                            if (!(this.getCurrentTarget() instanceof VirtualEntry)) break block27;
                            VirtualEntry entry = (VirtualEntry)this.getCurrentTarget();
                            IListProperty prop = entry.getProperty();
                            if (!(prop instanceof IEMFProperty)) break block26;
                            feature = ((IEMFProperty)prop).getStructuralFeature();
                            parent = (EObject)entry.getOriginalParent();
                            break block26;
                        }
                        if (this.getCurrentTarget() instanceof EObject) {
                            parent = (EObject)this.getCurrentTarget();
                            for (EStructuralFeature f : parent.eClass().getEAllStructuralFeatures()) {
                                EClassifier cl = ModelUtils.getTypeArgument((EClass)parent.eClass(), (EGenericType)f.getEGenericType());
                                if (!cl.isInstance(data)) continue;
                                feature = f;
                                break;
                            }
                        }
                    }
                    if (feature != null && parent != null && (cmd = this.createRemoveAddCommand(data, (EStructuralFeature)feature, parent, -1)).canExecute()) {
                        this.domain.getCommandStack().execute(cmd);
                        if (ModelEditor.this.isLiveModel() && parent instanceof MElementContainer && data instanceof MUIElement) {
                            ((MElementContainer)parent).setSelectedElement((MUIElement)data);
                        }
                        return true;
                    }
                    break block28;
                }
                if (this.getCurrentLocation() == 2 || this.getCurrentLocation() == 1) {
                    TreeItem parentItem;
                    EReference feature = null;
                    EObject parent = null;
                    TreeItem item = (TreeItem)this.getCurrentEvent().item;
                    if (item != null && (parentItem = item.getParentItem()) != null) {
                        if (parentItem.getData() instanceof VirtualEntry) {
                            VirtualEntry vE = (VirtualEntry)parentItem.getData();
                            parent = (EObject)vE.getOriginalParent();
                            feature = ((IEMFProperty)vE.getProperty()).getStructuralFeature();
                        } else if (parentItem.getData() instanceof MElementContainer) {
                            parent = (EObject)parentItem.getData();
                            feature = UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN;
                        } else if (parentItem.getData() instanceof EObject) {
                            parent = (EObject)parentItem.getData();
                            for (EStructuralFeature f : parent.eClass().getEAllStructuralFeatures()) {
                                EClassifier cl = ModelUtils.getTypeArgument((EClass)parent.eClass(), (EGenericType)f.getEGenericType());
                                if (!cl.isInstance(data)) continue;
                                feature = f;
                                break;
                            }
                        }
                    }
                    if (feature == FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS && parent != null) {
                        MApplicationElement el = (MApplicationElement)EcoreUtil.create((EClass)((EObject)data).eClass());
                        el.setElementId(((MApplicationElement)data).getElementId());
                        Command cmd = this.createRemoveAddCommand(data, (EStructuralFeature)feature, parent, -1);
                        if (cmd.canExecute()) {
                            this.domain.getCommandStack().execute(cmd);
                        }
                        return true;
                    }
                    if (feature != null && parent != null && parent.eGet(feature) instanceof List) {
                        Command cmd;
                        List list = (List)parent.eGet(feature);
                        int index = list.indexOf(this.getCurrentTarget());
                        if (index >= list.size()) {
                            index = -1;
                        }
                        if (parent == ((EObject)data).eContainer()) {
                            if (parent instanceof MElementContainer && data instanceof MUIElement) {
                                Util.moveElementByIndex(this.domain, (MUIElement)data, ModelEditor.this.isLiveModel(), index);
                            } else {
                                cmd = MoveCommand.create((EditingDomain)this.domain, (Object)parent, (Object)feature, (Object)data, (int)index);
                                if (cmd.canExecute()) {
                                    this.domain.getCommandStack().execute(cmd);
                                    return true;
                                }
                            }
                        } else {
                            if (parent.eResource() != ((EObject)data).eResource()) {
                                data = EcoreUtil.copy((EObject)((EObject)data));
                            }
                            if ((cmd = this.createRemoveAddCommand(data, (EStructuralFeature)feature, parent, index)).canExecute()) {
                                this.domain.getCommandStack().execute(cmd);
                                if (ModelEditor.this.isLiveModel() && parent instanceof MElementContainer && data instanceof MUIElement) {
                                    ((MElementContainer)parent).setSelectedElement((MUIElement)data);
                                }
                                return true;
                            }
                        }
                    }
                }
            }
            return false;
        }

        private Command createRemoveAddCommand(Object data, EStructuralFeature destFeature, EObject parent, int index) {
            Command removeCommand;
            ArrayList<Command> listOfCommands = new ArrayList<Command>();
            EReference sourceFeature = null;
            if (data instanceof EObject) {
                sourceFeature = ((EObject)data).eContainmentFeature();
            }
            if ((removeCommand = RemoveCommand.create((EditingDomain)this.domain, (Object)((EObject)data).eContainer(), (Object)sourceFeature, (Object)data)).canExecute()) {
                listOfCommands.add(removeCommand);
            }
            Command addCommand = AddCommand.create((EditingDomain)this.domain, (Object)parent, (Object)destFeature, (Object)data, (int)index);
            listOfCommands.add(addCommand);
            CompoundCommand compoundCommand = new CompoundCommand(listOfCommands);
            compoundCommand.setLabel(String.valueOf(((ModelEditor)ModelEditor.this).messages.ModelEditor_Move) + " " + ModelEditor.this.getObjectNameForCommand(data));
            return compoundCommand;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            boolean rv = true;
            if (this.getSelectedObject() instanceof MApplicationElement || this.getSelectedObject() instanceof MModelFragment) {
                TreeItem item;
                if (this.getCurrentLocation() == 3) {
                    rv = ModelEditor.this.isValidTarget(target, this.getSelectedObject(), false);
                } else if ((this.getCurrentLocation() == 2 || this.getCurrentLocation() == 1) && (item = (TreeItem)this.getCurrentEvent().item) != null && (item = item.getParentItem()) != null) {
                    rv = ModelEditor.this.isValidTarget(item.getData(), this.getSelectedObject(), true);
                }
            }
            return rv;
        }
    }

    public class ObservableFactoryImpl
    implements IObservableFactory {
        public IObservable createObservable(Object target) {
            if (target instanceof IObservableList) {
                return new WritableList((List)target, Object.class);
            }
            if (target instanceof VirtualEntry) {
                return ((VirtualEntry)target).getList();
            }
            AbstractComponentEditor editor = ModelEditor.this.getEditor(((EObject)target).eClass());
            if (editor != null) {
                return editor.getChildList(target);
            }
            return null;
        }
    }
}

