/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.op.BranchOperation;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.gitflow.Activator;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.AbstractFeatureOperation;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.osgi.util.NLS;

public final class FeatureTrackOperation
extends AbstractFeatureOperation {
    private static final String REMOTE_ORIGIN_FEATURE_PREFIX = "refs/remotes/origin/";
    private Ref remoteFeature;
    private FetchResult operationResult;
    private int timeout;

    public FeatureTrackOperation(GitFlowRepository repository, Ref ref, int timeout) {
        this(repository, ref, ref.getName().substring((REMOTE_ORIGIN_FEATURE_PREFIX + repository.getConfig().getFeaturePrefix()).length()));
        this.timeout = timeout;
    }

    public FeatureTrackOperation(GitFlowRepository repository, Ref ref, String newLocalBranch) {
        super(repository, newLocalBranch);
        this.remoteFeature = ref;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            String newLocalBranch = this.repository.getConfig().getFeatureBranchName(this.featureName);
            this.operationResult = this.fetch((IProgressMonitor)progress.newChild(1), this.timeout);
            if (this.repository.hasBranch(newLocalBranch)) {
                String errorMessage = NLS.bind((String)CoreText.FeatureTrackOperation_localBranchExists, (Object)newLocalBranch);
                throw new CoreException(Activator.error(errorMessage));
            }
            CreateLocalBranchOperation createLocalBranchOperation = new CreateLocalBranchOperation(this.repository.getRepository(), newLocalBranch, this.remoteFeature, BranchConfig.BranchRebaseMode.NONE);
            createLocalBranchOperation.execute((IProgressMonitor)progress.newChild(1));
            BranchOperation branchOperation = new BranchOperation(this.repository.getRepository(), newLocalBranch);
            branchOperation.execute((IProgressMonitor)progress.newChild(1));
            CheckoutResult result = branchOperation.getResult();
            if (!CheckoutResult.Status.OK.equals((Object)result.getStatus())) {
                String errorMessage = NLS.bind((String)CoreText.FeatureTrackOperation_checkoutReturned, (Object)newLocalBranch, (Object)result.getStatus().name());
                throw new CoreException(Activator.error(errorMessage));
            }
            try {
                this.repository.setRemote(newLocalBranch, "origin");
                this.repository.setUpstreamBranchName(newLocalBranch, this.repository.getConfig().getFullFeatureBranchName(this.featureName));
            }
            catch (IOException e) {
                throw new CoreException(Activator.error(CoreText.FeatureTrackOperation_unableToStoreGitConfig, e));
            }
        }
        catch (URISyntaxException e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new CoreException(Activator.error(targetException.getMessage(), targetException));
        }
        catch (GitAPIException e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
    }

    public FetchResult getOperationResult() {
        return this.operationResult;
    }
}

