/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.DeleteBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.BranchSelectionDialog;
import org.eclipse.egit.ui.internal.dialogs.UnmergedBranchDialog;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

public class DeleteBranchOnCommitHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        UnmergedBranchDialog messageDialog;
        List<Ref> branchesToDelete;
        List<Ref> branchesOfCommit;
        int totalBranchCount;
        final Repository repository = this.getRepository(event);
        if (repository == null) {
            return null;
        }
        IStructuredSelection selection = this.getSelection(event);
        try {
            totalBranchCount = this.getBranchesOfCommit(selection, repository, false).size();
            branchesOfCommit = this.getBranchesOfCommit(selection, repository, true);
        }
        catch (IOException e) {
            throw new ExecutionException(UIText.AbstractHistoryCommitHandler_cantGetBranches, (Throwable)e);
        }
        if (branchesOfCommit.isEmpty()) {
            return null;
        }
        final ArrayList unmergedBranches = new ArrayList();
        Shell shell = this.getPart(event).getSite().getShell();
        if (totalBranchCount > 1) {
            BranchSelectionDialog<Ref> dlg = new BranchSelectionDialog<Ref>(shell, branchesOfCommit, UIText.DeleteBranchOnCommitHandler_DeleteBranchesDialogTitle, UIText.DeleteBranchOnCommitHandler_DeleteBranchesDialogMessage, UIText.DeleteBranchOnCommitHandler_DeleteBranchesDialogButton, 2);
            if (dlg.open() != 0) {
                return null;
            }
            branchesToDelete = dlg.getSelectedNodes();
        } else {
            branchesToDelete = branchesOfCommit;
        }
        try {
            new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(UIText.DeleteBranchCommand_DeletingBranchesProgress, branchesToDelete.size());
                            for (Ref refNode : branchesToDelete) {
                                int result = DeleteBranchOnCommitHandler.this.deleteBranch(repository, refNode, false);
                                if (result == 1) {
                                    throw new CoreException(Activator.createErrorStatus(UIText.DeleteBranchCommand_CannotDeleteCheckedOutBranch, null));
                                }
                                if (result == 2) {
                                    unmergedBranches.add(refNode);
                                    continue;
                                }
                                monitor.worked(1);
                            }
                        }
                        catch (CoreException ex) {
                            throw new InvocationTargetException(ex);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            Activator.handleError(UIText.RepositoriesView_BranchDeletionFailureMessage, e1.getCause(), true);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        if (!unmergedBranches.isEmpty() && (messageDialog = new UnmergedBranchDialog(shell, unmergedBranches)).open() == 0) {
            try {
                new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                monitor.beginTask(UIText.DeleteBranchCommand_DeletingBranchesProgress, unmergedBranches.size());
                                for (Ref node : unmergedBranches) {
                                    DeleteBranchOnCommitHandler.this.deleteBranch(repository, node, true);
                                    monitor.worked(1);
                                }
                            }
                            catch (CoreException ex) {
                                throw new InvocationTargetException(ex);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e1) {
                Activator.handleError(UIText.RepositoriesView_BranchDeletionFailureMessage, e1.getCause(), true);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    private int deleteBranch(Repository repo, Ref ref, boolean force) throws CoreException {
        DeleteBranchOperation dbop = new DeleteBranchOperation(repo, ref, force);
        dbop.execute(null);
        return dbop.getStatus();
    }

    public boolean isEnabled() {
        List<Ref> branchesOfCommit;
        GitHistoryPage page = this.getPage();
        Repository repository = this.getRepository(page);
        if (repository == null) {
            return false;
        }
        try {
            branchesOfCommit = this.getBranchesOfCommit(this.getSelection(page), repository, true);
        }
        catch (IOException e) {
            Activator.logError(UIText.AbstractHistoryCommitHandler_cantGetBranches, e);
            return false;
        }
        return !branchesOfCommit.isEmpty();
    }
}

