/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.AbstractActionProvider;
import org.eclipse.emf.cdo.internal.ui.dialogs.AbstractBranchPointDialog;
import org.eclipse.emf.cdo.internal.ui.dialogs.SelectCommitDialog;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBranchPointActionProvider
extends AbstractActionProvider<CDOCheckout> {
    private static final ImageDescriptor CHECKOUT_IMAGE_DESCRIPTOR = OM.getImageDescriptor("icons/checkout.gif");
    private static final ImageDescriptor CHECKOUT_CLOSED_IMAGE_DESCRIPTOR = OM.getImageDescriptor("icons/checkout_closed.gif");

    public AbstractBranchPointActionProvider(String id, String title) {
        super(CDOCheckout.class, id, title, "additions");
    }

    protected boolean createSubMenu(CDOCheckout checkout) {
        return checkout.isOpen();
    }

    @Override
    protected final boolean fillSubMenu(ICommonViewerWorkbenchSite viewSite, IMenuManager subMenu, CDOCheckout checkout) {
        if (this.createSubMenu(checkout)) {
            IWorkbenchPage page = viewSite.getPage();
            subMenu.add((IContributionItem)new Separator("top"));
            this.fillSubMenu(page, subMenu, checkout);
            return true;
        }
        return false;
    }

    protected void fillSubMenu(IWorkbenchPage page, IMenuManager subMenu, CDOCheckout checkout) {
        CDOBranchPoint checkoutBranchPoint = checkout.getBranchPoint();
        CDORepository repository = checkout.getRepository();
        if (repository.isConnected()) {
            subMenu.add((IContributionItem)new Separator("history"));
            CDOBranchPoint[] cDOBranchPointArray = checkout.getBranchPoints();
            int n = cDOBranchPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOBranchPoint branchPoint = cDOBranchPointArray[n2];
                if (!ObjectUtil.equals((Object)branchPoint, (Object)checkoutBranchPoint)) {
                    this.fillHistorizedAction(page, subMenu, checkout, branchPoint);
                }
                ++n2;
            }
            subMenu.add((IContributionItem)new Separator("other"));
            this.fillOtherBranchAction(page, subMenu, checkout);
            this.fillOtherBranchPointAction(page, subMenu, checkout);
            subMenu.add((IContributionItem)new Separator("commit"));
            this.fillCommitAction(page, subMenu, checkout);
            subMenu.add((IContributionItem)new Separator("checkout"));
            cDOBranchPointArray = CDOExplorerUtil.getCheckoutManager().getCheckouts();
            n = cDOBranchPointArray.length;
            n2 = 0;
            while (n2 < n) {
                CDOBranchPoint otherCheckout = cDOBranchPointArray[n2];
                if (otherCheckout != checkout && otherCheckout.getRepository() == repository && (otherCheckout.getBranchID() != checkout.getBranchID() || otherCheckout.getTimeStamp() != checkout.getTimeStamp())) {
                    this.fillOtherCheckoutAction(page, subMenu, checkout, (CDOCheckout)otherCheckout);
                }
                ++n2;
            }
        }
    }

    protected void fillHistorizedAction(IWorkbenchPage page, IMenuManager subMenu, CDOCheckout checkout, CDOBranchPoint branchPoint) {
        subMenu.add((IAction)new HistorizedBranchPointAction(page, checkout, branchPoint));
    }

    protected void fillOtherBranchAction(IWorkbenchPage page, IMenuManager subMenu, CDOCheckout checkout) {
        subMenu.add((IAction)new OtherBranchPointAction(page, checkout, false));
    }

    protected void fillOtherBranchPointAction(IWorkbenchPage page, IMenuManager subMenu, CDOCheckout checkout) {
        subMenu.add((IAction)new OtherBranchPointAction(page, checkout, true));
    }

    protected void fillCommitAction(IWorkbenchPage page, IMenuManager subMenu, CDOCheckout checkout) {
        subMenu.add((IAction)new CommitBranchPointAction(page, checkout));
    }

    protected void fillOtherCheckoutAction(IWorkbenchPage page, IMenuManager subMenu, CDOCheckout checkout, CDOCheckout otherCheckout) {
        subMenu.add((IAction)new OtherCheckoutAction(page, checkout, otherCheckout));
    }

    protected abstract String getHistorizedBranchPointToolTip(boolean var1);

    protected abstract String getOtherBranchPointToolTip(boolean var1);

    protected abstract String getCommitBranchPointToolTip();

    protected abstract String getOtherCheckoutToolTip();

    protected abstract void execute(CDOCheckout var1, CDOBranchPoint var2) throws Exception;

    private final class CommitBranchPointAction
    extends LongRunningAction {
        private final CDOCheckout checkout;
        private CDOCommitInfo commitInfo;

        public CommitBranchPointAction(IWorkbenchPage page, CDOCheckout checkout) {
            super(page, "Commit...", SharedIcons.getDescriptor((String)"obj16/commit.gif"));
            this.checkout = checkout;
            this.setToolTipText(AbstractBranchPointActionProvider.this.getCommitBranchPointToolTip());
        }

        protected void preRun() throws Exception {
            CDORepository repository = this.checkout.getRepository();
            CDOSession session = repository.acquireSession();
            SelectCommitDialog dialog = new SelectCommitDialog(this.getPage(), session);
            if (dialog.open() == 0) {
                this.commitInfo = dialog.getCommitInfo();
                return;
            }
            repository.releaseSession();
            this.cancel();
        }

        protected void doRun(IProgressMonitor progressMonitor) throws Exception {
            try {
                AbstractBranchPointActionProvider.this.execute(this.checkout, (CDOBranchPoint)this.commitInfo);
            }
            finally {
                this.checkout.getRepository().releaseSession();
            }
        }
    }

    private final class HistorizedBranchPointAction
    extends LongRunningAction {
        private final CDOCheckout checkout;
        private final CDOBranchPoint branchPoint;

        public HistorizedBranchPointAction(IWorkbenchPage page, CDOCheckout checkout, CDOBranchPoint branchPoint) {
            super(page);
            this.checkout = checkout;
            this.branchPoint = branchPoint;
            String text = branchPoint.getBranch().getPathName();
            long timeStamp = branchPoint.getTimeStamp();
            if (timeStamp != 0L) {
                this.setText(String.valueOf(text) + "  [" + CDOCommonUtil.formatTimeStamp((long)timeStamp) + "]");
                this.setToolTipText(AbstractBranchPointActionProvider.this.getHistorizedBranchPointToolTip(true));
                this.setImageDescriptor(SharedIcons.getDescriptor((String)"obj16/branchpoint.gif"));
            } else {
                this.setText(text);
                this.setToolTipText(AbstractBranchPointActionProvider.this.getHistorizedBranchPointToolTip(false));
                this.setImageDescriptor(SharedIcons.getDescriptor((String)"obj16/branch.gif"));
            }
        }

        protected void doRun(IProgressMonitor progressMonitor) throws Exception {
            AbstractBranchPointActionProvider.this.execute(this.checkout, this.branchPoint);
        }
    }

    private final class OtherBranchPointAction
    extends LongRunningAction {
        private final CDOCheckout checkout;
        private boolean allowTimeStamp;
        private CDOBranchPoint branchPoint;

        public OtherBranchPointAction(IWorkbenchPage page, CDOCheckout checkout, boolean allowTimeStamp) {
            super(page);
            this.checkout = checkout;
            this.allowTimeStamp = allowTimeStamp;
            if (allowTimeStamp) {
                this.setText("Other Branch Point...");
                this.setImageDescriptor(SharedIcons.getDescriptor((String)"obj16/branchpoint.gif"));
            } else {
                this.setText("Other Branch...");
                this.setImageDescriptor(SharedIcons.getDescriptor((String)"obj16/branch.gif"));
            }
            this.setToolTipText(AbstractBranchPointActionProvider.this.getOtherBranchPointToolTip(allowTimeStamp));
        }

        protected void preRun() throws Exception {
            Shell shell = this.getShell();
            CDOView view = this.checkout.getView();
            this.branchPoint = AbstractBranchPointDialog.select((Shell)shell, (boolean)this.allowTimeStamp, (CDOBranchPoint)view);
            if (this.branchPoint == null) {
                this.cancel();
            }
        }

        protected void doRun(IProgressMonitor progressMonitor) throws Exception {
            this.checkout.setBranchPoint(this.branchPoint);
        }
    }

    private final class OtherCheckoutAction
    extends LongRunningAction {
        private final CDOCheckout checkout;
        private CDOBranchPoint branchPoint;

        public OtherCheckoutAction(IWorkbenchPage page, CDOCheckout checkout, CDOCheckout otherCheckout) {
            super(page);
            this.checkout = checkout;
            this.branchPoint = checkout.getBranchPoint(otherCheckout);
            String text = String.valueOf(otherCheckout.getLabel()) + "  -  " + this.branchPoint.getBranch().getPathName();
            long timeStamp = this.branchPoint.getTimeStamp();
            if (timeStamp != 0L) {
                text = String.valueOf(text) + "  [" + CDOCommonUtil.formatTimeStamp((long)timeStamp) + "]";
            }
            this.setText(text);
            this.setToolTipText(AbstractBranchPointActionProvider.this.getOtherCheckoutToolTip());
            if (otherCheckout.isOpen()) {
                this.setImageDescriptor(CHECKOUT_IMAGE_DESCRIPTOR);
            } else {
                this.setImageDescriptor(CHECKOUT_CLOSED_IMAGE_DESCRIPTOR);
            }
        }

        protected void doRun(IProgressMonitor progressMonitor) throws Exception {
            AbstractBranchPointActionProvider.this.execute(this.checkout, this.branchPoint);
        }
    }
}

