/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.admin.wizards;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.ui.internal.admin.StoreType;
import org.eclipse.emf.cdo.ui.internal.admin.messages.Messages;
import org.eclipse.emf.cdo.ui.internal.admin.wizards.AbstractCreateRepositoryWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateRepositoryStorePage
extends AbstractCreateRepositoryWizardPage {
    private static final String TITLE_PATTERN = Messages.CreateRepositoryStorePage_1;
    private Text storePathText;
    private Text connectionKeepAlivePeriodText;
    private Text readerPoolCapacityText;
    private Text writerPoolCapacityText;
    private StoreType storeType;

    public CreateRepositoryStorePage(String pageName) {
        super(pageName);
        this.setTitle(TITLE_PATTERN);
        this.setMessage(Messages.CreateRepositoryStorePage_2);
    }

    @AbstractCreateRepositoryWizardPage.Subscribe
    public void setStoreType(StoreType storeType) {
        this.storeType = storeType;
        this.setTitle(MessageFormat.format(TITLE_PATTERN, storeType.getName()));
    }

    @Override
    protected void createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)UIUtil.createGridData());
        composite.setLayout((Layout)new GridLayout());
        Group general = this.group(composite, Messages.CreateRepositoryStorePage_3);
        this.storePathText = this.text((Composite)general, Messages.CreateRepositoryStorePage_0);
        Group performance = this.group(composite, Messages.CreateRepositoryStorePage_4);
        this.connectionKeepAlivePeriodText = this.text((Composite)performance, Messages.CreateRepositoryStorePage_5);
        this.readerPoolCapacityText = this.text((Composite)performance, Messages.CreateRepositoryStorePage_6);
        this.writerPoolCapacityText = this.text((Composite)performance, Messages.CreateRepositoryStorePage_7);
    }

    @Override
    protected void hookListeners(Listener updateListener) {
        this.storePathText.addListener(24, updateListener);
        this.connectionKeepAlivePeriodText.addListener(24, updateListener);
        this.readerPoolCapacityText.addListener(24, updateListener);
        this.writerPoolCapacityText.addListener(24, updateListener);
    }

    @Override
    protected void updateEnablement(boolean firstTime) {
        boolean storePathOK;
        boolean bl = storePathOK = !StringUtil.isEmpty((String)this.text(this.storePathText));
        if (firstTime) {
            this.setPageComplete(storePathOK);
            return;
        }
        if (!storePathOK) {
            this.setErrorMessage(Messages.CreateRepositoryStorePage_8);
            this.setPageComplete(false);
            return;
        }
        String keepAlive = this.text(this.connectionKeepAlivePeriodText);
        String readerPool = this.text(this.readerPoolCapacityText);
        String writerPool = this.text(this.writerPoolCapacityText);
        if (StringUtil.isEmpty((String)keepAlive)) {
            this.setErrorMessage(Messages.CreateRepositoryStorePage_9);
            this.setPageComplete(false);
            return;
        }
        if (!this.positiveInteger(keepAlive)) {
            this.setErrorMessage(Messages.CreateRepositoryStorePage_10);
            this.setPageComplete(false);
            return;
        }
        if (!StringUtil.isEmpty((String)readerPool) && !this.positiveInteger(readerPool)) {
            this.setErrorMessage(Messages.CreateRepositoryStorePage_11);
            this.setPageComplete(false);
            return;
        }
        if (!StringUtil.isEmpty((String)writerPool) && !this.positiveInteger(writerPool)) {
            this.setErrorMessage(Messages.CreateRepositoryStorePage_12);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    @Override
    protected void loadSettings(IDialogSettings pageSettings) {
        this.connectionKeepAlivePeriodText.setText(this.getSetting(pageSettings, "connectionKeepAlivePeriod", "60"));
        this.readerPoolCapacityText.setText(this.getSetting(pageSettings, "readerPoolCapacity", "15"));
        this.writerPoolCapacityText.setText(this.getSetting(pageSettings, "writerPoolCapacity", "15"));
    }

    @Override
    protected void saveSettings(IDialogSettings pageSettings) {
        pageSettings.put("connectionKeepAlivePeriod", this.text(this.connectionKeepAlivePeriodText));
        pageSettings.put("readerPoolCapacity", this.text(this.readerPoolCapacityText));
        pageSettings.put("writerPoolCapacity", this.text(this.writerPoolCapacityText));
    }

    @Override
    protected boolean collectRepositoryProperties(Map<String, Object> repositoryProperties) {
        repositoryProperties.put("storeXMLConfig", this.createStoreXML(this.storeType));
        return true;
    }

    protected String createStoreXML(StoreType storeType) {
        HashMap<String, Object> storeProperties = new HashMap<String, Object>();
        storeProperties.put("path", this.text(this.storePathText));
        storeProperties.put("connectionKeepAlivePeriod", this.text(this.connectionKeepAlivePeriodText));
        storeProperties.put("readerPoolCapacity", this.text(this.readerPoolCapacityText));
        storeProperties.put("writerPoolCapacity", this.text(this.writerPoolCapacityText));
        return storeType.getStoreXML(storeProperties);
    }
}

