/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.figures.processes;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;

public class DiamondBorder
extends LineBorder {
    private Point topPoint = new Point();
    private Point rightPoint = new Point();
    private Point bottomPoint = new Point();
    private Point leftPoint = new Point();

    public DiamondBorder() {
        super(PreferenceReader.appearanceBorderColor.get(), PreferenceReader.appearanceLineWidth.get());
    }

    public Point getTopPoint() {
        return this.topPoint;
    }

    public Point getRightPoint() {
        return this.rightPoint;
    }

    public Point getBottomPoint() {
        return this.bottomPoint;
    }

    public Point getLeftPoint() {
        return this.leftPoint;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        boolean drawShadow;
        tempRect.setBounds(DiamondBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        graphics.setLineWidth(this.getWidth());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        if (drawShadow = PreferenceReader.appearanceShadowVisible.get()) {
            DiamondBorder.tempRect.width -= 2;
            DiamondBorder.tempRect.height -= 2;
        }
        int dx = DiamondBorder.tempRect.width / 2;
        int dy = DiamondBorder.tempRect.height / 2;
        PointList pointList = new PointList();
        this.topPoint = new Point(DiamondBorder.tempRect.x + dx, DiamondBorder.tempRect.y);
        this.rightPoint = new Point(DiamondBorder.tempRect.x + DiamondBorder.tempRect.width, DiamondBorder.tempRect.y + dy);
        this.bottomPoint = new Point(DiamondBorder.tempRect.x + dx, DiamondBorder.tempRect.y + DiamondBorder.tempRect.height);
        this.leftPoint = new Point(DiamondBorder.tempRect.x, DiamondBorder.tempRect.y + dy);
        if (PreferenceReader.appearanceShadowVisible.get()) {
            pointList.removeAllPoints();
            pointList.addPoint(this.topPoint.x + 2, this.topPoint.y + 2);
            pointList.addPoint(this.rightPoint.x + 2, this.rightPoint.y + 2);
            pointList.addPoint(this.bottomPoint.x + 2, this.bottomPoint.y + 2);
            pointList.addPoint(this.leftPoint.x + 2, this.leftPoint.y + 2);
            graphics.setAlpha(50);
            graphics.setBackgroundColor(PreferenceReader.appearanceShadowColor.get());
            graphics.fillPolygon(pointList);
            pointList.removeAllPoints();
            pointList.addPoint(this.topPoint.x, this.topPoint.y);
            pointList.addPoint(this.rightPoint.x, this.rightPoint.y);
            pointList.addPoint(this.bottomPoint.x, this.bottomPoint.y);
            pointList.addPoint(this.leftPoint.x, this.leftPoint.y);
            graphics.setAlpha(255);
            graphics.setBackgroundColor(figure.getBackgroundColor());
            graphics.fillPolygon(pointList);
        }
        pointList.removeAllPoints();
        pointList.addPoint(this.topPoint.x, this.topPoint.y);
        pointList.addPoint(this.rightPoint.x, this.rightPoint.y);
        pointList.addPoint(this.bottomPoint.x, this.bottomPoint.y);
        pointList.addPoint(this.leftPoint.x, this.leftPoint.y);
        graphics.drawPolygon(pointList);
    }
}

