/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre.util;

import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.generic.ConstantPoolGen;
import org.eclipse.objectteams.otre.ObjectTeamsTransformation;

public class AnnotationHelper {
    public static boolean containsImplicitActivationAttribute(Attribute[] attrs, ConstantPoolGen cpg) {
        if (attrs != null) {
            Attribute[] attributeArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attr = attributeArray[n2];
                if (attr instanceof Unknown && ((Unknown)attr).getName().equals("RuntimeVisibleAnnotations")) {
                    Unknown unknown = (Unknown)attr;
                    byte[] bytes = unknown.getBytes();
                    int len = ObjectTeamsTransformation.combineTwoBytes(bytes, 0);
                    int i = 2;
                    String[] names = new String[1];
                    int n3 = 0;
                    while (n3 < len) {
                        i = ObjectTeamsTransformation.scanStrings(names, bytes, i, cpg);
                        if ("Lorg/objectteams/ImplicitTeamActivation;".equals(names[0])) {
                            return true;
                        }
                        i = AnnotationHelper.skipNameValuePairs(bytes, i, names[0], cpg);
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private static int skipNameValuePairs(byte[] bytes, int i, String typeName, ConstantPoolGen cpg) {
        int numPairs = ObjectTeamsTransformation.combineTwoBytes(bytes, i);
        i += 2;
        int p = 0;
        while (p < numPairs) {
            i = AnnotationHelper.skipElementValue(bytes, i + 2, typeName, cpg);
            ++p;
        }
        return i;
    }

    private static int skipElementValue(byte[] bytes, int i, String typeName, ConstantPoolGen cpg) {
        byte tag = bytes[i++];
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 99: 
            case 115: {
                i += 2;
                break;
            }
            case 101: {
                i += 4;
                break;
            }
            case 64: {
                String[] typeName2 = new String[1];
                i = ObjectTeamsTransformation.scanStrings(typeName2, bytes, i, cpg);
                i = AnnotationHelper.skipNameValuePairs(bytes, i, typeName2[0], cpg);
                break;
            }
            case 91: {
                int numArrayVals = ObjectTeamsTransformation.combineTwoBytes(bytes, i);
                i += 2;
                int j = 0;
                while (j < numArrayVals) {
                    i = AnnotationHelper.skipElementValue(bytes, i, typeName, cpg);
                    ++j;
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected element value kind in annotation: " + typeName);
            }
        }
        return i;
    }
}

