/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.commands;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ocl.xtext.base.ui.OCLProjectHelper;
import org.eclipse.ocl.xtext.base.ui.commands.ToggleNatureCommand;
import org.eclipse.ocl.xtext.base.ui.messages.BaseUIMessages;
import org.eclipse.ocl.xtext.base.ui.utilities.BaseUIUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleOCLNatureCommand
extends AbstractHandler
implements ToggleNatureCommand {
    private static final Logger log = Logger.getLogger(ToggleOCLNatureCommand.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IProject project = null;
                if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                this.toggleNature(project);
            }
        }
        return null;
    }

    @Override
    public String getAddNatureDialogText(String projectName) {
        return NLS.bind((String)BaseUIMessages.OCLNatureAddingEditorCallback_MessageDialog_Message, (Object)projectName);
    }

    @Override
    public String getAddNatureDialogTitle() {
        return BaseUIMessages.OCLNatureAddingEditorCallback_MessageDialog_Title;
    }

    @Override
    public @NonNull String getAddNatureKey() {
        return "add_ocl_nature";
    }

    @Override
    public boolean hasNature(@NonNull IProject project) {
        return OCLProjectHelper.hasNature(project);
    }

    @Override
    public void toggleNature(@NonNull IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            assert (description != null);
            BaseUIUtil.toggleNature(description, "org.eclipse.ocl.pivot.ui.oclnature");
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            log.error((Object)"Error toggling OCL nature", (Throwable)e);
        }
    }
}

