/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.internal.sync;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.IExecutorPolicy;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.sync.service.ISyncService;
import org.eclipse.papyrus.infra.ui.util.UIUtil;
import org.eclipse.swt.widgets.Display;

public class UISyncServiceInitializer
implements IService {
    private ServicesRegistry registry;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    public void startService() throws ServiceException {
        ISyncService syncService = (ISyncService)this.registry.getService(ISyncService.class);
        syncService.setAsyncExecutor((Executor)new UISyncServiceExecutorService(syncService.getEditingDomain()));
    }

    public void disposeService() throws ServiceException {
    }

    private static class UISyncServiceExecutorService
    extends AbstractExecutorService {
        private final ExecutorService uiExecutor = UIUtil.createUIExecutor((Display)Display.getDefault());
        private final Executor transactionExecutor;

        UISyncServiceExecutorService(TransactionalEditingDomain domain) {
            this.transactionExecutor = TransactionHelper.createTransactionExecutor((TransactionalEditingDomain)domain, (Executor)this.uiExecutor, (IExecutorPolicy)new IExecutorPolicy(){

                public IExecutorPolicy.Ranking rank(Runnable task, Executor executor) {
                    if (executor == uiExecutor) {
                        return IExecutorPolicy.Ranking.ACCEPTABLE;
                    }
                    return Display.getCurrent() == null ? IExecutorPolicy.Ranking.DEPRECATED : IExecutorPolicy.Ranking.PREFERRED;
                }
            });
        }

        @Override
        public void execute(Runnable command) {
            this.transactionExecutor.execute(command);
        }

        @Override
        public void shutdown() {
            this.uiExecutor.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.uiExecutor.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.uiExecutor.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.uiExecutor.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.uiExecutor.awaitTermination(timeout, unit);
        }
    }
}

